/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.FileUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ConfigRecordSet
extends RecordSet {
    protected static final int FILE_VERSION = 1;
    protected static final long FILE_MARKER = 1263332511627593028L;
    protected static RecordSet.RecordReader reader = new RecordSet.RecordReader(){

        @Override
        public BaseRecord read(DataInputStream dataInputStream) throws IOException {
            return ConfigRecord.read(dataInputStream);
        }
    };

    public ConfigRecordSet(int n) {
        super(n);
    }

    public ConfigRecordSet(ConfigRecordSet configRecordSet) {
        this(configRecordSet, configRecordSet.getPersistentRecordMapCopy());
    }

    private ConfigRecordSet(ConfigRecordSet configRecordSet, Map map) {
        super(configRecordSet.getDeviceId());
        this.setPersistedMap(map);
    }

    @Override
    public RecordSet createSubset(Object[] objectArray) {
        return new ConfigRecordSet(this, RecordSet.cloneRecordMap(this.getPersistentRecordMap(), objectArray));
    }

    @Override
    public synchronized void write(DataOutputStream dataOutputStream) throws IOException {
        FileUtils.writeMarkerAndVersion(dataOutputStream, 1263332511627593028L, 1);
        dataOutputStream.writeInt(this.originalDeviceId);
        ConfigRecordSet.writeRecordMap(dataOutputStream, this.volatileRecordMap);
    }

    public static RecordSet read(DataInputStream dataInputStream) throws IOException {
        int n = ConfigRecordSet.readDeviceId(dataInputStream);
        Map map = ConfigRecordSet.readRecordMap(dataInputStream, reader);
        ConfigRecordSet configRecordSet = new ConfigRecordSet(n);
        configRecordSet.setPersistedMap(map);
        return configRecordSet;
    }

    public static int readDeviceId(DataInputStream dataInputStream) throws IOException {
        FileUtils.readFileVersion(dataInputStream, "ConfigRecordSet", 1263332511627593028L, 1);
        int n = dataInputStream.readInt();
        return n;
    }
}

