/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.Float8ListField;
import javax.swing.event.ListDataListener;

public class Float16ListField
extends Float8ListField
implements ListDataListener {
    public Float16ListField(int n) {
        this(1.0f, 0.0f, 65535.0f, 0.0f, n);
    }

    public Float16ListField(float f, float f2, float f3, float f4, int n) {
        super(f, f2, f3, f4, n);
        this.minRawValue = 0;
        this.maxRawValue = 65535;
    }

    @Override
    public void setFromBytes(int[] nArray, int n) {
        int[] nArray2 = new int[this.storedValues.getSize()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i * 2 + n] * 256 + nArray[i * 2 + 1 + n];
        }
        this.setStoredValues(this.convertFromRawValues(nArray2));
    }

    @Override
    public void putToBytes(int[] nArray, int n) {
        int[] nArray2 = this.convertToRawValues(Float16ListField.convertToFloatArray(this.storedValues));
        for (int i = 0; i < nArray2.length; ++i) {
            nArray[i * 2 + n] = (nArray2[i] & 0xFF00) >> 8;
            nArray[i * 2 + 1 + n] = nArray2[i] & 0xFF;
        }
    }

    @Override
    public int getByteLength() {
        return super.getByteLength() * 2;
    }
}

