/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseField;

public class Float8Field
extends BaseField {
    protected float minValue;
    protected float maxValue;
    protected float offsetValue;
    private Float storedValue;
    protected int minRawValue;
    protected int maxRawValue;
    protected float scaleFactor;
    protected boolean reciprocate = false;

    public Float8Field(float f, float f2, float f3, float f4) {
        this.scaleFactor = f;
        this.minValue = f2;
        this.maxValue = f3;
        this.offsetValue = f4;
        this.minRawValue = 0;
        this.maxRawValue = 255;
        this.storedValue = new Float(this.minValue);
    }

    public void reciprocateRaw() {
        this.reciprocate = true;
        this.minRawValue = 1;
    }

    public boolean isReciprocateRaw() {
        return this.reciprocate;
    }

    protected int getRawStepValue() {
        return 1;
    }

    public Float nextStepValue(Float f) {
        return this.stepValue(f, this.reciprocate ? -this.getRawStepValue() : this.getRawStepValue());
    }

    public Float previousStepValue(Float f) {
        return this.stepValue(f, this.reciprocate ? this.getRawStepValue() : -this.getRawStepValue());
    }

    private Float stepValue(Float f, int n) {
        float f2 = f.floatValue();
        int n2 = this.convertToRawValue(f2);
        int n3 = n2 + n;
        float f3 = this.convertFromRawValue(n3);
        return new Float(f3);
    }

    public Object getValue() {
        return this.storedValue;
    }

    public void setValue(Object object) {
        Float f = null;
        try {
            f = (Float)object;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof Number) {
                f = new Float(((Number)object).floatValue());
            }
            throw classCastException;
        }
        Float f2 = this.storedValue;
        this.storedValue = new Float(this.checkValue(f.floatValue()));
        if (!f2.equals(this.storedValue)) {
            this.fireValueChange(f2, this.storedValue);
        } else if (!f.equals(this.storedValue)) {
            this.fireValueChange(null, this.storedValue);
        }
    }

    public float checkValue(float f) {
        return this.convertFromRawValue(this.convertToRawValue(f));
    }

    protected int scaleToRawValue(float f) {
        if (this.reciprocate) {
            return Math.round(this.scaleFactor / f);
        }
        return Math.round(f / this.scaleFactor);
    }

    protected float scaleFromRawValue(int n) {
        if (this.reciprocate) {
            return this.scaleFactor / (float)n;
        }
        return (float)n * this.scaleFactor;
    }

    public int convertToRawValue(float f) {
        f = (f -= this.offsetValue) < this.minValue ? this.minValue : (f > this.maxValue ? this.maxValue : f);
        int n = this.scaleToRawValue(f);
        n = n < this.minRawValue ? this.minRawValue : (n > this.maxRawValue ? this.maxRawValue : n);
        return n;
    }

    public float convertFromRawValue(int n) {
        n = n < this.minRawValue ? this.minRawValue : (n > this.maxRawValue ? this.maxRawValue : n);
        float f = this.scaleFromRawValue(n);
        f = f < this.minValue ? this.minValue : (f > this.maxValue ? this.maxValue : f);
        return f += this.offsetValue;
    }

    @Override
    public void setFromBytes(int[] nArray, int n) {
        this.setValue(new Float(this.convertFromRawValue(nArray[n])));
    }

    @Override
    public void putToBytes(int[] nArray, int n) {
        nArray[n] = this.convertToRawValue(this.storedValue.floatValue());
    }

    @Override
    public int getByteLength() {
        return 1;
    }

    @Override
    public Object clone() {
        Float8Field float8Field = (Float8Field)super.clone();
        float8Field.dropChangeSupport();
        return float8Field;
    }

    public String toString() {
        return this.storedValue.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Float8Field)) {
            return false;
        }
        Float8Field float8Field = (Float8Field)object;
        return float8Field.minRawValue == this.minRawValue && float8Field.maxRawValue == this.maxRawValue && float8Field.maxValue == this.maxValue && float8Field.minValue == this.minValue && float8Field.offsetValue == this.offsetValue && float8Field.scaleFactor == this.scaleFactor && float8Field.storedValue.floatValue() == this.storedValue.floatValue();
    }

    public boolean equalsWithin(Float8Field float8Field, float f) {
        return Math.abs(this.storedValue.floatValue() - float8Field.storedValue.floatValue()) <= f;
    }

    public static boolean equalsWithin(Float f, Float f2, float f3) {
        return Math.abs(f.floatValue() - f2.floatValue()) <= f3;
    }

    public static boolean equalsWithin(float f, float f2, float f3) {
        return Math.abs(f - f2) <= f3;
    }

    public int hashCode() {
        int n = 0;
        n = this.minRawValue;
        n += 31 * this.maxRawValue;
        n = (int)((float)n + 31.0f * this.maxValue);
        n = (int)((float)n + 31.0f * this.minValue);
        n = (int)((float)n + 31.0f * this.offsetValue);
        n += 31 * Float.floatToRawIntBits(this.scaleFactor);
        return n += 31 * Float.floatToRawIntBits(this.storedValue.floatValue());
    }
}

