/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.model.StrictArrayListModel;
import com.jgoodies.binding.list.ArrayListModel;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Float8ListField
extends Float8Field
implements ListDataListener {
    protected StrictArrayListModel storedValues;
    private static final Class[] parmTypesListDataEvent = new Class[]{ListDataEvent.class};

    public Float8ListField(int n) {
        this(1.0f, 0.0f, 255.0f, 0.0f, n);
    }

    public Float8ListField(float f, float f2, float f3, float f4, int n) {
        super(f, f2, f3, f4);
        this.storedValues = new StrictArrayListModel(n, new Float(f2), this);
    }

    @Override
    public Object getValue() {
        return this.storedValues;
    }

    public Float get(int n) {
        return (Float)this.storedValues.get(n);
    }

    public void put(int n, Float f) {
        this.storedValues.set(n, f);
    }

    @Override
    public void setValue(Object object) {
        float[] fArray = Float8ListField.convertToFloatArray((ArrayListModel)object);
        float[] fArray2 = Float8ListField.convertToFloatArray(this.storedValues);
        float[] fArray3 = this.checkValues(fArray);
        this.setStoredValues(fArray3);
        if (!Arrays.equals(fArray2, fArray3) || !Arrays.equals(fArray, fArray3)) {
            this.fireValueChange(null, (Object)this.storedValues);
        }
    }

    public float[] checkValues(float[] fArray) {
        return this.convertFromRawValues(this.convertToRawValues(fArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        this.storedValues.setPrimaryListener(null);
        try {
            for (int i = n; i <= n2; ++i) {
                float f = ((Float)this.storedValues.get(i)).floatValue();
                float f2 = this.checkValue(f);
                this.storedValues.set(i, new Float(f2));
            }
        }
        finally {
            this.storedValues.setPrimaryListener(this);
        }
        this.fireValueChange(null, (Object)this.storedValues);
        this.storedValues._fireContentsChanged(n, n2);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        throw new IllegalStateException("Illegal change to ArrayListModel in a Float8ListField");
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        throw new IllegalStateException("Illegal change to ArrayListModel in a Float8ListField");
    }

    protected int[] convertToRawValues(float[] fArray) {
        int n = fArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.convertToRawValue(fArray[i]);
        }
        return nArray;
    }

    protected float[] convertFromRawValues(int[] nArray) {
        int n = nArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.convertFromRawValue(nArray[i]);
        }
        return fArray;
    }

    protected final void setStoredValues(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            Float f = (Float)this.storedValues.get(i);
            if (f.floatValue() == fArray[i]) continue;
            this.storedValues.set(i, new Float(fArray[i]));
        }
    }

    protected static final float[] convertToFloatArray(ArrayListModel arrayListModel) {
        float[] fArray = new float[arrayListModel.getSize()];
        Iterator iterator = arrayListModel.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            fArray[n++] = ((Float)iterator.next()).floatValue();
        }
        return fArray;
    }

    @Override
    public void setFromBytes(int[] nArray, int n) {
        int[] nArray2 = new int[this.storedValues.getSize()];
        System.arraycopy(nArray, n, nArray2, 0, nArray2.length);
        this.setStoredValues(this.convertFromRawValues(nArray2));
    }

    @Override
    public void putToBytes(int[] nArray, int n) {
        int[] nArray2 = this.convertToRawValues(Float8ListField.convertToFloatArray(this.storedValues));
        System.arraycopy(nArray2, 0, nArray, n, nArray2.length);
    }

    @Override
    public int getByteLength() {
        return this.storedValues.getSize();
    }

    @Override
    public Object clone() {
        Float8ListField float8ListField = (Float8ListField)super.clone();
        float8ListField.dropChangeSupport();
        float8ListField.storedValues = new StrictArrayListModel(this.storedValues, float8ListField);
        return float8ListField;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = this.storedValues.getSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.storedValues.get(i).toString());
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Float8ListField)) {
            return false;
        }
        Float8ListField float8ListField = (Float8ListField)object;
        return super.equals(object) && float8ListField.storedValues.equals((Object)this.storedValues);
    }

    @Override
    public int hashCode() {
        return this.storedValues.hashCode();
    }
}

