/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.util.ListUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public abstract class RecordSet {
    protected final int originalDeviceId;
    protected Map persistedRecordMap = new HashMap();
    protected Map volatileRecordMap = new HashMap();
    private static final Logger logger = Logger.getLogger(RecordSet.class.getName());

    protected RecordSet(int n) {
        this.originalDeviceId = n;
    }

    public abstract RecordSet createSubset(Object[] var1);

    public abstract void write(DataOutputStream var1) throws IOException;

    public boolean isEmpty() {
        return this.persistedRecordMap.isEmpty();
    }

    public void setPersistedMap(Map map) {
        this.persistedRecordMap = map;
        this.volatileRecordMap = RecordSet.cloneRecordMap(this.persistedRecordMap);
    }

    public static Map cloneRecordMap(Map map) {
        return RecordSet.cloneRecordMap(map, null);
    }

    protected static Map cloneRecordMap(Map map, Object[] objectArray) {
        HashMap<Object, BaseRecord> hashMap = new HashMap<Object, BaseRecord>();
        for (BaseRecord baseRecord : map.values()) {
            if (objectArray != null && !ListUtil.contains(objectArray, baseRecord.getRecordID())) continue;
            BaseRecord baseRecord2 = (BaseRecord)baseRecord.clone();
            hashMap.put(baseRecord.getRecordID(), baseRecord2);
        }
        return hashMap;
    }

    public void copyVolatileToPersistent() {
        Iterator iterator = this.volatileRecordMap.values().iterator();
        while (iterator.hasNext()) {
            this.updatePersistedRecord((BaseRecord)iterator.next());
        }
    }

    public Map getVolatileRecordMap() {
        return this.volatileRecordMap;
    }

    public Map getPersistentRecordMap() {
        return this.persistedRecordMap;
    }

    public Map getPersistentRecordMapCopy() {
        return RecordSet.cloneRecordMap(this.persistedRecordMap);
    }

    public static boolean containsRecordId(int n, Map map) {
        return RecordSet.containsRecordId(new Integer(n), map);
    }

    public static boolean containsRecordId(Integer n, Map map) {
        return map.containsKey(n);
    }

    public static boolean containsAnyRecordId(int[] nArray, Map map) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!RecordSet.containsRecordId(nArray[i], map)) continue;
            return true;
        }
        return false;
    }

    public static BaseRecord getRecord(int[] nArray, Map map) {
        for (int i = 0; i < nArray.length; ++i) {
            BaseRecord baseRecord = RecordSet.getRecord(nArray[i], map);
            if (baseRecord == null) continue;
            return baseRecord;
        }
        return null;
    }

    public static BaseRecord getRecord(int n, Map map) {
        return RecordSet.getRecord(new Integer(n), map);
    }

    public static BaseRecord getRecord(Object object, Map map) {
        return (BaseRecord)map.get(object);
    }

    protected static void writeRecordMap(DataOutputStream dataOutputStream, Map map) throws IOException {
        dataOutputStream.writeInt(map.size());
        for (BaseRecord baseRecord : map.values()) {
            baseRecord.write(dataOutputStream);
        }
    }

    protected static Map readRecordMap(DataInputStream dataInputStream, RecordReader recordReader) throws IOException {
        int n = dataInputStream.readInt();
        TreeMap<Object, BaseRecord> treeMap = new TreeMap<Object, BaseRecord>();
        for (int i = 0; i < n; ++i) {
            BaseRecord baseRecord = recordReader.read(dataInputStream);
            if (baseRecord == null) continue;
            treeMap.put(baseRecord.getRecordID(), baseRecord);
        }
        return treeMap;
    }

    public synchronized BaseRecord getVolatileRecord(int n) {
        return RecordSet.getRecord(n, this.volatileRecordMap);
    }

    public synchronized BaseRecord getVolatileRecord(Object object) {
        return RecordSet.getRecord(object, this.volatileRecordMap);
    }

    public synchronized BaseRecord getPersistedRecord(Object object) {
        return RecordSet.getRecord(object, this.persistedRecordMap);
    }

    public synchronized BaseRecord getPersistedRecord(int n) {
        return this.getPersistedRecord(new Integer(n));
    }

    public synchronized BaseRecord getVolatileRecord(int[] nArray) {
        return RecordSet.getRecord(nArray, this.volatileRecordMap);
    }

    public synchronized BaseRecord getVolatileRecord(Object[] objectArray) {
        return RecordSet.getRecord(objectArray, this.volatileRecordMap);
    }

    public int getDeviceId() {
        return this.originalDeviceId;
    }

    public synchronized void updatePersistedRecord(BaseRecord baseRecord) {
        BaseRecord baseRecord2 = (BaseRecord)this.persistedRecordMap.get(baseRecord.getRecordID());
        if (baseRecord2 == null) {
            logger.warning("updatePersistedRecord called for unsupported record ID " + baseRecord.getRecordID());
            return;
        }
        baseRecord2.copyRawDataFrom(baseRecord);
    }

    public synchronized void updateVolatileRecord(BaseRecord baseRecord) {
        BaseRecord baseRecord2 = (BaseRecord)this.volatileRecordMap.get(baseRecord.getRecordID());
        if (baseRecord2 == null) {
            logger.warning("updateVolatileRecord called for unsupported record ID " + baseRecord.getRecordID());
            return;
        }
        baseRecord2.copyRawDataFrom(baseRecord);
    }

    protected static interface RecordReader {
        public BaseRecord read(DataInputStream var1) throws IOException;
    }
}

