/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.Float16Field;

public class SignedInt16Field
extends Float16Field {
    boolean negateReal = false;

    public SignedInt16Field() {
        this(-32768.0f, 32767.0f);
    }

    public SignedInt16Field(boolean bl) {
        this(bl ? -32767.0f : -32768.0f, bl ? 32768.0f : 32767.0f);
        this.negateReal = bl;
    }

    public SignedInt16Field(float f, float f2) {
        super(1.0f, f, f2, 0.0f);
    }

    public SignedInt16Field(float f, float f2, float f3) {
        super(f, f2, f3, 0.0f);
    }

    @Override
    public Float nextStepValue(Float f) {
        float f2 = f.floatValue();
        int n = this.convertToRawValue(f2);
        int n2 = this.advanceRaw(n, true);
        float f3 = this.convertFromRawValue(n2);
        return new Float(f3);
    }

    private int advanceRaw(int n, boolean bl) {
        int n2;
        if (bl ^= this.negateReal) {
            n2 = n + 1;
            if (n2 > 65535) {
                n2 = 0;
            } else if (n < 32768 && n2 > Short.MAX_VALUE) {
                n2 = Short.MAX_VALUE;
            }
        } else {
            n2 = n - 1;
            if (n2 < 0) {
                n2 = 65535;
            } else if (n > Short.MAX_VALUE && n2 < 32768) {
                n2 = 32768;
            }
        }
        return n2;
    }

    @Override
    public Float previousStepValue(Float f) {
        float f2 = f.floatValue();
        int n = this.convertToRawValue(f2);
        int n2 = this.advanceRaw(n, false);
        float f3 = this.convertFromRawValue(n2);
        return new Float(f3);
    }

    @Override
    protected int scaleToRawValue(float f) {
        f /= this.scaleFactor;
        if (this.negateReal) {
            f = -f;
        }
        if (f < 0.0f) {
            f += 65536.0f;
        }
        return Math.round(f);
    }

    @Override
    protected float scaleFromRawValue(int n) {
        if (n > Short.MAX_VALUE) {
            n -= 65536;
        }
        if (this.negateReal) {
            n = -n;
        }
        return (float)n * this.scaleFactor;
    }
}

