/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.device.records;

import com.ecmtuning.ecmlink.device.records.Float8Field;

public class SignedInt8Field
extends Float8Field {
    boolean negateReal = false;

    public SignedInt8Field() {
        this(-128.0f, 127.0f);
    }

    public SignedInt8Field(boolean bl) {
        this(bl ? -127.0f : -128.0f, bl ? 128.0f : 127.0f);
        this.negateReal = bl;
    }

    public SignedInt8Field(float f, float f2) {
        super(1.0f, f, f2, 0.0f);
    }

    public SignedInt8Field(float f, float f2, float f3) {
        super(f, f2, f3, 0.0f);
    }

    @Override
    public Float nextStepValue(Float f) {
        float f2 = f.floatValue();
        int n = this.convertToRawValue(f2);
        int n2 = this.advanceRaw(n, true);
        float f3 = this.convertFromRawValue(n2);
        return new Float(f3);
    }

    private int advanceRaw(int n, boolean bl) {
        int n2;
        if (bl ^= this.negateReal) {
            n2 = n + 1;
            if (n2 > 255) {
                n2 = 0;
            } else if (n < 128 && n2 > 127) {
                n2 = 127;
            }
        } else {
            n2 = n - 1;
            if (n2 < 0) {
                n2 = 255;
            } else if (n > 127 && n2 < 128) {
                n2 = 128;
            }
        }
        return n2;
    }

    @Override
    public Float previousStepValue(Float f) {
        float f2 = f.floatValue();
        int n = this.convertToRawValue(f2);
        int n2 = this.advanceRaw(n, false);
        float f3 = this.convertFromRawValue(n2);
        return new Float(f3);
    }

    @Override
    protected int scaleToRawValue(float f) {
        f /= this.scaleFactor;
        if (this.negateReal) {
            f = -f;
        }
        if (f < 0.0f) {
            f += 256.0f;
        }
        return Math.round(f);
    }

    @Override
    protected float scaleFromRawValue(int n) {
        if (n > 127) {
            n -= 256;
        }
        if (this.negateReal) {
            n = -n;
        }
        return (float)n * this.scaleFactor;
    }
}

