/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.gui;

public class FloatRect {
    private float x;
    private float y;
    private float width;
    private float height;
    private float xPrec = 100.0f;
    private float yPrec = 100.0f;

    public FloatRect() {
    }

    public FloatRect(float f, float f2, float f3, float f4) {
        this.setX(f);
        this.setY(f2);
        this.setWidth(f3);
        this.setHeight(f4);
    }

    public FloatRect(FloatRect floatRect) {
        this.setX(floatRect.x);
        this.setY(floatRect.y);
        this.setWidth(floatRect.width);
        this.setHeight(floatRect.height);
    }

    public void setCorners(float f, float f2, float f3, float f4) {
        this.setX(f);
        this.setY(f2);
        this.setWidth(f3 - f);
        this.setHeight(f4 - f2);
    }

    public FloatRect clipRect(FloatRect floatRect) {
        FloatRect floatRect2 = new FloatRect(floatRect);
        floatRect2.setMinX(this.getX());
        floatRect2.setMinY(this.getY());
        floatRect2.setMaxX(this.getMaxX());
        floatRect2.setMaxY(this.getMaxY());
        return floatRect2;
    }

    public FloatRect shiftAndClipRect(FloatRect floatRect) {
        FloatRect floatRect2 = new FloatRect(floatRect);
        if (floatRect2.getMaxX() > this.getMaxX()) {
            floatRect2.setX(floatRect2.getX() - (floatRect2.getMaxX() - this.getMaxX()));
        }
        if (floatRect2.getMaxY() > this.getMaxY()) {
            floatRect2.setY(floatRect2.getY() - (floatRect2.getMaxY() - this.getMaxY()));
        }
        return this.clipRect(floatRect2);
    }

    private static float clip(float f, float f2) {
        return (float)Math.round(f * f2) / f2;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.height = FloatRect.clip(f, this.yPrec);
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = FloatRect.clip(f, this.xPrec);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = FloatRect.clip(f, this.xPrec);
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = FloatRect.clip(f, this.yPrec);
    }

    public float getMaxX() {
        return this.x + this.width;
    }

    public void setMaxX(float f) {
        if (f < this.getMaxX()) {
            this.width -= this.getMaxX() - f;
        }
    }

    public float getMaxY() {
        return this.y + this.height;
    }

    public void setMaxY(float f) {
        if (f < this.getMaxY()) {
            this.height -= this.getMaxY() - f;
        }
    }

    public void setMinX(float f) {
        if (f > this.getX()) {
            this.setX(f);
        }
    }

    public void setMinY(float f) {
        if (f > this.getY()) {
            this.setY(f);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatRect)) {
            return false;
        }
        FloatRect floatRect = (FloatRect)object;
        return this.x == floatRect.x && this.y == floatRect.y && this.width == floatRect.width && this.height == floatRect.height;
    }

    public int hashCode() {
        int n = 0;
        n += 31 * Float.floatToRawIntBits(this.x);
        n += 31 * Float.floatToRawIntBits(this.y);
        n += 31 * Float.floatToRawIntBits(this.width);
        return n += 31 * Float.floatToRawIntBits(this.height);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
    }
}

