/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.gui.chart;

import com.ecmtuning.ecmlink.gui.chart.DisplayedValueAdjuster;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.Number2StringFilter;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.ui.HandyTableColumnModel;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.builder.PopupMenuBuilder;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public abstract class BaseTblDataAdapter
extends Model {
    public static final String PROPERTYNAME_DISPLAY_TYPE = "displayType";
    public static final String PROPERTYNAME_TEMPLATE_SELECTION_NAMES = "templateSelectionNames";
    public static final String PROPERTYNAME_TEMPLATE_SELECTION_INDEX = "templateSelectionIndex";
    public static final String PROPERTYNAME_TEMPLATE_VISIBLE = "templateVisible";
    protected static final int COLUMN_TYPE_DATA = 0;
    protected static final int COLUMN_TYPE_ROW_HEADER = 1;
    protected static final int COLUMN_TYPE_COLUMN_HEADER = 2;
    public static final Integer DEFAULT_DISPLAY_TYPE = new Integer(0);
    protected boolean hasTemplate = false;
    protected int dataColumnCount;
    protected int dataRowCount;
    protected ValueModel rawRowHeaderModel;
    protected ValueModel rawColumnHeaderModel;
    protected ValueModel rawDataModel;
    protected ValueModel rawTemplateModel;
    protected ListModelPlug stringRowHeaderModel;
    protected ListModelPlug stringColumnHeaderModel;
    protected ListModelPlug stringDataModel;
    protected ListModelPlug stringTemplateModel;
    protected Number2StringFilter rowHeaderStringFilter;
    protected Number2StringFilter columnHeaderStringFilter;
    protected Number2StringFilter dataStringFilter;
    protected Number2StringFilter templateStringFilter;
    private String[][] tableColumnPrototypes;
    private Integer displayType = DEFAULT_DISPLAY_TYPE;
    private ArrayList templateSelectionNames = new ArrayList();
    private Integer templateSelectionIndex = TEMPLATE_SELECTION_INDEX_NONE;
    public static final Integer TEMPLATE_SELECTION_INDEX_NONE = new Integer(-1);
    private Boolean templateVisible = Boolean.FALSE;
    protected final LocalTableModel tableModel = new LocalTableModel();
    protected final HandyTableColumnModel dataColumnModel = new HandyTableColumnModel();
    protected List extraPopupActions;

    protected void construct(String string) {
        this.construct(new String[]{string});
    }

    protected void construct(String[] stringArray) {
        this.rawDataModel = this.createRawDataModel();
        this.rawTemplateModel = this.createRawTemplateModel();
        this.hasTemplate = this.rawTemplateModel != null;
        this.rawRowHeaderModel = this.createRawRowHeaderModel();
        this.rawColumnHeaderModel = this.createRawColumnHeaderModel();
        this.stringRowHeaderModel = this.createStringRowHeaderModel();
        this.stringColumnHeaderModel = this.createStringColumnHeaderModel();
        this.stringDataModel = this.createStringDataModel();
        if (this.getHasTemplate()) {
            this.stringTemplateModel = this.createStringTemplateModel();
        }
        this.dataColumnCount = this.tblMdl_getColumnCount();
        this.dataRowCount = this.tblMdl_getRowCount();
        String[] stringArray2 = new String[this.dataColumnCount + stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        Iterator iterator = this.stringColumnHeaderModel.getLocalArrayListValue().iterator();
        int n = stringArray.length;
        while (iterator.hasNext()) {
            stringArray2[n++] = (String)iterator.next();
        }
        this.tableColumnPrototypes = new String[this.dataColumnCount + 1][];
        Arrays.fill((Object[])this.tableColumnPrototypes, stringArray2);
    }

    protected abstract ValueModel createRawRowHeaderModel();

    protected abstract ValueModel createRawColumnHeaderModel();

    protected abstract ValueModel createRawDataModel();

    protected ValueModel createRawTemplateModel() {
        return null;
    }

    protected void addDataFilters(ListModelPlug listModelPlug) {
    }

    protected void handleNewDisplayType() {
    }

    protected void handleNewTemplateSelectionIndex(int n) {
    }

    protected int getRowHeaderPrec() {
        return 0;
    }

    protected int getColumnHeaderPrec() {
        return 0;
    }

    protected int getDataPrec() {
        return 0;
    }

    protected abstract void fireDataModelChanged(int var1, int var2);

    protected abstract void rowHeaderModelChanged(int var1);

    public final boolean getHasTemplate() {
        return this.hasTemplate;
    }

    public void setDisplayType(Integer n) {
        Integer n2 = this.displayType;
        if (!n.equals(this.displayType)) {
            this.displayType = n;
            this.handleNewDisplayType();
            this.stringDataModel.resetLocalValue();
            if (this.getHasTemplate()) {
                this.stringTemplateModel.resetLocalValue();
            }
            this.firePropertyChange(PROPERTYNAME_DISPLAY_TYPE, n2, n);
        }
    }

    public Integer getDisplayType() {
        return this.displayType;
    }

    public void setTemplateVisible(Boolean bl) {
        Boolean bl2 = this.templateVisible;
        this.templateVisible = bl;
        this.firePropertyChange(PROPERTYNAME_TEMPLATE_VISIBLE, bl2, bl);
    }

    public Boolean getTemplateVisible() {
        return this.templateVisible;
    }

    public ArrayList getTemplateSelectionNames() {
        return this.templateSelectionNames;
    }

    public void setTemplateSelectionNames(ArrayList arrayList) {
        ArrayList arrayList2 = this.templateSelectionNames;
        this.templateSelectionNames = arrayList;
        this.firePropertyChange(PROPERTYNAME_TEMPLATE_SELECTION_NAMES, arrayList2, arrayList);
    }

    public Integer getTemplateSelectionIndex() {
        return this.templateSelectionIndex;
    }

    public void setTemplateSelectionIndex(Integer n) {
        this.setTemplateSelectionIndex(this.templateSelectionIndex, n);
    }

    public void setTemplateSelectionIndex(Integer n, Integer n2) {
        if (n == null || !n.equals(n2)) {
            this.templateSelectionIndex = n2;
            this.handleNewTemplateSelectionIndex(n2);
            this.firePropertyChange(PROPERTYNAME_TEMPLATE_SELECTION_INDEX, n, n2);
        }
    }

    public String[][] getColumnPrototypes() {
        return this.tableColumnPrototypes;
    }

    public AbstractTableModel getDataTableModel() {
        return this.tableModel;
    }

    public HandyTableColumnModel getDataColumnModel() {
        return this.dataColumnModel;
    }

    public void setColumnVisible(int n, boolean bl) {
        Integer n2;
        HandyTableColumnModel handyTableColumnModel = this.getDataColumnModel();
        TableColumn tableColumn = handyTableColumnModel.getColumn(n2 = new Integer(n));
        if (tableColumn != null && !bl) {
            handyTableColumnModel.removeColumn(tableColumn);
        } else if (tableColumn == null && bl) {
            tableColumn = new TableColumn(n);
            tableColumn.setIdentifier(n2);
            tableColumn.setHeaderValue(this.getDataTableModel().getColumnName(n));
            handyTableColumnModel.addColumn(tableColumn);
        }
    }

    protected ListModelPlug createStringRowHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawRowHeaderModel, null, true);
        this.rowHeaderStringFilter = new DynamicNumber2StringFilter(1);
        listModelPlug.addObjectFilter(this.rowHeaderStringFilter);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new LocalListListener(1));
        return listModelPlug;
    }

    protected ListModelPlug createStringColumnHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawColumnHeaderModel, null, true);
        this.columnHeaderStringFilter = new DynamicNumber2StringFilter(2);
        listModelPlug.addObjectFilter(this.columnHeaderStringFilter);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new LocalListListener(2));
        return listModelPlug;
    }

    protected ListModelPlug createStringDataModel() {
        this.dataStringFilter = new DynamicNumber2StringFilter(0);
        return this._createStringDataModel(this.rawDataModel, this.dataStringFilter);
    }

    protected ListModelPlug createStringTemplateModel() {
        this.templateStringFilter = new DynamicNumber2StringFilter(0);
        return this._createStringDataModel(this.rawTemplateModel, this.templateStringFilter);
    }

    protected ListModelPlug _createStringDataModel(ValueModel valueModel, ObjectFilter objectFilter) {
        ListModelPlug listModelPlug = new ListModelPlug(valueModel, null, true);
        this.addDataFilters(listModelPlug);
        listModelPlug.addObjectFilter(objectFilter);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new LocalListListener(0));
        return listModelPlug;
    }

    protected DisplayedValueAdjuster createValueAdjuster(ValueModel valueModel, ValueModel valueModel2) {
        return new LocalDisplayedValueAdjuster(valueModel, valueModel2);
    }

    protected abstract Number calculateNextRawValue(Number var1, boolean var2);

    public void addPopupAction(Action action) {
        if (this.extraPopupActions == null) {
            this.extraPopupActions = new ArrayList();
        }
        this.extraPopupActions.add(action);
    }

    protected void addExtraPopupActions(PopupMenuBuilder popupMenuBuilder) {
        if (this.extraPopupActions != null) {
            popupMenuBuilder.addSeparator();
            for (Action action : this.extraPopupActions) {
                if (action == null) {
                    popupMenuBuilder.addSeparator();
                    continue;
                }
                if (action instanceof ToggleAction) {
                    popupMenuBuilder.addToggle((ToggleAction)action);
                    continue;
                }
                popupMenuBuilder.add(action);
            }
        }
    }

    protected int dataModelIndex(int n, int n2) {
        return n2 * this.dataColumnCount + n;
    }

    protected int dataModelRow(int n) {
        return n / this.dataColumnCount;
    }

    protected int dataModelColumn(int n) {
        int n2 = this.dataModelRow(n);
        return n - n2 * this.dataColumnCount;
    }

    protected int tblMdl_getRowCount() {
        return this.stringRowHeaderModel.getLocalArrayListValue().getSize();
    }

    protected String tblMdl_getColumnName(int n) {
        return (String)this.stringColumnHeaderModel.getLocalArrayListValue().get(n);
    }

    protected int tblMdl_getColumnCount() {
        return this.stringColumnHeaderModel.getLocalArrayListValue().getSize();
    }

    protected boolean tblMdl_isCellEditable(int n, int n2) {
        return true;
    }

    protected Class tblMdl_getColumnClass(int n) {
        return String.class;
    }

    protected Object tblMdl_getValueAt(int n, int n2) {
        return this.stringDataModel.getLocalArrayListValue().get(this.dataModelIndex(n2, n));
    }

    public void tblMdl_setValueAt(Object object, int n, int n2) {
        if (!this.tblMdl_isCellEditable(n, n2)) {
            return;
        }
        this.stringDataModel.getLocalArrayListValue().set(this.dataModelIndex(n2, n), object);
    }

    private final class LocalTableModel
    extends AbstractTableModel {
        private LocalTableModel() {
        }

        public Class getColumnClass(int n) {
            return BaseTblDataAdapter.this.tblMdl_getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return BaseTblDataAdapter.this.tblMdl_isCellEditable(n, n2);
        }

        @Override
        public String getColumnName(int n) {
            return BaseTblDataAdapter.this.tblMdl_getColumnName(n);
        }

        @Override
        public int getColumnCount() {
            return BaseTblDataAdapter.this.tblMdl_getColumnCount();
        }

        @Override
        public int getRowCount() {
            return BaseTblDataAdapter.this.tblMdl_getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return BaseTblDataAdapter.this.tblMdl_getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            BaseTblDataAdapter.this.tblMdl_setValueAt(object, n, n2);
        }
    }

    protected class LocalDisplayedValueAdjuster
    extends DisplayedValueAdjuster {
        public LocalDisplayedValueAdjuster(ValueModel valueModel, ValueModel valueModel2) {
            super(valueModel, valueModel2);
        }

        @Override
        protected Number nextRawValue(Number number, boolean bl) {
            return BaseTblDataAdapter.this.calculateNextRawValue(number, bl);
        }
    }

    protected class LocalValueChangeAction
    extends AbstractAction {
        protected final ListSelectionModel columnSelectionModel;
        protected final ListSelectionModel rowSelectionModel;
        protected final boolean increment;

        public LocalValueChangeAction(ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2, boolean bl) {
            this.columnSelectionModel = listSelectionModel;
            this.rowSelectionModel = listSelectionModel2;
            this.increment = bl;
        }

        protected void adjustValues() {
            ArrayList<Integer> arrayList;
            if (this.columnSelectionModel != null) {
                arrayList = ListUtil.generateSelectedIndicesList(this.columnSelectionModel);
            } else {
                arrayList = new ArrayList<Integer>();
                arrayList.add(new Integer(0));
            }
            List list = ListUtil.generateSelectedIndicesList(this.rowSelectionModel);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = ((Number)iterator.next()).intValue();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    int n2 = ((Number)iterator2.next()).intValue();
                    arrayList2.add(new Integer(BaseTblDataAdapter.this.dataModelIndex(n, n2)));
                }
            }
            DisplayedValueAdjuster displayedValueAdjuster = BaseTblDataAdapter.this.createValueAdjuster(BaseTblDataAdapter.this.stringDataModel, BaseTblDataAdapter.this.rawDataModel);
            displayedValueAdjuster.adjustIndexedValues(arrayList2, this.increment);
            if (this.columnSelectionModel != null) {
                ListUtil.selectIndicesInList(arrayList, this.columnSelectionModel);
            }
            ListUtil.selectIndicesInList(list, this.rowSelectionModel);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.adjustValues();
        }
    }

    protected final class LocalListListener
    implements ListDataListener {
        final int type;

        public LocalListListener(int n) {
            this.type = n;
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                if (this.type == 0) {
                    int n = BaseTblDataAdapter.this.dataModelRow(i);
                    int n2 = BaseTblDataAdapter.this.dataModelColumn(i);
                    BaseTblDataAdapter.this.fireDataModelChanged(n2, n);
                    continue;
                }
                if (this.type == 1) {
                    BaseTblDataAdapter.this.rowHeaderModelChanged(i);
                    continue;
                }
                if (this.type != 2) continue;
                TableColumn tableColumn = BaseTblDataAdapter.this.getDataColumnModel().getColumn(i);
                tableColumn.setHeaderValue(BaseTblDataAdapter.this.stringColumnHeaderModel.getLocalArrayListValue().get(i));
            }
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected class DynamicNumber2StringFilter
    extends Number2StringFilter {
        final int type;

        public DynamicNumber2StringFilter(int n) {
            super(0);
            this.type = n;
        }

        @Override
        public int getPrec() {
            if (this.type == 2) {
                return BaseTblDataAdapter.this.getColumnHeaderPrec();
            }
            if (this.type == 1) {
                return BaseTblDataAdapter.this.getRowHeaderPrec();
            }
            if (this.type == 0) {
                return BaseTblDataAdapter.this.getDataPrec();
            }
            return super.getPrec();
        }
    }
}

