/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.gui.chart;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.ChartModel;
import com.ecmtuning.ecmlink.gui.chart.ChartPlotDesc;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.binding.beans.ExtendedPropertyChangeSupport;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Chart
extends JComponent {
    public static final String PROPERTYNAME_CHART_MODEL = "chartModel";
    public static final String PROPERTYNAME_SELECTION_MODEL = "selectionModel";
    public static final String PROPERTYNAME_SELECTION_RECT = "selectionRect";
    public static final String PROPERTYNAME_VIEWPORT = "viewport";
    ChartModel chartModel;
    ListSelectionModel selectionModel;
    FloatRect selectionRect;
    FloatRect viewport;
    public static final float AXIS_LOC_NONE = Float.MIN_VALUE;
    float yAxisLoc = Float.MIN_VALUE;
    float xAxisLoc = Float.MIN_VALUE;
    protected transient ExtendedPropertyChangeSupport changeSupport;
    boolean displayDone;
    private float unitPanelStartX;
    private float unitPanelStartY;
    private float unitPanelWidth;
    private float unitPanelHeight;
    private int pixelPanelWidth;
    private int pixelPanelHeight;
    private int pixelPanelRight;
    private int pixelPanelBottom;
    private float pixelsPerUnitX;
    private float pixelsPerUnitY;
    int[] pixelXValuesInt;
    int[] pixelYEditValuesInt;
    int editPixelMarkerSize;
    private static final float LINE_SIZE_XY = 1.3f;
    private static final float LINE_SIZE_GRID = 1.0f;
    PropertyChangeListener chartModelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("plotDescs".equals(propertyChangeEvent.getPropertyName())) {
                Chart.this.deregisterDescListeners((List)propertyChangeEvent.getOldValue());
                Chart.this.registerDescListeners((List)propertyChangeEvent.getNewValue());
            }
            Chart.this.repaint();
        }
    };
    PropertyChangeListener plotDescListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Chart.this.repaint();
        }
    };
    ListDataListener yValuesListener = new ListDataListener(){

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (!Chart.this.displayDone) {
                return;
            }
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            if (n != -1 && n2 != -1) {
                int n3 = n == 0 ? 0 : Chart.this.pixelXValuesInt[n - 1];
                int n4 = n2 >= Chart.this.pixelXValuesInt.length - 1 ? Chart.this.pixelPanelRight : Chart.this.pixelXValuesInt[n2 + 1];
                int n5 = n4 - n3 + 1;
                Chart.this.repaint(new Rectangle(n3, 0, n5, Chart.this.pixelPanelHeight));
            }
        }
    };
    private MouseWheelListener mouseWheelListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getWheelRotation() == 0) {
                return;
            }
            float f = (float)mouseWheelEvent.getWheelRotation() * 0.1f;
            Chart.this.zoomByFactor(f);
        }
    };
    private MouseListener mouseListener = new MouseListener(){
        boolean clickGainedFocus = false;

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = Chart.this.getNearestValidEditIndex(mouseEvent.getPoint());
                if (n == -1) {
                    if (!this.clickGainedFocus) {
                        Chart.this.getSelectionModel().clearSelection();
                    }
                } else if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                    Chart.this.changeSelection(2, n);
                } else {
                    Chart.this.changeSelection(1, n);
                }
            }
            Chart.this.mouseMode = 0;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!Chart.this.isFocusOwner()) {
                Chart.this.requestFocusInWindow();
                this.clickGainedFocus = true;
            } else {
                this.clickGainedFocus = false;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                int n = Chart.this.getNearestValidEditIndex(mouseEvent.getPoint());
                if (n == -1) {
                    Chart.this.mouseMode = 2;
                    Chart.this.initialMovePoint = Chart.this.prevZoomPoint = mouseEvent.getPoint();
                    Chart.this.initialMoveViewport = new FloatRect(Chart.this.getViewport());
                    Chart.this.setCursor(Cursor.getPredefinedCursor(13));
                } else {
                    ChartModel chartModel = Chart.this.getChartModel();
                    ListSelectionModel listSelectionModel = Chart.this.getSelectionModel();
                    if (chartModel == null || listSelectionModel == null) {
                        return;
                    }
                    int n2 = chartModel.getEditDescIndex();
                    List list = chartModel.getPlotDescs();
                    if (n2 != -1 && list != null && list.size() > n2) {
                        if (!listSelectionModel.isSelectedIndex(n)) {
                            if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                                Chart.this.changeSelection(2, n);
                            } else {
                                Chart.this.changeSelection(1, n);
                            }
                        }
                        Chart.this.mouseMode = 1;
                        Chart.this.dragStartPoint = mouseEvent.getPoint();
                        Chart.this.dragSelectIndex = n;
                        ChartPlotDesc chartPlotDesc = (ChartPlotDesc)((Object)list.get(n2));
                        Chart.this.dragSelectedIndices = ListUtil.generateSelectedIndicesList(listSelectionModel);
                        Chart.this.dragSelectedValues = ListUtil.generateIndexedValuesList(chartPlotDesc.getYValues(), Chart.this.dragSelectedIndices);
                    }
                    Chart.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Chart.this.mouseMode = 0;
            Chart.this.setCursorForPoint(mouseEvent.getPoint());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Chart.this.setCursorForPoint(mouseEvent.getPoint());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Chart.this.setCursor(null);
        }
    };
    static final int MOUSE_MODE_NONE = 0;
    static final int MOUSE_MODE_SELECT = 1;
    static final int MOUSE_MODE_MOVE = 2;
    Point dragStartPoint = null;
    int dragSelectIndex = -1;
    List dragSelectedIndices;
    List dragSelectedValues;
    Point initialMovePoint = null;
    Point prevZoomPoint = null;
    FloatRect initialMoveViewport = null;
    int mouseMode = 0;
    static final float MOUSE_MOVE_ZOOM_FACTOR = 0.05f;
    static final float STEP_ZOOM_FACTOR = 0.08f;
    static final float STEP_MOVE_FACTOR = 0.08f;
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ListSelectionModel listSelectionModel = Chart.this.getSelectionModel();
            ChartModel chartModel = Chart.this.getChartModel();
            if (Chart.this.mouseMode == 1) {
                int n = chartModel.getEditDescIndex();
                List list = chartModel.getPlotDescs();
                ChartPlotDesc chartPlotDesc = (ChartPlotDesc)((Object)list.get(n));
                List list2 = chartPlotDesc.getYValues();
                float f = (float)(Chart.this.dragStartPoint.getY() - mouseEvent.getPoint().getY()) / Chart.this.pixelsPerUnitY;
                ArrayList arrayList = new ArrayList(Chart.this.dragSelectedValues);
                ListUtil.adjustValuesList(arrayList, f);
                ListUtil.setIndexedValues(list2, Chart.this.dragSelectedIndices, arrayList);
                if (!listSelectionModel.isSelectedIndex(Chart.this.dragSelectIndex)) {
                    ListUtil.selectIndicesInList(Chart.this.dragSelectedIndices, listSelectionModel);
                }
                Chart.this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (Chart.this.mouseMode == 2) {
                if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                    Chart.this.setCursor(Cursor.getPredefinedCursor(8));
                    int n = (int)Math.round(mouseEvent.getPoint().getY() - Chart.this.prevZoomPoint.getY());
                    int n2 = (int)Math.round(Chart.this.getSize().getHeight() * (double)0.05f);
                    boolean bl = n < 0;
                    for (n = Math.abs(n); n >= n2; n -= n2) {
                        if (bl) {
                            Chart.this.zoomByFactor(-0.05f);
                            Chart.this.prevZoomPoint.y -= n2;
                        } else {
                            Chart.this.zoomByFactor(0.05f);
                            Chart.this.prevZoomPoint.y += n2;
                        }
                        Chart.this.prevZoomPoint.x = mouseEvent.getPoint().x;
                    }
                    Chart.this.initialMovePoint = mouseEvent.getPoint();
                    Chart.this.initialMoveViewport = new FloatRect(Chart.this.getViewport());
                } else {
                    Chart.this.setCursor(Cursor.getPredefinedCursor(13));
                    float f = (float)(Chart.this.initialMovePoint.getX() - mouseEvent.getPoint().getX());
                    float f2 = (float)(mouseEvent.getPoint().getY() - Chart.this.initialMovePoint.getY());
                    float f3 = f / Chart.this.pixelsPerUnitX;
                    float f4 = f2 / Chart.this.pixelsPerUnitY;
                    Chart.this.moveViewport(Chart.this.initialMoveViewport, f3, f4);
                    Chart.this.prevZoomPoint = mouseEvent.getPoint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Chart.this.setCursorForPoint(mouseEvent.getPoint());
        }
    };
    ListSelectionListener selectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Chart.this.repaint();
        }
    };
    public static final int CHANGE_SELECTION = 1;
    public static final int EXTEND_SELECTION = 2;

    public Chart() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultListSelectionModel);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
        DialogUtil.addRepaintFocusListener(this);
        this.addMouseWheelListener(this.mouseWheelListener);
        this.setFocusable(true);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("selectPrevious", new Actions("selectPrevious"));
        actionMap.put("selectPreviousExtendSelection", new Actions("selectPreviousExtendSelection"));
        actionMap.put("selectNext", new Actions("selectNext"));
        actionMap.put("selectNextExtendSelection", new Actions("selectNextExtendSelection"));
        actionMap.put("selectFirst", new Actions("selectFirst"));
        actionMap.put("selectFirstExtendSelection", new Actions("selectFirstExtendSelection"));
        actionMap.put("selectLast", new Actions("selectLast"));
        actionMap.put("selectLastExtendSelection", new Actions("selectLastExtendSelection"));
        actionMap.put("selectAll", new Actions("selectAll"));
        actionMap.put("zoomInByFactor", new Actions("zoomInByFactor"));
        actionMap.put("zoomOutByFactor", new Actions("zoomOutByFactor"));
        actionMap.put("moveLeftByFactor", new Actions("moveLeftByFactor"));
        actionMap.put("moveRightByFactor", new Actions("moveRightByFactor"));
        actionMap.put("moveUpByFactor", new Actions("moveUpByFactor"));
        actionMap.put("moveDownByFactor", new Actions("moveDownByFactor"));
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "selectNext");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "selectNextExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "selectPrevious");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "selectPreviousExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectFirst");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "selectFirstExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectLast");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "selectLastExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "selectAll");
        inputMap.put(KeyStroke.getKeyStroke(47, 128), "selectAll");
        inputMap.put(KeyStroke.getKeyStroke(92, 128), "clearSelection");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "zoomInByFactor");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "zoomOutByFactor");
        inputMap.put(KeyStroke.getKeyStroke(38, 192), "moveUpByFactor");
        inputMap.put(KeyStroke.getKeyStroke(40, 192), "moveDownByFactor");
        inputMap.put(KeyStroke.getKeyStroke(37, 192), "moveLeftByFactor");
        inputMap.put(KeyStroke.getKeyStroke(39, 192), "moveRightByFactor");
    }

    public Chart(ChartModel chartModel) {
        this();
        this.setChartModel(this.chartModel);
    }

    public Chart(ChartModel chartModel, ListSelectionModel listSelectionModel) {
        this();
        this.setChartModel(chartModel);
        this.setSelectionModel(listSelectionModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Color color;
            Object object;
            Object object2;
            Dimension dimension = this.getSize();
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
            graphics2D.setColor(this.getForeground());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ChartModel chartModel = this.getChartModel();
            FloatRect floatRect = this.getViewport();
            if (chartModel == null || dimension.width < 10 || dimension.height < 10) {
                return;
            }
            if (floatRect == null || floatRect.getHeight() == 0.0f || floatRect.getWidth() == 0.0f) {
                return;
            }
            try {
                this.displayDone = false;
                this.pixelPanelWidth = dimension.width;
                this.pixelPanelHeight = dimension.height;
                this.pixelPanelRight = this.pixelPanelWidth - 1;
                this.pixelPanelBottom = this.pixelPanelHeight - 1;
                float f = floatRect.getWidth() * 0.05f;
                float f2 = floatRect.getHeight() * 0.05f;
                this.unitPanelStartX = floatRect.getX() - f;
                this.unitPanelStartY = floatRect.getY() - f2;
                this.unitPanelWidth = floatRect.getWidth() + 2.0f * f;
                this.unitPanelHeight = floatRect.getHeight() + 2.0f * f2;
                this.pixelsPerUnitX = (float)this.pixelPanelWidth / this.unitPanelWidth;
                this.pixelsPerUnitY = (float)this.pixelPanelHeight / this.unitPanelHeight;
                List list = chartModel.getXValues();
                object2 = new ArrayList<Integer>();
                object = list.iterator();
                while (object.hasNext()) {
                    float f3 = ((Number)object.next()).floatValue();
                    ((ArrayList)object2).add(new Integer(Math.round((f3 - this.unitPanelStartX) * this.pixelsPerUnitX)));
                }
                this.pixelXValuesInt = ListUtil.convertToIntArray(object2);
                this.pixelYEditValuesInt = null;
                this.editPixelMarkerSize = -1;
            }
            finally {
                this.displayDone = true;
            }
            this.renderGrid(graphics2D, chartModel);
            this.renderXYAxes(graphics2D);
            List list = chartModel.getPlotDescs();
            if (list != null) {
                Iterator iterator = list.iterator();
                int n = -1;
                while (iterator.hasNext()) {
                    boolean bl;
                    object2 = (ChartPlotDesc)((Object)iterator.next());
                    ++n;
                    if (!((ChartPlotDesc)((Object)object2)).getDoDisplay() || (object = ((ChartPlotDesc)((Object)object2)).getYValues()) == null) continue;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        float f = ((Number)iterator2.next()).floatValue();
                        arrayList.add(new Integer(this.pixelPanelBottom - Math.round((f - this.unitPanelStartY) * this.pixelsPerUnitY)));
                    }
                    int[] nArray = ListUtil.convertToIntArray(arrayList);
                    boolean bl2 = bl = chartModel.getEditDescIndex() == n;
                    if (bl) {
                        this.pixelYEditValuesInt = new int[nArray.length];
                        System.arraycopy(nArray, 0, this.pixelYEditValuesInt, 0, nArray.length);
                    }
                    Color color2 = ((ChartPlotDesc)((Object)object2)).getLineColor();
                    this.renderPlotLines(graphics2D, (ChartPlotDesc)((Object)object2), nArray, color2);
                    this.renderMarkers(graphics2D, (ChartPlotDesc)((Object)object2), nArray, color2, bl);
                }
            }
            if (this.isFocusOwner() && (color = UIManager.getColor("Button.focus")) != null) {
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f));
                int n = 0;
                int n2 = dimension.width - 2 - n * 2;
                int n3 = dimension.height - 2 - n * 2;
                graphics2D.drawRect(n, n, n2, n3);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    private void renderMarkers(Graphics2D graphics2D, ChartPlotDesc chartPlotDesc, int[] nArray, Color color, boolean bl) {
        Color color2 = chartPlotDesc.getMarkerFillColor();
        float f = chartPlotDesc.getMarkerSize();
        float f2 = chartPlotDesc.getOutlineSize();
        if (f != 0.0f) {
            int n;
            int n2;
            int n3 = f == -1.0f ? Sizes.DLUX4.getPixelSize((Component)this) : Math.round(f * this.pixelsPerUnitX);
            if (n3 < 4) {
                n3 = 4;
            }
            if (bl) {
                this.editPixelMarkerSize = n3;
            }
            if (color2 != null) {
                for (int i = 0; i < this.pixelXValuesInt.length; ++i) {
                    graphics2D.setColor(color2);
                    if (this.selectionModel.isSelectedIndex(i) && bl) {
                        graphics2D.setColor(color2.darker());
                    }
                    n2 = this.pixelXValuesInt[i] - n3 / 2;
                    n = nArray[i] - n3 / 2;
                    graphics2D.fillOval(n2, n, n3, n3);
                }
            }
            if (color != null && f2 != 0.0f) {
                float f3 = f2 == -1.0f ? 1.0f : f2 * this.pixelsPerUnitX;
                graphics2D.setStroke(new BasicStroke(f3));
                graphics2D.setColor(color);
                for (n2 = 0; n2 < this.pixelXValuesInt.length; ++n2) {
                    n = this.pixelXValuesInt[n2] - n3 / 2;
                    int n4 = nArray[n2] - n3 / 2;
                    graphics2D.drawOval(n, n4, n3, n3);
                }
            }
        }
    }

    private void renderPlotLines(Graphics2D graphics2D, ChartPlotDesc chartPlotDesc, int[] nArray, Color color) {
        float f = chartPlotDesc.getLineSize();
        if (color != null && f != 0.0f) {
            float f2 = f == -1.0f ? 2.0f : f * this.pixelsPerUnitX;
            graphics2D.setStroke(new BasicStroke(f2));
            graphics2D.setColor(color);
            graphics2D.drawPolyline(this.pixelXValuesInt, nArray, this.pixelXValuesInt.length);
        }
    }

    private void renderXYAxes(Graphics2D graphics2D) {
        if (this.getXAxisLoc() != Float.MIN_VALUE || this.getYAxisLoc() != Float.MIN_VALUE) {
            int n;
            graphics2D.setColor(UIManager.getColor("Label.foreground"));
            graphics2D.setStroke(new BasicStroke(1.3f));
            if (this.getXAxisLoc() != Float.MIN_VALUE) {
                n = Math.round((this.getXAxisLoc() - this.unitPanelStartX) * this.pixelsPerUnitX);
                graphics2D.drawLine(n, 0, n, this.pixelPanelBottom);
            }
            if (this.getYAxisLoc() != Float.MIN_VALUE) {
                n = this.pixelPanelBottom - Math.round((this.getYAxisLoc() - this.unitPanelStartY) * this.pixelsPerUnitY);
                graphics2D.drawLine(0, n, this.pixelPanelRight, n);
            }
        }
    }

    private void renderGrid(Graphics2D graphics2D, ChartModel chartModel) {
        FloatRect floatRect = chartModel.getGrid();
        if (floatRect != null) {
            int n;
            float f;
            int n2;
            float f2;
            Color color = this.getBackground().darker();
            if (floatRect.getWidth() > 0.0f) {
                f2 = Math.abs(floatRect.getX() - this.unitPanelStartX);
                n2 = (int)(f2 / floatRect.getWidth());
                f = f2 - (float)n2 * floatRect.getWidth();
                if (floatRect.getX() < this.unitPanelStartX) {
                    f = floatRect.getWidth() - f;
                }
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f));
                while (f < this.unitPanelWidth) {
                    n = Math.round(f * this.pixelsPerUnitX);
                    graphics2D.drawLine(n, 0, n, this.pixelPanelBottom);
                    f += floatRect.getWidth();
                }
            }
            if (floatRect.getHeight() > 0.0f) {
                f2 = Math.abs(floatRect.getY() - this.unitPanelStartY);
                n2 = (int)(f2 / floatRect.getHeight());
                f = f2 - (float)n2 * floatRect.getHeight();
                if (floatRect.getY() < this.unitPanelStartY) {
                    f = floatRect.getHeight() - f;
                }
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(1.0f));
                while (f < this.unitPanelHeight) {
                    n = this.pixelPanelBottom - Math.round(f * this.pixelsPerUnitY);
                    graphics2D.drawLine(0, n, this.pixelPanelRight, n);
                    f += floatRect.getHeight();
                }
            }
        }
    }

    public void ensureEditIndexIsVisible(int n) {
        ChartModel chartModel = this.getChartModel();
        int n2 = chartModel.getEditDescIndex();
        List list = chartModel.getPlotDescs();
        if (n2 != -1 && list != null && list.size() > n2) {
            ChartPlotDesc chartPlotDesc = (ChartPlotDesc)((Object)list.get(n2));
            List list2 = chartPlotDesc.getYValues();
            List list3 = chartModel.getXValues();
            float f = ((Number)list3.get(n)).floatValue();
            float f2 = ((Number)list2.get(n)).floatValue();
            FloatRect floatRect = this.getViewport();
            float f3 = Chart.calcScrollOffset(f, floatRect.getX(), floatRect.getMaxX());
            float f4 = Chart.calcScrollOffset(f2, floatRect.getY(), floatRect.getMaxY());
            if (f3 != 0.0f || f4 != 0.0f) {
                this.moveViewport(null, f3, f4);
            }
        }
    }

    private static float calcScrollOffset(float f, float f2, float f3) {
        if (f < f2) {
            return f - f2;
        }
        if (f > f3) {
            return f - f3;
        }
        return 0.0f;
    }

    public float getXAxisLoc() {
        return this.xAxisLoc;
    }

    public void setXAxisLoc(float f) {
        this.xAxisLoc = f;
        this.repaint();
    }

    public float getYAxisLoc() {
        return this.yAxisLoc;
    }

    public void setYAxisLoc(float f) {
        this.yAxisLoc = f;
        this.repaint();
    }

    public ChartModel getChartModel() {
        return this.chartModel;
    }

    public void setChartModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.chartModel;
        this.chartModel = chartModel;
        if (chartModel2 != null) {
            chartModel2.removePropertyChangeListener(this.chartModelListener);
            this.deregisterDescListeners(chartModel2.getPlotDescs());
        }
        this.firePropertyChange(PROPERTYNAME_CHART_MODEL, (Object)chartModel2, (Object)chartModel, true);
        if (chartModel != null) {
            chartModel.addPropertyChangeListener(this.chartModelListener);
            this.registerDescListeners(chartModel.getPlotDescs());
            this.setViewport(chartModel.getMaximumViewport());
        }
        this.repaint();
    }

    public void resetViewport() {
        this.setViewport(this.chartModel.getMaximumViewport());
    }

    private void registerDescListeners(List list) {
        if (list != null) {
            for (ChartPlotDesc chartPlotDesc : list) {
                chartPlotDesc.addPropertyChangeListener(this.plotDescListener);
                List list2 = chartPlotDesc.getYValues();
                if (list2 == null || !(list2 instanceof ListModel)) continue;
                ListModel listModel = (ListModel)((Object)list2);
                listModel.addListDataListener(this.yValuesListener);
            }
        }
    }

    private void deregisterDescListeners(List list) {
        if (list != null) {
            for (ChartPlotDesc chartPlotDesc : list) {
                chartPlotDesc.removePropertyChangeListener(this.plotDescListener);
                List list2 = chartPlotDesc.getYValues();
                if (list2 == null || !(list2 instanceof ListModel)) continue;
                ListModel listModel = (ListModel)((Object)list2);
                listModel.removeListDataListener(this.yValuesListener);
            }
        }
    }

    private int getNearestValidEditIndex(Point point) {
        int n = -1;
        int n2 = this.editPixelMarkerSize / 2;
        int[] nArray = this.pixelYEditValuesInt;
        int[] nArray2 = this.pixelXValuesInt;
        if (nArray2 == null || nArray == null || nArray2.length != nArray.length || n2 == -1) {
            return n;
        }
        double d = 3.4028234663852886E38;
        for (int i = 0; i < nArray2.length; ++i) {
            double d2;
            double d3 = point.getX() - (double)nArray2[i];
            double d4 = Math.pow(d3 * d3 + (d2 = point.getY() - (double)nArray[i]) * d2, 0.5);
            if (!(d4 <= (double)n2) || !(d4 < d)) continue;
            n = i;
            d = d4;
        }
        return n;
    }

    private void setCursorForPoint(Point point) {
        int n = this.getNearestValidEditIndex(point);
        if (n != -1) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(null);
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this.selectionListener);
        }
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        this.firePropertyChange(PROPERTYNAME_SELECTION_MODEL, listSelectionModel2, listSelectionModel, true);
    }

    public FloatRect getSelectionRect() {
        return this.selectionRect;
    }

    public void setSelectionRect(FloatRect floatRect) {
        FloatRect floatRect2 = this.selectionRect;
        this.selectionRect = floatRect;
        this.firePropertyChange(PROPERTYNAME_SELECTION_RECT, floatRect2, floatRect);
    }

    public FloatRect getViewport() {
        return this.viewport;
    }

    public void setViewport(FloatRect floatRect) {
        FloatRect floatRect2 = this.viewport;
        this.viewport = floatRect;
        this.firePropertyChange(PROPERTYNAME_VIEWPORT, floatRect2, floatRect);
        this.repaint();
    }

    public void changeSelection(int n, int n2) {
        if (n2 >= 0 && n2 < this.getChartModel().getXCount()) {
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            if (n == 2) {
                int n3 = listSelectionModel.getAnchorSelectionIndex();
                if (n3 == -1) {
                    n3 = n2;
                }
                listSelectionModel.setSelectionInterval(n3, n2);
            } else {
                listSelectionModel.setSelectionInterval(n2, n2);
            }
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new ExtendedPropertyChangeSupport((Object)this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new ExtendedPropertyChangeSupport((Object)this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        ExtendedPropertyChangeSupport extendedPropertyChangeSupport = this.changeSupport;
        if (extendedPropertyChangeSupport == null) {
            return;
        }
        extendedPropertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, Object object, Object object2, boolean bl) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2, bl);
    }

    private void moveViewport(FloatRect floatRect, float f, float f2) {
        ChartModel chartModel = this.getChartModel();
        if (floatRect == null) {
            floatRect = this.getViewport();
        }
        FloatRect floatRect2 = new FloatRect(floatRect);
        floatRect2.setX(floatRect2.getX() + f);
        floatRect2.setY(floatRect2.getY() + f2);
        FloatRect floatRect3 = chartModel.getMaximumViewport();
        if (floatRect3 != null) {
            floatRect2 = floatRect3.shiftAndClipRect(floatRect2);
        }
        this.setViewport(floatRect2);
    }

    private void moveViewportByFactor(float f, float f2) {
        ChartModel chartModel = this.getChartModel();
        FloatRect floatRect = this.getViewport();
        if (chartModel == null || floatRect == null || floatRect.getHeight() == 0.0f || floatRect.getWidth() == 0.0f) {
            return;
        }
        float f3 = floatRect.getWidth();
        float f4 = floatRect.getHeight();
        float f5 = f3 * f;
        float f6 = f4 * f2;
        this.moveViewport(null, f5, f6);
    }

    private void zoomByFactor(float f) {
        float f2;
        float f3;
        ChartModel chartModel = this.getChartModel();
        FloatRect floatRect = this.getViewport();
        if (chartModel == null || floatRect == null || floatRect.getHeight() == 0.0f || floatRect.getWidth() == 0.0f) {
            return;
        }
        float f4 = floatRect.getWidth();
        float f5 = floatRect.getHeight();
        if (f < 0.0f) {
            f = Math.abs(f);
            f3 = f4 / (1.0f + f);
            f2 = f5 / (1.0f + f);
        } else {
            f3 = f4 * (1.0f + f);
            f2 = f5 * (1.0f + f);
        }
        float f6 = floatRect.getX() + f4 / 2.0f - f3 / 2.0f;
        float f7 = floatRect.getY() + f5 / 2.0f - f2 / 2.0f;
        FloatRect floatRect2 = new FloatRect(f6, f7, f3, f2);
        FloatRect floatRect3 = chartModel.getMaximumViewport();
        if (floatRect3 != null) {
            floatRect2 = floatRect3.clipRect(floatRect2);
        }
        this.setViewport(floatRect2);
    }

    private static class Actions
    extends AbstractAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_EXTEND = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_EXTEND = "selectNextExtendSelection";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_EXTEND = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_EXTEND = "selectLastExtendSelection";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String ZOOM_IN_BY_FACTOR = "zoomInByFactor";
        private static final String ZOOM_OUT_BY_FACTOR = "zoomOutByFactor";
        private static final String MOVE_RIGHT_BY_FACTOR = "moveRightByFactor";
        private static final String MOVE_LEFT_BY_FACTOR = "moveLeftByFactor";
        private static final String MOVE_UP_BY_FACTOR = "moveUpByFactor";
        private static final String MOVE_DOWN_BY_FACTOR = "moveDownByFactor";

        public Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.getValue("Name");
            Chart chart = (Chart)actionEvent.getSource();
            if (string == SELECT_PREVIOUS) {
                chart.changeSelection(1, this.getNextIndex(chart, -1));
            } else if (string == SELECT_NEXT) {
                chart.changeSelection(1, this.getNextIndex(chart, 1));
            } else if (string == SELECT_PREVIOUS_EXTEND) {
                chart.changeSelection(2, this.getNextIndex(chart, -1));
            } else if (string == SELECT_NEXT_EXTEND) {
                chart.changeSelection(2, this.getNextIndex(chart, 1));
            } else if (string == SELECT_FIRST) {
                chart.changeSelection(1, 0);
            } else if (string == SELECT_FIRST_EXTEND) {
                chart.changeSelection(2, 0);
            } else if (string == SELECT_LAST) {
                chart.changeSelection(1, chart.getChartModel().getXCount() - 1);
            } else if (string == SELECT_LAST_EXTEND) {
                chart.changeSelection(2, chart.getChartModel().getXCount() - 1);
            } else if (string == SELECT_ALL) {
                this.selectAll(chart);
            } else if (string == CLEAR_SELECTION) {
                this.clearSelection(chart);
            } else if (string == ZOOM_IN_BY_FACTOR) {
                chart.zoomByFactor(-0.08f);
            } else if (string == ZOOM_OUT_BY_FACTOR) {
                chart.zoomByFactor(0.08f);
            } else if (string == MOVE_LEFT_BY_FACTOR) {
                chart.moveViewportByFactor(-0.08f, 0.0f);
            } else if (string == MOVE_RIGHT_BY_FACTOR) {
                chart.moveViewportByFactor(0.08f, 0.0f);
            } else if (string == MOVE_UP_BY_FACTOR) {
                chart.moveViewportByFactor(0.0f, 0.08f);
            } else if (string == MOVE_DOWN_BY_FACTOR) {
                chart.moveViewportByFactor(0.0f, -0.08f);
            }
        }

        private void clearSelection(Chart chart) {
            chart.getSelectionModel().clearSelection();
        }

        private void selectAll(Chart chart) {
            int n = chart.getChartModel().getXCount();
            if (n > 0) {
                ListSelectionModel listSelectionModel = chart.getSelectionModel();
                if (listSelectionModel.getSelectionMode() == 0) {
                    int n2 = listSelectionModel.getLeadSelectionIndex();
                    if (n2 != -1) {
                        listSelectionModel.setSelectionInterval(n2, n2);
                    } else if (listSelectionModel.getMinSelectionIndex() == -1) {
                        listSelectionModel.setSelectionInterval(0, 0);
                    }
                } else {
                    listSelectionModel.setValueIsAdjusting(true);
                    listSelectionModel.setSelectionInterval(0, n - 1);
                    listSelectionModel.setValueIsAdjusting(false);
                }
            }
        }

        private int getNextIndex(Chart chart, int n) {
            int n2 = chart.getSelectionModel().getLeadSelectionIndex();
            int n3 = chart.getChartModel().getXCount();
            if (n2 == -1) {
                if (n3 > 0) {
                    n2 = n > 0 ? 0 : n3 - 1;
                }
            } else {
                n2 = n3 == 1 ? 0 : (n2 += n);
            }
            return n2;
        }
    }
}

