/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.gui.chart;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.Chart;
import com.ecmtuning.ecmlink.gui.chart.ChartModel;
import com.ecmtuning.ecmlink.gui.chart.ChartPlotDesc;
import com.ecmtuning.ecmlink.gui.chart.ChtTblDataAdapter;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.HandyTableColumnModel;
import com.ecmtuning.ecmlink.util.ui.SelectionFocusListener;
import com.ecmtuning.ecmlink.util.ui.TextSelectionTableCellEditor;
import com.jgoodies.binding.list.ArrayListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class ChtTblBuilder {
    public static final String ACTION_DECREMENT_SMALL_STEP = "decrementSmallStep";
    public static final String ACTION_INCREMENT_SMALL_STEP = "incrementSmallStep";
    private final ChtTblDataAdapter dataAdapter;
    private JPanel panel;
    ListSelectionModel sharedSelectionModel;
    private HandyJTable dataTable;
    private Chart chart;
    private ChartPlotDesc yDesc;
    private ChartPlotDesc templateDesc;

    public ChtTblBuilder(ChtTblDataAdapter chtTblDataAdapter) {
        this.dataAdapter = chtTblDataAdapter;
    }

    public JPanel getPanel() {
        return this.getPanel(true);
    }

    public JPanel getPanel(boolean bl) {
        if (this.panel == null) {
            this.panel = this.buildPanel(bl);
        }
        return this.panel;
    }

    public ListSelectionModel getSelectionModel() {
        this.getPanel();
        return this.sharedSelectionModel;
    }

    public HandyJTable getDataTable() {
        this.getPanel();
        return this.dataTable;
    }

    public Chart getChart() {
        this.getPanel();
        return this.chart;
    }

    public ChartPlotDesc getYDesc() {
        this.getPanel();
        return this.yDesc;
    }

    public ChartPlotDesc getTemplateDesc() {
        this.getPanel();
        return this.templateDesc;
    }

    public void setStandardPlotDescs() {
        ArrayListModel arrayListModel = this.dataAdapter.getChartXValues();
        Number number = ListUtil.findMin((List)arrayListModel);
        Number number2 = ListUtil.findMax((List)arrayListModel);
        float f = Math.abs(number2.floatValue() - number.floatValue());
        this.yDesc.setLineSize(0.0036734694f * f);
        this.yDesc.setOutlineSize(0.0016326531f * f);
        this.yDesc.setMarkerSize(0.017959183f * f);
        ChartPlotDesc chartPlotDesc = this.getTemplateDesc();
        chartPlotDesc.setLineSize(0.0f);
        chartPlotDesc.setOutlineSize(8.1632653E-4f * f);
        chartPlotDesc.setMarkerSize(0.014285714f * f);
    }

    public void resetViewport() {
        FloatRect floatRect = this.dataAdapter.getGridForDisplayType();
        FloatRect floatRect2 = this.dataAdapter.getMaxViewportForDisplayType();
        ChartModel chartModel = this.chart.getChartModel();
        chartModel.setGrid(floatRect);
        chartModel.setMaximumViewport(floatRect2);
        this.chart.setViewport(floatRect2);
    }

    public void addDefaultValueChangeActions(JComponent jComponent, boolean bl) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        InputMap inputMap = jComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 128), ACTION_INCREMENT_SMALL_STEP);
        inputMap.put(KeyStroke.getKeyStroke(40, 128), ACTION_DECREMENT_SMALL_STEP);
        if (!bl) {
            inputMap.put(KeyStroke.getKeyStroke(38, 0), ACTION_INCREMENT_SMALL_STEP);
            inputMap.put(KeyStroke.getKeyStroke(40, 0), ACTION_DECREMENT_SMALL_STEP);
        }
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(ACTION_INCREMENT_SMALL_STEP, this.dataAdapter.createValueChangeAction(listSelectionModel, true));
        actionMap.put(ACTION_DECREMENT_SMALL_STEP, this.dataAdapter.createValueChangeAction(listSelectionModel, false));
    }

    private synchronized JPanel buildPanel(boolean bl) {
        JComponent jComponent;
        if (this.panel != null) {
            return this.panel;
        }
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        this.dataTable = this.initDataTable();
        this.chart = this.initChart();
        this.dataAdapter.addPropertyChangeListener("templateVisible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                ChtTblBuilder.this.dataAdapter.setColumnVisible(ChtTblDataAdapter.COLUMN_INDEX_TEMPLATE, bl);
                ChtTblBuilder.this.templateDesc.setDoDisplay(bl);
            }
        });
        if (bl) {
            jComponent = new JScrollPane((Component)((Object)this.dataTable));
            this.dataTable.setScrollPane((JScrollPane)jComponent);
            ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(31);
            jPanel.add((Component)jComponent, "West");
        } else {
            jPanel.add((Component)((Object)this.dataTable), "West");
        }
        jComponent = new JPanel(new BorderLayout());
        jComponent.setBorder(BorderFactory.createEtchedBorder());
        jComponent.add((Component)this.chart, "Center");
        jPanel.add((Component)jComponent, "Center");
        return jPanel;
    }

    private HandyJTable initDataTable() {
        AbstractTableModel abstractTableModel = this.dataAdapter.getDataTableModel();
        HandyTableColumnModel handyTableColumnModel = this.dataAdapter.getDataColumnModel();
        HandyJTable handyJTable = new HandyJTable(abstractTableModel, handyTableColumnModel);
        handyJTable.setUsePreferredSizeAsScrollSize(true);
        handyJTable.setAutoResizeMode(0);
        handyJTable.setEnabled(true);
        handyJTable.setCellSelectionEnabled(false);
        handyJTable.setColumnSelectionAllowed(false);
        handyJTable.setRowSelectionAllowed(true);
        handyJTable.setSelectionMode(1);
        TableCellEditor tableCellEditor = handyJTable.getDefaultEditor(Object.class);
        handyJTable.setDefaultEditor(Object.class, new TextSelectionTableCellEditor(tableCellEditor));
        SelectionFocusListener.ensureSelectOnFocus((Component)((Object)handyJTable));
        handyJTable.replaceTabNavigation();
        InputMap inputMap = handyJTable.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "selectNextRow");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "selectNextRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "selectPreviousRow");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "selectPreviousRowExtendSelection");
        this.sharedSelectionModel = handyJTable.getSelectionModel();
        this.sharedSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ChtTblBuilder.this.sharedSelectionModel.getLeadSelectionIndex();
                if (n != -1) {
                    ChtTblBuilder.this.getDataTable().ensureRowIsVisible(n);
                    ChtTblBuilder.this.getChart().ensureEditIndexIsVisible(n);
                }
            }
        });
        int[] nArray = new int[abstractTableModel.getColumnCount()];
        Arrays.fill(nArray, 4);
        handyJTable.setColumnAlignments(nArray);
        handyJTable.setColumnPrototypes((Object[])this.dataAdapter.getColumnPrototypes());
        handyJTable.getTableHeader().setReorderingAllowed(false);
        handyJTable.getTableHeader().setResizingAllowed(false);
        return handyJTable;
    }

    private final Chart initChart() {
        ArrayListModel arrayListModel = this.dataAdapter.getChartXValues();
        ArrayListModel arrayListModel2 = this.dataAdapter.getChartYValues();
        ArrayListModel arrayListModel3 = this.dataAdapter.getChartTemplateValues();
        Color color = new Color(255, 255, 0);
        this.yDesc = new ChartPlotDesc((List)arrayListModel2, true, -1.0f, -1.0f, -1.0f, Color.RED.darker().darker(), color);
        this.templateDesc = new ChartPlotDesc((List)arrayListModel3, false, 0.0f, -1.0f, -1.0f, Color.BLACK, Color.WHITE);
        ArrayList<ChartPlotDesc> arrayList = new ArrayList<ChartPlotDesc>();
        arrayList.add(this.templateDesc);
        arrayList.add(this.yDesc);
        ChartModel chartModel = new ChartModel((List)arrayListModel, arrayList, 1);
        Chart chart = new Chart(chartModel, this.sharedSelectionModel);
        SelectionFocusListener.ensureSelectOnFocus(chart);
        this.dataAdapter.addPropertyChangeListener("displayType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChtTblBuilder.this.resetViewport();
            }
        });
        return chart;
    }
}

