/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.gui.chart;

import com.ecmtuning.ecmlink.gui.FloatRect;
import com.ecmtuning.ecmlink.gui.chart.BaseTblDataAdapter;
import com.ecmtuning.ecmlink.util.model.ListModelPlug;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataListener;

public abstract class ChtTblDataAdapter
extends BaseTblDataAdapter {
    protected ListModelPlug numberRowHeaderModel;
    protected ListModelPlug numberDataModel;
    protected ListModelPlug numberTemplateModel;
    protected ValueModel rowHeaderColumnHeaderModel;
    protected ValueModel dataColumnHeaderModel;
    protected ValueModel templateColumnHeaderModel;
    private Hashtable gridsPerDisplayType;
    private Hashtable maxViewportsPerDisplayType;
    protected static int COLUMN_INDEX_ROW_HEADER = 0;
    protected static int COLUMN_INDEX_DATA = 1;
    protected static int COLUMN_INDEX_TEMPLATE = 2;
    protected static int COLUMN_COUNT = 3;
    protected PropertyChangeListener rowHeaderModelListener;
    protected PropertyChangeListener dataHeaderModelListener;
    protected PropertyChangeListener templateHeaderModelListener;

    @Override
    protected void construct(String string) {
        this.construct(new String[]{string});
    }

    @Override
    protected void construct(String[] stringArray) {
        this.rowHeaderColumnHeaderModel = this.createRowHeaderColumnHeaderModel();
        this.dataColumnHeaderModel = this.createDataColumnHeaderModel();
        this.templateColumnHeaderModel = this.createTemplateColumnHeaderModel();
        super.construct(stringArray);
        this.numberRowHeaderModel = this.createNumberRowHeaderModel();
        this.numberDataModel = this.createNumberDataModel();
        if (this.getHasTemplate()) {
            this.numberTemplateModel = this.createNumberTemplateModel();
        }
        this.getDataColumnModel().setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int n, int n2) {
                super.setSelectionInterval(COLUMN_INDEX_DATA, COLUMN_INDEX_DATA);
            }
        });
        this.rowHeaderModelListener = new ColumnHeaderModelUpdater(this.getRowHeaderColumnHeaderModel(), COLUMN_INDEX_ROW_HEADER);
        this.dataHeaderModelListener = new ColumnHeaderModelUpdater(this.getDataColumnHeaderModel(), COLUMN_INDEX_DATA);
        if (this.getHasTemplate()) {
            this.templateHeaderModelListener = new ColumnHeaderModelUpdater(this.getTemplateColumnHeaderModel(), COLUMN_INDEX_TEMPLATE);
        }
        this.setColumnVisible(COLUMN_INDEX_ROW_HEADER, true);
        this.setColumnVisible(COLUMN_INDEX_DATA, true);
        this.addPropertyChangeListener("displayType", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChtTblDataAdapter.this.getDataTableModel().fireTableDataChanged();
            }
        });
    }

    protected abstract ValueModel createRowHeaderColumnHeaderModel();

    protected abstract ValueModel createDataColumnHeaderModel();

    protected ValueModel createTemplateColumnHeaderModel() {
        return null;
    }

    public ValueModel getRowHeaderColumnHeaderModel() {
        return this.rowHeaderColumnHeaderModel;
    }

    public ValueModel getDataColumnHeaderModel() {
        return this.dataColumnHeaderModel;
    }

    public ValueModel getTemplateColumnHeaderModel() {
        return this.templateColumnHeaderModel;
    }

    protected FloatRect getDefaultGrid() {
        return this.getGridForDisplayType();
    }

    protected FloatRect getDefaultMaxViewport() {
        return this.getMaxViewportForDisplayType();
    }

    @Override
    protected void handleNewDisplayType() {
        this.numberDataModel.resetLocalValue();
        if (this.getHasTemplate()) {
            this.numberTemplateModel.resetLocalValue();
        }
        super.handleNewDisplayType();
    }

    protected FloatRect getGridForDisplayType() {
        if (this.gridsPerDisplayType == null) {
            return this.getDefaultGrid();
        }
        return (FloatRect)this.gridsPerDisplayType.get(this.getDisplayType());
    }

    protected FloatRect getMaxViewportForDisplayType() {
        if (this.maxViewportsPerDisplayType == null) {
            return this.getDefaultMaxViewport();
        }
        return (FloatRect)this.maxViewportsPerDisplayType.get(this.getDisplayType());
    }

    public final void setGridForDisplayType(Integer n, FloatRect floatRect) {
        if (this.gridsPerDisplayType == null) {
            this.gridsPerDisplayType = new Hashtable();
        }
        this.gridsPerDisplayType.put(n, floatRect);
    }

    public final void setMaxViewportForDisplayType(Integer n, FloatRect floatRect) {
        if (this.maxViewportsPerDisplayType == null) {
            this.maxViewportsPerDisplayType = new Hashtable();
        }
        this.maxViewportsPerDisplayType.put(n, floatRect);
    }

    public Action createValueChangeAction(ListSelectionModel listSelectionModel, boolean bl) {
        return new BaseTblDataAdapter.LocalValueChangeAction(null, listSelectionModel, bl);
    }

    public ArrayListModel getChartXValues() {
        return this.numberRowHeaderModel.getLocalArrayListValue();
    }

    public ArrayListModel getChartYValues() {
        return this.numberDataModel.getLocalArrayListValue();
    }

    public ArrayListModel getChartTemplateValues() {
        if (this.getHasTemplate()) {
            return this.numberTemplateModel.getLocalArrayListValue();
        }
        return null;
    }

    @Override
    protected ValueModel createRawColumnHeaderModel() {
        ArrayListModel arrayListModel = new ArrayListModel();
        arrayListModel.add(this.getRowHeaderColumnHeaderModel().getValue());
        arrayListModel.add(this.getDataColumnHeaderModel().getValue());
        if (this.getHasTemplate()) {
            arrayListModel.add(this.getTemplateColumnHeaderModel().getValue());
        }
        return new ValueHolder((Object)arrayListModel);
    }

    @Override
    protected ListModelPlug createStringColumnHeaderModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawColumnHeaderModel, null, true);
        listModelPlug.getLocalArrayListValue().addListDataListener((ListDataListener)new BaseTblDataAdapter.LocalListListener(2));
        return listModelPlug;
    }

    protected ListModelPlug createNumberRowHeaderModel() {
        return new ListModelPlug(this.rawRowHeaderModel, null, true);
    }

    protected ListModelPlug createNumberDataModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawDataModel, null, true);
        this.addDataFilters(listModelPlug);
        return listModelPlug;
    }

    protected ListModelPlug createNumberTemplateModel() {
        ListModelPlug listModelPlug = new ListModelPlug(this.rawTemplateModel, null, true);
        this.addDataFilters(listModelPlug);
        return listModelPlug;
    }

    @Override
    protected void fireDataModelChanged(int n, int n2) {
        this.getDataTableModel().fireTableCellUpdated(n2, COLUMN_INDEX_DATA);
    }

    @Override
    protected void rowHeaderModelChanged(int n) {
        this.getDataTableModel().fireTableCellUpdated(n, COLUMN_INDEX_ROW_HEADER);
    }

    @Override
    protected int dataModelIndex(int n, int n2) {
        return n2;
    }

    @Override
    protected int dataModelColumn(int n) {
        return COLUMN_INDEX_DATA;
    }

    @Override
    protected int dataModelRow(int n) {
        return n;
    }

    @Override
    protected boolean tblMdl_isCellEditable(int n, int n2) {
        return n2 == COLUMN_INDEX_DATA;
    }

    @Override
    protected Object tblMdl_getValueAt(int n, int n2) {
        if (n2 == COLUMN_INDEX_ROW_HEADER) {
            return this.stringRowHeaderModel.getLocalArrayListValue().get(n);
        }
        if (n2 == COLUMN_INDEX_DATA) {
            return this.stringDataModel.getLocalArrayListValue().get(n);
        }
        return this.stringTemplateModel.getLocalArrayListValue().get(n);
    }

    protected class ColumnHeaderModelUpdater
    implements PropertyChangeListener {
        private final ValueModel model;
        private final int columnIndex;

        public ColumnHeaderModelUpdater(ValueModel valueModel, int n) {
            this.model = valueModel;
            this.columnIndex = n;
            WeakListeners.addValueChangeListener(this, valueModel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ChtTblDataAdapter.this.stringColumnHeaderModel.getLocalArrayListValue().set(this.columnIndex, this.model.getValue());
        }
    }
}

