/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.gui.chart;

import com.ecmtuning.ecmlink.gui.chart.TblDataAdapter;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import com.ecmtuning.ecmlink.util.ui.HandyTableColumnModel;
import com.ecmtuning.ecmlink.util.ui.SelectionFocusListener;
import com.ecmtuning.ecmlink.util.ui.TableRowHeaderRenderer;
import com.ecmtuning.ecmlink.util.ui.TextSelectionTableCellEditor;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class TblBuilder {
    public static final String ACTION_DECREMENT_SMALL_STEP = "decrementSmallStep";
    public static final String ACTION_INCREMENT_SMALL_STEP = "incrementSmallStep";
    private final TblDataAdapter dataAdapter;
    private HandyJTable dataTable;
    private HandyJTable rowHeaderTable;
    private JScrollPane scrollPane;

    public TblBuilder(TblDataAdapter tblDataAdapter) {
        this.dataAdapter = tblDataAdapter;
    }

    public synchronized HandyJTable getDataTable() {
        if (this.dataTable != null) {
            return this.dataTable;
        }
        this.dataTable = this.initDataTable();
        this.rowHeaderTable = this.initRowHeaderTable();
        return this.dataTable;
    }

    public synchronized HandyJTable getRowHeaderTable() {
        if (this.rowHeaderTable != null) {
            return this.rowHeaderTable;
        }
        this.getDataTable();
        return this.rowHeaderTable;
    }

    public synchronized JScrollPane getDataTableWithScrollPane() {
        if (this.scrollPane != null) {
            return this.scrollPane;
        }
        HandyJTable handyJTable = this.getDataTable();
        JViewport jViewport = new JViewport();
        jViewport.setView((Component)((Object)this.rowHeaderTable));
        this.scrollPane = new JScrollPane((Component)((Object)handyJTable));
        this.scrollPane.setRowHeader(jViewport);
        return this.scrollPane;
    }

    public void addDefaultValueChangeActions(JComponent jComponent, boolean bl) {
        ListSelectionModel listSelectionModel = this.dataTable.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.dataTable.getColumnModel().getSelectionModel();
        InputMap inputMap = jComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 128), ACTION_INCREMENT_SMALL_STEP);
        inputMap.put(KeyStroke.getKeyStroke(40, 128), ACTION_DECREMENT_SMALL_STEP);
        if (!bl) {
            inputMap.put(KeyStroke.getKeyStroke(38, 0), ACTION_INCREMENT_SMALL_STEP);
            inputMap.put(KeyStroke.getKeyStroke(40, 0), ACTION_DECREMENT_SMALL_STEP);
        }
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(ACTION_INCREMENT_SMALL_STEP, this.dataAdapter.createValueChangeAction(listSelectionModel2, listSelectionModel, true));
        actionMap.put(ACTION_DECREMENT_SMALL_STEP, this.dataAdapter.createValueChangeAction(listSelectionModel2, listSelectionModel, false));
    }

    private HandyJTable initRowHeaderTable() {
        AbstractTableModel abstractTableModel = this.dataAdapter.getRowHeaderTableModel();
        HandyTableColumnModel handyTableColumnModel = this.dataAdapter.getRowHeaderColumnModel();
        HandyJTable handyJTable = new HandyJTable(abstractTableModel, handyTableColumnModel);
        handyJTable.setUsePreferredSizeAsScrollSize(true);
        handyJTable.setAutoResizeMode(0);
        handyJTable.setEnabled(true);
        handyJTable.setCellSelectionEnabled(false);
        handyJTable.setColumnPrototypes((Object[])this.dataAdapter.getColumnPrototypes());
        TableRowHeaderRenderer tableRowHeaderRenderer = new TableRowHeaderRenderer();
        tableRowHeaderRenderer.setHorizontalAlignment(4);
        handyJTable.setDefaultTableCellRenderer(tableRowHeaderRenderer);
        handyJTable.setFocusable(false);
        return handyJTable;
    }

    private HandyJTable initDataTable() {
        AbstractTableModel abstractTableModel = this.dataAdapter.getDataTableModel();
        HandyTableColumnModel handyTableColumnModel = this.dataAdapter.getDataColumnModel();
        HandyJTable handyJTable = new HandyJTable(abstractTableModel, handyTableColumnModel);
        handyJTable.setUsePreferredSizeAsScrollSize(true);
        handyJTable.setAutoResizeMode(0);
        handyJTable.setEnabled(true);
        handyJTable.setSelectionMode(1);
        handyJTable.setCellSelectionEnabled(true);
        TableCellEditor tableCellEditor = handyJTable.getDefaultEditor(Object.class);
        handyJTable.setDefaultEditor(Object.class, new TextSelectionTableCellEditor(tableCellEditor));
        SelectionFocusListener.ensureSelectOnFocus((Component)((Object)handyJTable));
        int[] nArray = new int[abstractTableModel.getColumnCount()];
        Arrays.fill(nArray, 4);
        handyJTable.setColumnAlignments(nArray);
        handyJTable.setColumnPrototypes((Object[])this.dataAdapter.getColumnPrototypes());
        handyJTable.getTableHeader().setReorderingAllowed(false);
        handyJTable.getTableHeader().setResizingAllowed(false);
        return handyJTable;
    }
}

