/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;

public final class AirPressureFilter
extends UnitsFilter {
    static final int TYPE_BOOST_FROM_PSIA = 0;
    static final int TYPE_BOOST_FROM_PSIG = 1;
    static final int TYPE_BARO_FROM_PSIA = 2;
    static final int TYPE_ABSOLUTE_FROM_PSIA = 3;
    private final int type;
    private float altitudeCorrection = 1.0f;
    public static final String[] AIR_PRESSURE_LABEL_LIST = new String[]{"-inHg/+psi", "psia", "-mHg/+kg/cm\u00b2", "bar"};
    public static final String[] ABSOLUTE_LABEL_LIST = new String[]{"psi", "psi", "kg/cm\u00b2", "bar"};
    public static final String[] BARO_PRESSURE_LABEL_LIST = new String[]{"inHg", "psia", "mmHg", "mbar"};
    static final int indexPSI = UnitsModel.INDEX_BOOST_PRESSURE_PSI;
    static final int indexPSIA = UnitsModel.INDEX_BOOST_PRESSURE_PSIA;
    static final int indexKGPCM2 = UnitsModel.INDEX_BOOST_PRESSURE_KGPCM2;
    static final int indexBAR = UnitsModel.INDEX_BOOST_PRESSURE_BAR;
    static final ObjectFilter AIR_PRESSURE_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(AIR_PRESSURE_LABEL_LIST, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final ObjectFilter ABSOLUTE_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(ABSOLUTE_LABEL_LIST, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final ObjectFilter BARO_PRESSURE_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(BARO_PRESSURE_LABEL_LIST, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final UnitsFilter AIR_PRESSURE_PSIA_VALUE_FILTER = new AirPressureFilter(0);
    static final UnitsFilter AIR_PRESSURE_PSIG_VALUE_FILTER = new AirPressureFilter(1);
    static final UnitsFilter BARO_PRESSURE_PSIA_VALUE_FILTER = new AirPressureFilter(2);
    static final UnitsFilter ABSOLUTE_PSIA_VALUE_FILTER = new AirPressureFilter(3);

    public AirPressureFilter(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            n = 0;
        }
        if (n == 3) {
            this.altitudeCorrection = 0.0f;
        }
        this.type = n;
    }

    public AirPressureFilter createNewInstance() {
        return new AirPressureFilter(this.type);
    }

    public void setAltitudeFt(float f) {
        this.altitudeCorrection = this.type == 3 ? 0.0f : (float)Math.pow(1.0 - 6.88E-6 * (double)f, 5.26);
    }

    public int getPreferredPrec() {
        if (this.selectedUnitsIndex == indexKGPCM2 || this.selectedUnitsIndex == indexBAR) {
            return 2;
        }
        return 1;
    }

    @Override
    public final float filter(float f) {
        if (this.type == 0 || this.type == 3) {
            if (this.selectedUnitsIndex == indexPSIA || this.selectedUnitsIndex == indexPSI && this.type == 3) {
                return f;
            }
            return this.convertPSIGToUserBoostUnits(f - 14.696f * this.altitudeCorrection);
        }
        if (this.type == 1) {
            return this.convertPSIGToUserBoostUnits(f);
        }
        if (this.type == 2) {
            return this.convertPSIAToUserBaroUnits(f);
        }
        return Float.MIN_VALUE;
    }

    @Override
    public float unfilter(float f) {
        if (this.type == 0 || this.type == 3) {
            if (this.selectedUnitsIndex == indexPSIA || this.selectedUnitsIndex == indexPSI && this.type == 3) {
                return f;
            }
            return this.convertUserBoostUnitsToPSIG(f) + 14.696f * this.altitudeCorrection;
        }
        if (this.type == 1) {
            return this.convertUserBoostUnitsToPSIG(f);
        }
        if (this.type == 2) {
            return this.convertUserBaroToPSIAUnits(f);
        }
        return Float.MIN_VALUE;
    }

    private float convertPSIAToUserBaroUnits(float f) {
        if (this.selectedUnitsIndex == indexPSI) {
            return f * 2.036f;
        }
        if (this.selectedUnitsIndex == indexPSIA) {
            return f;
        }
        if (this.selectedUnitsIndex == indexKGPCM2) {
            return f * 51.715f;
        }
        if (this.selectedUnitsIndex == indexBAR) {
            return f * 68.9458f;
        }
        return Float.MIN_VALUE;
    }

    private float convertUserBaroToPSIAUnits(float f) {
        if (this.selectedUnitsIndex == indexPSI) {
            return f / 2.036f;
        }
        if (this.selectedUnitsIndex == indexPSIA) {
            return f;
        }
        if (this.selectedUnitsIndex == indexKGPCM2) {
            return f / 51.715f;
        }
        if (this.selectedUnitsIndex == indexBAR) {
            return f / 68.9458f;
        }
        return Float.MIN_VALUE;
    }

    private final float convertPSIGToUserBoostUnits(float f) {
        if (this.selectedUnitsIndex == indexPSIA) {
            return f + 14.696f * this.altitudeCorrection;
        }
        if (this.selectedUnitsIndex == indexPSI) {
            if (f < 0.0f) {
                return f * 29.921f / 14.696f;
            }
            return f;
        }
        if (this.selectedUnitsIndex == indexKGPCM2) {
            if (f < 0.0f) {
                return f * 29.921f / 14.696f * 0.0254f;
            }
            return f / 14.22f;
        }
        if (this.selectedUnitsIndex == indexBAR) {
            return f / 14.504f;
        }
        return Float.MIN_VALUE;
    }

    private final float convertUserBoostUnitsToPSIG(float f) {
        if (this.selectedUnitsIndex == indexPSIA) {
            return f - 14.696f * this.altitudeCorrection;
        }
        if (this.selectedUnitsIndex == indexPSI) {
            if (f < 0.0f) {
                return f / 29.921f * 14.696f;
            }
            return f;
        }
        if (this.selectedUnitsIndex == indexKGPCM2) {
            if (f < 0.0f) {
                return f / 29.921f * 14.696f / 0.0254f;
            }
            return f * 14.22f;
        }
        if (this.selectedUnitsIndex == indexBAR) {
            return f * 14.504f;
        }
        return Float.MIN_VALUE;
    }

    @Override
    public void resetUnitsSelection() {
        this.selectedUnitsIndex = unitsModel.getBoostPressureIndex();
    }
}

