/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.util.XFormatter;
import com.jgoodies.binding.beans.Model;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileFilter;

public class FilenameModel
extends Model {
    public static final String PROPERTYNAME_LAST_ACCESS_DIRECTORY = "lastAccessDirectory";
    public static final String PROPERTYNAME_USER_DEVICE_SETTINGS_DIRECTORY = "userDeviceSettingsDirectory";
    public static final String PROPERTYNAME_USER_FIRMWARE_DIRECTORY = "userFirmwareDirectory";
    public static final String PROPERTYNAME_REMEMBER_LAST_AUTO_OPEN = "rememberLastAutoOpen";
    public static final String PROPERTYNAME_DATALOG_BASE_DIRECTORY = "datalogBaseDirectory";
    public static final String PROPERTYNAME_DATALOG_CREATE_DIRECTORY = "datalogCreateDirectory";
    public static final String PROPERTYNAME_DATALOG_CREATE_DIRECTORY_SPEC = "datalogCreateDirectorySpec";
    public static final String PROPERTYNAME_DATALOG_SAVE_AS_FILE_SPEC = "datalogSaveAsFileSpec";
    public static final String PROPERTYNAME_DEVICE_SETTINGS_SAVE_AS_FILE_SPEC = "deviceSettingsSaveAsFileSpec";
    public static final String PROPERTYNAME_DIRECT_ACCESS_SAVE_AS_FILE_SPEC = "directAccessSaveAsFileSpec";
    private String lastAccessDirectory;
    private String userDatalogDirectory;
    private String userDeviceSettingsDirectory;
    private String userFirmwareDirectory;
    private String userDisplayDirectory;
    private boolean rememberLastAutoOpen;
    private String datalogBaseDirectory;
    private boolean datalogCreateDirectory;
    private String datalogCreateDirectorySpec;
    private String datalogSaveAsFileSpec;
    private String deviceSettingsSaveAsFileSpec;
    private String directAccessSaveAsFileSpec;
    public static final boolean DEFAULT_REMEMBER_LAST_AUTO_OPEN = true;
    public static final boolean DEFAULT_AUTO_CREATE_SAVE_DIRECTORY = true;
    public static final String DEFAULT_AUTO_SAVE_DIRECTORY_SPEC = "'logs.'yyyy.MM";
    public static final String DEFAULT_SAVE_AS_FILE_SPEC = "'log.'yyyy.MM.dd";
    public static final String DEFAULT_DEVICE_SETTINGS_FILE_SPEC = "'settings.'yyyy.MM.dd";
    public static final String DEFAULT_DIRECT_ACCESS_FILE_SPEC = "'directaccess.'yyyy.MM.dd";
    public static final String DEFAULT_FIRMWARE_REQUEST_FILE_SPEC = "yyyy.MM.dd";
    public static final String DIRECT_ACCESS_EXT = "eda";
    public static final String DEVICE_SETTINGS_EXT = "ecm";
    public static final String FIRMWARE_EXT = "efw";
    public static final String FIRMWARE_REQUEST_EXT = "fwr";
    public static final String DATALOG_EXT = "elg";
    public static final String DATALOG_EXPORT_EXT = "csv";
    private static final String[] directoryOptionsPropNames = new String[]{"user.home", "user.dir", "java.io.tmpdir"};

    public void setLastDeviceSettingsDirectory(String string) {
        this.setUserDeviceSettingsDirectory(string);
    }

    public String getLastUserFirmwareDirectory() {
        String string = this.getUserFirmwareDirectory();
        return FilenameModel.createOrGetValidDirectoryPath(string);
    }

    public void setLastUserFirmwareDirectory(String string) {
        this.setUserFirmwareDirectory(string);
    }

    public File createNewDeviceSettingsFile() {
        return FilenameModel.createNewFile(this.getUserDeviceSettingsDirectory(), this.getDeviceSettingsSaveAsFileSpec(), DEVICE_SETTINGS_EXT);
    }

    public File createNewDirectAccessFile() {
        return FilenameModel.createNewFile(this.getUserDeviceSettingsDirectory(), this.getDirectAccessSaveAsFileSpec(), DIRECT_ACCESS_EXT);
    }

    public File createNewFirmwareRequestFile(String string) {
        return FilenameModel.createNewFile(this.getLastUserFirmwareDirectory(), string + DEFAULT_FIRMWARE_REQUEST_FILE_SPEC, FIRMWARE_REQUEST_EXT);
    }

    public File createNewDatalogFile() {
        return FilenameModel.createNewFile(this.getLastAccessDirectory(), this.getDatalogSaveAsFileSpec(), DATALOG_EXT);
    }

    public File createNewAutoDatalogFile(boolean bl, String string) {
        String string2 = this.getDatalogBaseDirectory();
        if (bl) {
            string2 = FilenameModel.createOrGetValidDirectoryPath(this.getDatalogBaseDirectory());
        }
        if (this.getDatalogCreateDirectory()) {
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            string2 = string2 + FilenameModel.safeGenerateFilenameFromSpec(this.getDatalogCreateDirectorySpec());
            if (bl) {
                string2 = FilenameModel.createOrGetValidDirectoryPath(string2);
            }
        }
        return FilenameModel.createUniqueFilename(string2, this.getDatalogSaveAsFileSpec(), string);
    }

    private static File createNewFile(String string, String string2, String string3) {
        String string4 = FilenameModel.createOrGetValidDirectoryPath(string);
        return FilenameModel.createUniqueFilename(string4, string2, string3);
    }

    private static File createUniqueFilename(String string, String string2, String string3) {
        String string4;
        String string5 = FilenameModel.safeGenerateFilenameFromSpec(string2);
        string = FilenameModel.makeFullpath(string, string5, null);
        File file = new File(string + "." + string3);
        int n = 1;
        while ((file = new File((string4 = string + "-" + XFormatter.padZero(n, 2)) + "." + string3)).exists() && ++n < 100) {
        }
        return file;
    }

    public static FileFilter[] getSupportedFileFilters() {
        FileFilter[] fileFilterArray;
        fileFilterArray = new FileFilter[]{FilenameModel.getDatalogFileFilter(), FilenameModel.getDeviceSettingsFileFilter(), FilenameModel.getDirectAccessFileFilter(), FilenameModel.getFirmwareFileFilter(), FilenameModel.getFirmwareRequestFilter(), new FileFilterList(fileFilterArray)};
        return fileFilterArray;
    }

    public static FileFilter getFirmwareFileFilter() {
        return new StandardFileFilter(FIRMWARE_EXT, "ECMLink firmware files");
    }

    public static FileFilter getFirmwareRequestFilter() {
        return new StandardFileFilter(FIRMWARE_REQUEST_EXT, "ECMLink firmware request");
    }

    public static FileFilter getDeviceSettingsFileFilter() {
        return new StandardFileFilter(DEVICE_SETTINGS_EXT, "Device settings files");
    }

    public static FileFilter getDirectAccessFileFilter() {
        return new StandardFileFilter(DIRECT_ACCESS_EXT, "Direct access files");
    }

    public static FileFilter getDatalogFileFilter() {
        return new StandardFileFilter(DATALOG_EXT, "Datalog files");
    }

    public static FileFilter getDatalogExportFileFilter() {
        return new StandardFileFilter(DATALOG_EXPORT_EXT, "CSV files");
    }

    public static String createOrGetValidDirectoryPath(String string) {
        if (!FilenameModel.ensureDirectoryExists(string)) {
            string = FilenameModel.findGoodDirectory(string);
        }
        return string;
    }

    public static String makeFullpath(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (!string.endsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(string2);
        if (string3 != null) {
            stringBuffer.append(".");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String getFilenameNoExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String generateFilenameFromSpec(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(new Date());
    }

    public static String safeGenerateFilenameFromSpec(String string) {
        String string2 = string;
        try {
            string2 = FilenameModel.generateFilenameFromSpec(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static boolean ensureDirectoryExists(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return file.isDirectory();
    }

    public static String findGoodDirectory(String string) {
        File file = new File(string);
        while (!(file.exists() && file.isDirectory() || (file = file.getParentFile()) == null)) {
        }
        if (file == null) {
            file = FilenameModel.getDefaultHome();
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return FilenameModel.getSystemRootDirectory();
        }
    }

    public static File getDefaultHome() {
        File file = null;
        for (int i = 0; i < directoryOptionsPropNames.length; ++i) {
            String string = System.getProperty(directoryOptionsPropNames[i]);
            if (string == null) continue;
            file = new File(string);
            if (file.exists() && file.isDirectory()) break;
            file = null;
        }
        if (file == null) {
            file = new File(FilenameModel.getSystemRootDirectory());
        }
        return file;
    }

    private static String getSystemRootDirectory() {
        File[] fileArray = File.listRoots();
        if (fileArray.length > 0) {
            try {
                return fileArray[0].getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return File.separator;
    }

    public boolean getDatalogCreateDirectory() {
        return this.datalogCreateDirectory;
    }

    public void setDatalogCreateDirectory(boolean bl) {
        boolean bl2 = this.datalogCreateDirectory;
        this.datalogCreateDirectory = bl;
        this.firePropertyChange(PROPERTYNAME_DATALOG_CREATE_DIRECTORY, bl2, bl);
    }

    public String getDatalogCreateDirectorySpec() {
        return this.datalogCreateDirectorySpec;
    }

    public void setDatalogCreateDirectorySpec(String string) {
        String string2 = this.datalogCreateDirectorySpec;
        this.datalogCreateDirectorySpec = string;
        this.firePropertyChange(PROPERTYNAME_DATALOG_CREATE_DIRECTORY_SPEC, string2, string);
    }

    public String getUserFirmwareDirectory() {
        return this.userFirmwareDirectory;
    }

    public void setUserFirmwareDirectory(String string) {
        String string2 = this.userFirmwareDirectory;
        this.userFirmwareDirectory = string;
        this.firePropertyChange(PROPERTYNAME_USER_FIRMWARE_DIRECTORY, string2, string);
    }

    public String getUserDeviceSettingsDirectory() {
        return this.userDeviceSettingsDirectory;
    }

    public void setUserDeviceSettingsDirectory(String string) {
        String string2 = this.userDeviceSettingsDirectory;
        this.userDeviceSettingsDirectory = string;
        this.firePropertyChange(PROPERTYNAME_USER_DEVICE_SETTINGS_DIRECTORY, string2, string);
    }

    public String getDeviceSettingsSaveAsFileSpec() {
        return this.deviceSettingsSaveAsFileSpec;
    }

    public void setDeviceSettingsSaveAsFileSpec(String string) {
        String string2 = this.deviceSettingsSaveAsFileSpec;
        this.deviceSettingsSaveAsFileSpec = string;
        this.firePropertyChange(PROPERTYNAME_DEVICE_SETTINGS_SAVE_AS_FILE_SPEC, string2, string);
    }

    public String getDirectAccessSaveAsFileSpec() {
        return this.directAccessSaveAsFileSpec;
    }

    public void setDirectAccessSaveAsFileSpec(String string) {
        String string2 = this.directAccessSaveAsFileSpec;
        this.directAccessSaveAsFileSpec = string;
        this.firePropertyChange(PROPERTYNAME_DEVICE_SETTINGS_SAVE_AS_FILE_SPEC, string2, string);
    }

    public String getLastAccessDirectory() {
        return this.lastAccessDirectory;
    }

    public void setLastAccessDirectory(String string) {
        String string2 = this.lastAccessDirectory;
        this.lastAccessDirectory = string;
        this.firePropertyChange(PROPERTYNAME_LAST_ACCESS_DIRECTORY, string2, string);
    }

    public boolean getRememberLastAutoOpen() {
        return this.rememberLastAutoOpen;
    }

    public void setRememberLastAutoOpen(boolean bl) {
        boolean bl2 = this.rememberLastAutoOpen;
        this.rememberLastAutoOpen = bl;
        this.firePropertyChange(PROPERTYNAME_REMEMBER_LAST_AUTO_OPEN, bl2, bl);
    }

    public String getDatalogSaveAsFileSpec() {
        return this.datalogSaveAsFileSpec;
    }

    public void setDatalogSaveAsFileSpec(String string) {
        String string2 = this.datalogSaveAsFileSpec;
        this.datalogSaveAsFileSpec = string;
        this.firePropertyChange(PROPERTYNAME_DATALOG_SAVE_AS_FILE_SPEC, string2, string);
    }

    public String getDatalogBaseDirectory() {
        return this.datalogBaseDirectory;
    }

    public void setDatalogBaseDirectory(String string) {
        String string2 = this.datalogBaseDirectory;
        this.datalogBaseDirectory = string;
        this.firePropertyChange(PROPERTYNAME_DATALOG_BASE_DIRECTORY, string2, string);
    }

    public static String buildUserHomeBasePath() {
        String string;
        File file = FilenameModel.getDefaultHome();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = FilenameModel.getSystemRootDirectory();
        }
        return string + File.separator + "ecmlink";
    }

    public static String buildUserResourcesPath() {
        return FilenameModel.buildUserHomeBasePath() + File.separator + "resources";
    }

    public void restoreFrom(Preferences preferences) {
        preferences = preferences.node("filenames");
        String string = FilenameModel.buildUserHomeBasePath();
        String string2 = string + File.separator;
        this.setUserFirmwareDirectory(preferences.get(PROPERTYNAME_USER_FIRMWARE_DIRECTORY, string2 + "firmware"));
        this.setUserDeviceSettingsDirectory(preferences.get(PROPERTYNAME_USER_DEVICE_SETTINGS_DIRECTORY, string2 + "settings"));
        this.setLastAccessDirectory(preferences.get(PROPERTYNAME_LAST_ACCESS_DIRECTORY, string));
        this.setDatalogCreateDirectory(preferences.getBoolean(PROPERTYNAME_DATALOG_CREATE_DIRECTORY, true));
        this.setDatalogCreateDirectorySpec(preferences.get(PROPERTYNAME_DATALOG_CREATE_DIRECTORY_SPEC, DEFAULT_AUTO_SAVE_DIRECTORY_SPEC));
        this.setDeviceSettingsSaveAsFileSpec(preferences.get(PROPERTYNAME_DEVICE_SETTINGS_SAVE_AS_FILE_SPEC, DEFAULT_DEVICE_SETTINGS_FILE_SPEC));
        this.setDirectAccessSaveAsFileSpec(preferences.get(PROPERTYNAME_DIRECT_ACCESS_SAVE_AS_FILE_SPEC, DEFAULT_DIRECT_ACCESS_FILE_SPEC));
        this.setRememberLastAutoOpen(preferences.getBoolean(PROPERTYNAME_REMEMBER_LAST_AUTO_OPEN, true));
        this.setDatalogSaveAsFileSpec(preferences.get(PROPERTYNAME_DATALOG_SAVE_AS_FILE_SPEC, DEFAULT_SAVE_AS_FILE_SPEC));
        this.setDatalogBaseDirectory(preferences.get(PROPERTYNAME_DATALOG_BASE_DIRECTORY, string2 + "datalogs"));
    }

    public void storeIn(Preferences preferences) {
        preferences = preferences.node("filenames");
        preferences.put(PROPERTYNAME_USER_FIRMWARE_DIRECTORY, this.getUserFirmwareDirectory());
        preferences.put(PROPERTYNAME_USER_DEVICE_SETTINGS_DIRECTORY, this.getUserDeviceSettingsDirectory());
        preferences.put(PROPERTYNAME_LAST_ACCESS_DIRECTORY, this.getLastAccessDirectory());
        preferences.putBoolean(PROPERTYNAME_DATALOG_CREATE_DIRECTORY, this.getDatalogCreateDirectory());
        preferences.put(PROPERTYNAME_DATALOG_CREATE_DIRECTORY_SPEC, this.getDatalogCreateDirectorySpec());
        preferences.put(PROPERTYNAME_DEVICE_SETTINGS_SAVE_AS_FILE_SPEC, this.getDeviceSettingsSaveAsFileSpec());
        preferences.put(PROPERTYNAME_DIRECT_ACCESS_SAVE_AS_FILE_SPEC, this.getDirectAccessSaveAsFileSpec());
        preferences.putBoolean(PROPERTYNAME_REMEMBER_LAST_AUTO_OPEN, this.getRememberLastAutoOpen());
        preferences.put(PROPERTYNAME_DATALOG_SAVE_AS_FILE_SPEC, this.getDatalogSaveAsFileSpec());
        preferences.put(PROPERTYNAME_DATALOG_BASE_DIRECTORY, this.getDatalogBaseDirectory());
    }

    private static final class StandardFileFilter
    extends FileFilter {
        final String extension;
        final String descriptionPrefix;

        public StandardFileFilter(String string, String string2) {
            this.extension = string;
            this.descriptionPrefix = string2;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith("." + this.extension);
        }

        @Override
        public String getDescription() {
            return this.descriptionPrefix + " (*." + this.extension + ")";
        }
    }

    static class FileFilterList
    extends FileFilter {
        String description = "All supported files";
        FileFilter[] filterList;

        FileFilterList(FileFilter[] fileFilterArray) {
            this.filterList = fileFilterArray;
        }

        @Override
        public boolean accept(File file) {
            boolean bl = false;
            for (int i = 0; !bl && i < this.filterList.length; ++i) {
                if (this.filterList[i] == this) continue;
                bl |= this.filterList[i].accept(file);
            }
            return bl;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

