/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;

public final class FuelFlowFilter
extends UnitsFilter {
    static final int TYPE_FUEL_FLOW_FROM_CCPM = 0;
    private final int type;
    public static final String[] FUEL_FLOW_LABEL_LIST = UnitsModel.SELECT_LIST_INJECTOR_SIZE;
    static final int indexCcPerMin = UnitsModel.INDEX_INJECTOR_SIZE_CCPMIN;
    static final int indexLbPerHr = UnitsModel.INDEX_INJECTOR_SIZE_LBPHR;
    static final ObjectFilter FUEL_FLOW_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(FUEL_FLOW_LABEL_LIST, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final UnitsFilter FUEL_FLOW_CCPMIN_VALUE_FILTER = new FuelFlowFilter(0);

    public FuelFlowFilter(int n) {
        if (n != 0) {
            n = 0;
        }
        this.type = n;
    }

    @Override
    public final float filter(float f) {
        if (this.type == 0) {
            if (this.selectedUnitsIndex == indexCcPerMin) {
                return f;
            }
            if (this.selectedUnitsIndex == indexLbPerHr) {
                return f / 10.5f;
            }
        }
        return Float.MIN_VALUE;
    }

    @Override
    public float unfilter(float f) {
        if (this.type == 0) {
            if (this.selectedUnitsIndex == indexCcPerMin) {
                return f;
            }
            if (this.selectedUnitsIndex == indexLbPerHr) {
                return f * 10.5f;
            }
        }
        return Float.MIN_VALUE;
    }

    @Override
    public void resetUnitsSelection() {
        this.selectedUnitsIndex = unitsModel.getInjectorSizeIndex();
    }
}

