/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;

public final class FuelPressureFilter
extends UnitsFilter {
    static final int TYPE_FUEL_PRESSURE_FROM_PSIG = 0;
    private final int type;
    public static final String[] FUEL_PRESSURE_LABEL_LIST = UnitsModel.SELECT_LIST_FLUID_PRESSURE;
    static final int indexPSI = UnitsModel.INDEX_FLUID_PRESSURE_PSI;
    static final int indexKGPCM2 = UnitsModel.INDEX_FLUID_PRESSURE_KGPCM2;
    static final int indexBAR = UnitsModel.INDEX_FLUID_PRESSURE_BAR;
    static final int indexKPA = UnitsModel.INDEX_FLUID_PRESSURE_KPA;
    static final ObjectFilter FLUID_PRESSURE_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(FUEL_PRESSURE_LABEL_LIST, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final UnitsFilter FUEL_PRESSURE_PSIG_VALUE_FILTER = new FuelPressureFilter(0);

    public FuelPressureFilter(int n) {
        if (n != 0) {
            n = 0;
        }
        this.type = n;
    }

    @Override
    public final float filter(float f) {
        if (this.type == 0) {
            return this.convertPSIGToFuelPressureUnits(f);
        }
        return Float.MIN_VALUE;
    }

    @Override
    public float unfilter(float f) {
        if (this.type == 0) {
            return this.convertFuelPressureUnitsToPSIG(f);
        }
        return Float.MIN_VALUE;
    }

    private final float convertPSIGToFuelPressureUnits(float f) {
        if (this.selectedUnitsIndex == indexPSI) {
            return f;
        }
        if (this.selectedUnitsIndex == indexKGPCM2) {
            return f / 14.22f;
        }
        if (this.selectedUnitsIndex == indexBAR) {
            return f / 14.504f;
        }
        if (this.selectedUnitsIndex == indexKPA) {
            return f / 0.14504f;
        }
        return Float.MIN_VALUE;
    }

    private final float convertFuelPressureUnitsToPSIG(float f) {
        if (this.selectedUnitsIndex == indexPSI) {
            return f;
        }
        if (this.selectedUnitsIndex == indexKGPCM2) {
            return f * 14.22f;
        }
        if (this.selectedUnitsIndex == indexBAR) {
            return f * 14.504f;
        }
        if (this.selectedUnitsIndex == indexKPA) {
            return f * 0.14504f;
        }
        return Float.MIN_VALUE;
    }

    @Override
    public void resetUnitsSelection() {
        this.selectedUnitsIndex = unitsModel.getFluidPressureIndex();
    }
}

