/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;

public final class LambdaFilter
extends UnitsFilter {
    private float stoichRatio = 14.7f;
    public static final String[] LAMBDA_LABEL_LIST = new String[]{":1", "\u03bb"};
    static final int indexLambda = UnitsModel.INDEX_AF_MIXTURE_LAMBDA;
    static final int indexAFR = UnitsModel.INDEX_AF_MIXTURE_AFR;
    static final ObjectFilter AF_MIXTURE_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(LAMBDA_LABEL_LIST, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final UnitsFilter AF_MIXTURE_VALUE_FILTER = new LambdaFilter();

    public LambdaFilter createNewInstance() {
        return new LambdaFilter();
    }

    public void setStoichRatio(float f) {
        this.stoichRatio = f;
    }

    public int getPreferredPrec() {
        if (this.selectedUnitsIndex == indexLambda) {
            return 2;
        }
        return 1;
    }

    @Override
    public final float filter(float f) {
        if (this.selectedUnitsIndex == indexLambda) {
            return f;
        }
        return f * this.stoichRatio;
    }

    @Override
    public float unfilter(float f) {
        if (this.selectedUnitsIndex == indexLambda) {
            return f;
        }
        return f / this.stoichRatio;
    }

    @Override
    public void resetUnitsSelection() {
        this.selectedUnitsIndex = unitsModel.getAfMixtureIndex();
    }
}

