/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.control.DeviceUIController;
import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.MainPanelController;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.control.mitsu.MitsuUIAdapter;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModelBridge;
import com.ecmtuning.ecmlink.model.StatusBarModel;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabbedPane;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.application.ApplicationAdapter;
import com.jgoodies.uif.application.ApplicationEvent;
import com.jgoodies.uif.application.ApplicationListener;
import com.jgoodies.uif.lazy.BackgroundLoader;
import com.jgoodies.uif.lazy.Preparable;
import com.jgoodies.uifextras.convenience.SetupManager;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SingleSelectionModel;

public class MainModel
extends Model {
    public static final String PROPERTYNAME_SHOW_BACKGROUND_STATUS = "showBackgroundStatus";
    public static final String PROPERTYNAME_SHOW_DEVICE_TABS_AT_STARTUP = "showDeviceTabsAtStartup";
    public static final String PROPERTYNAME_SHOW_TOOLBAR = "showToolbar";
    public static final String PROPERTYNAME_MAIN_DEVICE_TAB_SHOWN = "mainDeviceTabShown";
    public static final String PROPERTYNAME_AUX_DEVICE_TAB_SHOWN = "auxDeviceTabShown";
    public static final String PROPERTYNAME_LIVE_DATALOG_TAB_SHOWN = "liveDatalogTabShown";
    public static final String PROPERTYNAME_MAIN_INPUT_DISABLED = "mainInputDisabled";
    private DeviceManagerFactory deviceManagerFactory;
    private SerialPortManager serialPortManager;
    private StatusBarModel primaryStatusBarModel;
    private FilenameModel filenameModel;
    private MainActions mainActions;
    private MainView mainView;
    private MainPanelController mainPanelController;
    private DeviceUIController deviceUIController;
    private DefaultSingleSelectionModel mainTabSelectionModel;
    private boolean showBackgroundStatus;
    private boolean showDeviceTabsAtStartup;
    private boolean showToolbar;
    private HelpBroker helpBroker;
    private HelpSet helpSet;
    private boolean mainDeviceTabShown;
    private boolean auxDeviceTabShown;
    private boolean liveDatalogTabShown;
    private boolean mainInputDisabled;
    private static final boolean DEFAULT_SHOW_BACKGROUND_STATUS = true;
    private static final boolean DEFAULT_SHOW_WELCOME_TAB = true;
    private static final boolean DEFAULT_SHOW_TOOLBAR = true;
    private static MainModel instance;
    private Logger logger = Logger.getLogger(MainModel.class.getName());

    private MainModel() {
    }

    private void initialize() {
        this.filenameModel = new FilenameModel();
        this.mainTabSelectionModel = new DefaultSingleSelectionModel();
        this.mainActions = new MainActions();
        this.deviceManagerFactory = DeviceManagerFactory.getInstance();
        DeviceUIController.addKnownUIAdapter(new ECMLinkUIAdapter());
        DeviceUIController.addKnownUIAdapter(new MitsuUIAdapter());
        this.serialPortManager = SerialPortManager.getInstance();
        this.mainPanelController = new MainPanelController();
        this.deviceUIController = new DeviceUIController();
        this.restoreState();
        this.initEventHandling();
        MainModelBridge.getInstance().addPropertyChangeListener("showErrorMessage", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() != null) {
                    MainModelBridge.ErrorMessageRecord errorMessageRecord = (MainModelBridge.ErrorMessageRecord)propertyChangeEvent.getNewValue();
                    MainModel.showErrorMessage(errorMessageRecord.message, errorMessageRecord.title);
                }
            }
        });
    }

    public void addInitializers(BackgroundLoader backgroundLoader) {
        backgroundLoader.add(this.getMainActions().createInitializer());
        DataManager.setApplicationPreferencesNode(Application.getUserPreferences());
        backgroundLoader.add(new Preparable(){

            public void prepare() {
                DataManager.initialize();
            }
        });
    }

    public static MainModel getInstance() {
        if (instance == null) {
            instance = new MainModel();
            instance.initialize();
        }
        return instance;
    }

    private void initEventHandling() {
        Application.addApplicationListener((ApplicationListener)new ApplicationClosingHandler());
        this.mainPanelController.initEventHandling();
        this.deviceUIController.initEventHandling();
    }

    public void startUp() {
        this.deviceManagerFactory.startUp();
        this.setMainDeviceTabShown(this.getShowDeviceTabsAtStartup());
        this.setAuxDeviceTabShown(this.getShowDeviceTabsAtStartup());
    }

    public void registerMainView(MainView mainView) {
        this.mainView = mainView;
    }

    public DeviceUIController getDeviceUIController() {
        return this.deviceUIController;
    }

    public HelpBroker getHelpBroker() {
        if (this.helpBroker == null) {
            try {
                URL uRL = HelpSet.findHelpSet(null, (String)"Help");
                this.helpSet = new HelpSet(null, uRL);
            }
            catch (HelpSetException helpSetException) {
                this.logger.warning(helpSetException.getLocalizedMessage());
                return null;
            }
            this.helpBroker = this.helpSet.createHelpBroker();
        }
        return this.helpBroker;
    }

    public static void showInfoMessage(String string) {
        JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), string);
    }

    public static void showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), string, string2, 0);
    }

    public static JFrame getDefaultParentFrame() {
        return Application.getDefaultParentFrame();
    }

    public MainView getMainView() {
        return this.mainView;
    }

    public MainActions getMainActions() {
        return this.mainActions;
    }

    public StatusBarModel getStatusBarModelFor(DeviceManager deviceManager) {
        if (this.deviceManagerFactory.getMainDeviceManager() == deviceManager) {
            return this.getPrimaryStatusBarModel();
        }
        return null;
    }

    public synchronized StatusBarModel getPrimaryStatusBarModel() {
        if (this.primaryStatusBarModel == null) {
            this.primaryStatusBarModel = new StatusBarModel(true);
        }
        return this.primaryStatusBarModel;
    }

    public SingleSelectionModel getTabPanelSelectionModel() {
        return this.mainTabSelectionModel;
    }

    public ArrayList getTabPanelArrayList() {
        return this.mainView.getTabs();
    }

    public void closeCurrentTab() {
        int n = this.mainTabSelectionModel.getSelectedIndex();
        this.closeTabAt(n);
    }

    public void advanceTabSelection(boolean bl) {
        TrackedTabbedPane trackedTabbedPane = this.mainView.getTabbedPane();
        int n = this.mainTabSelectionModel.getSelectedIndex();
        if (n == -1) {
            if (trackedTabbedPane.getTabCount() > 0) {
                this.mainTabSelectionModel.setSelectedIndex(0);
            }
        } else {
            if ((n += bl ? 1 : -1) < 0) {
                n = trackedTabbedPane.getTabCount() - 1;
            } else if (n >= trackedTabbedPane.getTabCount()) {
                n = 0;
            }
            this.mainTabSelectionModel.setSelectedIndex(n);
        }
    }

    public void closeTabAt(int n) {
        TrackedTabbedPane trackedTabbedPane = this.mainView.getTabbedPane();
        if (n != -1) {
            trackedTabbedPane.removeTabAt(n);
            int n2 = trackedTabbedPane.getTabCount();
            int n3 = -1;
            if (n < n2) {
                n3 = n;
            } else if (n2 > 0) {
                n3 = n2 - 1;
            }
            if (n3 != -1) {
                Component component = trackedTabbedPane.getComponentAt(n3);
                component.getParent().requestFocus();
                this.mainTabSelectionModel.setSelectedIndex(n3);
            }
        }
    }

    public void addTab(TrackedTabPanel trackedTabPanel, boolean bl) {
        TrackedTabbedPane trackedTabbedPane = this.mainView.getTabbedPane();
        trackedTabbedPane.add(trackedTabPanel);
        int n = trackedTabbedPane.indexOfTab(trackedTabPanel);
        this.setOptionalTabCloseButton(n, trackedTabPanel);
        if (bl) {
            this.mainTabSelectionModel.setSelectedIndex(n);
        }
    }

    public void findAndCloseTab(TrackedTabPanel trackedTabPanel) {
        if (trackedTabPanel == null) {
            return;
        }
        TrackedTabbedPane trackedTabbedPane = this.mainView.getTabbedPane();
        int n = trackedTabbedPane.indexOfTab(trackedTabPanel);
        if (n != -1) {
            trackedTabbedPane.removeTabAt(n);
        }
    }

    public void addOrMakeActiveTab(TrackedTabPanel trackedTabPanel, boolean bl) {
        TrackedTabbedPane trackedTabbedPane = this.mainView.getTabbedPane();
        int n = trackedTabbedPane.indexOfTab(trackedTabPanel);
        if (n == -1) {
            if (bl) {
                trackedTabbedPane.add((Component)trackedTabPanel, 0);
                n = 0;
            } else {
                trackedTabbedPane.add(trackedTabPanel);
                n = trackedTabbedPane.indexOfTab(trackedTabPanel);
            }
            this.setOptionalTabCloseButton(n, trackedTabPanel);
        }
        this.mainTabSelectionModel.setSelectedIndex(n);
    }

    private void setOptionalTabCloseButton(int n, TrackedTabPanel trackedTabPanel) {
    }

    public FilenameModel getFilenameModel() {
        return this.filenameModel;
    }

    public boolean getShowBackgroundStatus() {
        return this.showBackgroundStatus;
    }

    public void setShowBackgroundStatus(boolean bl) {
        boolean bl2 = this.showBackgroundStatus;
        this.showBackgroundStatus = bl;
        this.firePropertyChange(PROPERTYNAME_SHOW_BACKGROUND_STATUS, bl2, bl);
    }

    public boolean getShowDeviceTabsAtStartup() {
        return this.showDeviceTabsAtStartup;
    }

    public void setShowDeviceTabsAtStartup(boolean bl) {
        boolean bl2 = this.showDeviceTabsAtStartup;
        this.showDeviceTabsAtStartup = bl;
        this.firePropertyChange(PROPERTYNAME_SHOW_DEVICE_TABS_AT_STARTUP, bl2, bl);
    }

    public boolean getShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean bl) {
        boolean bl2 = this.showToolbar;
        this.showToolbar = bl;
        this.firePropertyChange(PROPERTYNAME_SHOW_TOOLBAR, bl2, bl);
    }

    public boolean getLiveDatalogTabShown() {
        return this.liveDatalogTabShown;
    }

    public void setLiveDatalogTabShown(boolean bl) {
        boolean bl2 = this.liveDatalogTabShown;
        this.liveDatalogTabShown = bl;
        this.firePropertyChange(PROPERTYNAME_LIVE_DATALOG_TAB_SHOWN, null, new Boolean(bl));
    }

    public boolean getMainDeviceTabShown() {
        return this.mainDeviceTabShown;
    }

    public void setMainDeviceTabShown(boolean bl) {
        this.mainDeviceTabShown = bl;
        this.firePropertyChange(PROPERTYNAME_MAIN_DEVICE_TAB_SHOWN, null, new Boolean(bl));
    }

    public boolean getAuxDeviceTabShown() {
        return this.auxDeviceTabShown;
    }

    public void setAuxDeviceTabShown(boolean bl) {
        if (this.deviceManagerFactory.getAuxDeviceManager() == null) {
            return;
        }
        this.auxDeviceTabShown = bl;
        this.firePropertyChange(PROPERTYNAME_AUX_DEVICE_TAB_SHOWN, null, new Boolean(bl));
    }

    public boolean getMainInputDisabled() {
        return this.mainInputDisabled;
    }

    public void setMainInputDisabled(boolean bl) {
        boolean bl2 = this.mainInputDisabled;
        this.mainInputDisabled = bl;
        this.firePropertyChange(PROPERTYNAME_MAIN_INPUT_DISABLED, bl2, bl);
    }

    public void restoreState() {
        Preferences preferences = Application.getUserPreferences();
        this.setShowBackgroundStatus(preferences.getBoolean(PROPERTYNAME_SHOW_BACKGROUND_STATUS, true));
        this.setShowDeviceTabsAtStartup(preferences.getBoolean(PROPERTYNAME_SHOW_DEVICE_TABS_AT_STARTUP, true));
        this.setShowToolbar(preferences.getBoolean(PROPERTYNAME_SHOW_TOOLBAR, true));
        this.deviceManagerFactory.restoreFrom(preferences);
        this.serialPortManager.restoreFrom(preferences);
        this.filenameModel.restoreFrom(preferences);
        UnitsModel.getInstance().restoreFrom(preferences);
    }

    public void storeState() {
        Preferences preferences = Application.getUserPreferences();
        preferences.putBoolean(PROPERTYNAME_SHOW_BACKGROUND_STATUS, this.showBackgroundStatus);
        preferences.putBoolean(PROPERTYNAME_SHOW_DEVICE_TABS_AT_STARTUP, this.showDeviceTabsAtStartup);
        preferences.putBoolean(PROPERTYNAME_SHOW_TOOLBAR, this.showToolbar);
        this.deviceManagerFactory.storeIn(preferences);
        this.serialPortManager.storeIn(preferences);
        this.filenameModel.storeIn(preferences);
        UnitsModel.getInstance().storeIn(preferences);
        SetupManager.incrementUsageCounter();
    }

    public void aboutToExitApplication() {
        if (this.requestForWindowClose()) {
            this.exitApplication();
        }
    }

    private boolean requestForWindowClose() {
        return true;
    }

    private void exitApplication() {
        Application.close();
    }

    private final class ApplicationClosingHandler
    extends ApplicationAdapter {
        private ApplicationClosingHandler() {
        }

        public void applicationClosing(ApplicationEvent applicationEvent) {
            try {
                MainModel.this.storeState();
            }
            catch (Exception exception) {
                MainModel.this.logger.log(Level.WARNING, "Received exception when shutting down", exception);
            }
        }
    }
}

