/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.device.DeviceListener;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.model.MainModel;
import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;

public class StatusBarModel
extends Model
implements DeviceListener,
Runnable {
    public static final String PROPERTYNAME_STATUS_TEXT = "statusText";
    public static final String PROPERTYNAME_STATUS_PROGRESS = "statusProgress";
    public static final String PROPERTYNAME_STATUS_STATE = "statusState";
    public static final int STATE_ONLINE = 0;
    public static final int STATE_OFFLINE = 1;
    public static final int STATE_BUSY = 2;
    public static final int STATE_ERROR = 3;
    private static final String EMPTY_NEW_STATUS_TEXT = "";
    private static final int EMPTY_NEW_STATUS_PROGRESS = -1;
    private static final int EMPTY_NEW_STATUS_STATE = -1;
    private static final long DEFAULT_SLEEP_TIME = 1000L;
    private static final long TEXT_UPDATE_MILLIS = 750L;
    private static final long TEXT_LINGER_MILLIS = 3500L;
    private static final long STATE_UPDATE_MILLIS = 500L;
    private static final long STATE_LINGER_MILLIS = 1000L;
    private static final long MILLIS_RESOLUTION = 50L;
    private final MainModel mainModel = MainModel.getInstance();
    private final DeviceManagerFactory deviceManagerFactory;
    private final boolean isPrimary;
    private String statusText = "";
    private int statusProgress = -1;
    private int statusState = -1;
    private boolean connectedStatus;
    private Thread backgroundThread;
    private long nextStatusTextMillis;
    private long nextStatusTextClearMillis;
    private long nextStatusStateMillis;
    private long nextStatusStateClearMillis;
    private boolean userRequestInProgress;
    private String nextStatusText = "";
    private int nextStatusProgress = -1;
    private int nextStatusState = -1;

    public StatusBarModel(boolean bl) {
        this.isPrimary = bl;
        this.deviceManagerFactory = DeviceManagerFactory.getInstance();
        String string = bl ? "mainDeviceManager" : "auxDeviceManager";
        PropertyChangeListenerAdapter propertyChangeListenerAdapter = new PropertyChangeListenerAdapter(this);
        this.deviceManagerFactory.addPropertyChangeListener(string, propertyChangeListenerAdapter);
        this.backgroundThread = new Thread(this);
        this.backgroundThread.setName("StatusBar");
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.setPriority(1);
        this.backgroundThread.start();
    }

    @Override
    public synchronized void connectAttemptStart() {
        this.connectProgress(0);
    }

    @Override
    public synchronized void connectProgress(int n) {
        this.nextStatusProgress = n;
        this.notifyAll();
    }

    @Override
    public synchronized void connectAttemptEnd() {
        this.connectProgress(0);
    }

    @Override
    public synchronized void connectStatus(boolean bl) {
        this.nextStatusState = bl ? 0 : 1;
        this.connectedStatus = bl;
        this.notifyAll();
    }

    @Override
    public synchronized void commandSendStart() {
        this.nextStatusState = 2;
        this.notifyAll();
    }

    @Override
    public synchronized void commandSendEndError() {
        this.nextStatusState = 3;
        this.notifyAll();
    }

    @Override
    public void commandSendEnd() {
        this.connectStatus(true);
    }

    @Override
    public synchronized void userRequestStart() {
        this.userRequestInProgress = true;
    }

    @Override
    public void userRequestEnd() {
        this.userRequestInProgress = false;
    }

    @Override
    public synchronized void statusTextUpdate(String string) {
        Logger.getLogger("statusbar").info(string);
        this.nextStatusText = string;
        this.notifyAll();
    }

    @Override
    public synchronized void run() {
        this.nextStatusTextClearMillis = Long.MAX_VALUE;
        this.nextStatusStateClearMillis = Long.MAX_VALUE;
        this.nextStatusTextMillis = this.nextStatusStateMillis = System.currentTimeMillis();
        while (true) {
            long l;
            long l2 = System.currentTimeMillis();
            boolean bl = this.mainModel.getShowBackgroundStatus();
            if (this.nextStatusText != EMPTY_NEW_STATUS_TEXT) {
                l = this.nextStatusTextMillis - l2;
                if (l <= 50L) {
                    if (this.userRequestInProgress || bl) {
                        this.setStatusText(this.nextStatusText);
                        this.nextStatusTextMillis = l2 + 750L;
                    } else {
                        this.setStatusText(EMPTY_NEW_STATUS_TEXT);
                    }
                    this.nextStatusTextClearMillis = l2 + 3500L;
                    this.nextStatusText = EMPTY_NEW_STATUS_TEXT;
                }
            } else if (this.nextStatusTextClearMillis - l2 < 50L) {
                this.setStatusText(EMPTY_NEW_STATUS_TEXT);
                this.nextStatusTextClearMillis = Long.MAX_VALUE;
            }
            if (this.nextStatusState != -1) {
                l = this.nextStatusStateMillis - l2;
                if (l <= 50L) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.nextStatusState == 0 || this.nextStatusState == 1;
                    if (this.userRequestInProgress || bl || bl2) {
                        this.setStatusState(this.nextStatusState);
                        this.nextStatusStateMillis = l2 + 500L;
                    }
                    this.nextStatusStateClearMillis = l2 + 1000L;
                    this.nextStatusState = -1;
                }
            } else if (this.nextStatusStateClearMillis - l2 < 50L) {
                this.setStatusState(this.connectedStatus ? 0 : 1);
                this.nextStatusStateClearMillis = Long.MAX_VALUE;
            }
            if (this.nextStatusProgress != -1) {
                if (this.userRequestInProgress || bl) {
                    this.setStatusProgress(this.nextStatusProgress);
                } else {
                    this.setStatusProgress(0);
                }
                this.nextStatusProgress = -1;
            }
            l = 1000L;
            if (this.nextStatusText != EMPTY_NEW_STATUS_TEXT) {
                l = Math.min(l, this.nextStatusTextMillis - l2);
            }
            if (this.nextStatusState != -1) {
                l = Math.min(l, this.nextStatusStateMillis - l2);
            }
            l = Math.min(l, this.nextStatusTextClearMillis - l2);
            if ((l = Math.min(l, this.nextStatusStateClearMillis - l2)) < 0L) {
                l = 1000L;
            }
            try {
                if (l <= 50L) continue;
                this.wait(l);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public int getStatusProgress() {
        return this.statusProgress;
    }

    public void setStatusProgress(int n) {
        int n2 = this.statusProgress;
        this.statusProgress = n;
        this.firePropertyChange(PROPERTYNAME_STATUS_PROGRESS, n2, n);
    }

    public int getStatusState() {
        return this.statusState;
    }

    public void setStatusState(int n) {
        int n2 = this.statusState;
        this.statusState = n;
        this.firePropertyChange(PROPERTYNAME_STATUS_STATE, n2, n);
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String string) {
        if (string == null) {
            string = EMPTY_NEW_STATUS_TEXT;
        }
        String string2 = this.statusText;
        this.statusText = string;
        this.firePropertyChange(PROPERTYNAME_STATUS_TEXT, string2, string);
    }

    static class PropertyChangeListenerAdapter
    implements PropertyChangeListener {
        DeviceListener listener;

        PropertyChangeListenerAdapter(DeviceListener deviceListener) {
            this.listener = deviceListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DeviceManager deviceManager = (DeviceManager)((Object)propertyChangeEvent.getOldValue());
            if (deviceManager != null) {
                deviceManager.removeDeviceListener(this.listener);
            }
            if ((deviceManager = (DeviceManager)((Object)propertyChangeEvent.getNewValue())) != null) {
                deviceManager.addDeviceListener(this.listener);
            }
        }
    }
}

