/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.model;

import com.ecmtuning.ecmlink.model.UnitsFilter;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;

public class UnitsMiscHelper {
    public static final String[] LABEL_LIST_SPEED = new String[]{"mph", "km/h"};
    public static final String[] LABEL_LIST_AIRFLOWMASS = new String[]{"gm/s", "lb/m"};
    public static final String[] LABEL_LIST_DISTANCE_FEET = new String[]{"ft", "m"};
    public static final String[] LABEL_LIST_MILEAGE = new String[]{"mpg", "kpl"};
    static final int indexDistanceKm = UnitsModel.INDEX_DISTANCE_KILOMETERS;
    static final int indexAirflowLb = UnitsModel.INDEX_AIRFLOW_MASS_POUNDS;
    static final ObjectFilter SPEED_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(LABEL_LIST_SPEED, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final ObjectFilter AIRFLOWMASS_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(LABEL_LIST_AIRFLOWMASS, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final ObjectFilter DISTANCE_FEET_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(LABEL_LIST_DISTANCE_FEET, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final ObjectFilter MILEAGE_LABEL_FILTER = new ObjectFilter(){

        @Override
        public Object filter(Object object) {
            return UnitsModel.getCheckedUnitsLabel(LABEL_LIST_MILEAGE, ((Number)object).intValue());
        }

        @Override
        public Object unfilter(Object object, Object object2) throws Exception {
            return object;
        }
    };
    static final UnitsFilter SPEED_MPH_VALUE_FILTER = new UnitsFilter(){

        @Override
        public final float filter(float f) {
            if (this.selectedUnitsIndex == indexDistanceKm) {
                return 1.609344f * f;
            }
            return f;
        }

        @Override
        public final float unfilter(float f) {
            if (this.selectedUnitsIndex == indexDistanceKm) {
                return f / 1.609344f;
            }
            return f;
        }

        @Override
        public final void resetUnitsSelection() {
            this.selectedUnitsIndex = unitsModel.getDistanceIndex();
        }
    };
    static final UnitsFilter AIRFLOWMASS_GMPS_VALUE_FILTER = new UnitsFilter(){

        @Override
        public final float filter(float f) {
            if (this.selectedUnitsIndex == indexAirflowLb) {
                return f / 7.56f;
            }
            return f;
        }

        @Override
        public final float unfilter(float f) {
            if (this.selectedUnitsIndex == indexAirflowLb) {
                return f * 7.56f;
            }
            return f;
        }

        @Override
        public final void resetUnitsSelection() {
            this.selectedUnitsIndex = unitsModel.getAirflowMassIndex();
        }
    };
    static final UnitsFilter DISTANCE_FEET_VALUE_FILTER = new UnitsFilter(){

        @Override
        public final float filter(float f) {
            if (this.selectedUnitsIndex == indexDistanceKm) {
                return 0.3048f * f;
            }
            return f;
        }

        @Override
        public final float unfilter(float f) {
            if (this.selectedUnitsIndex == indexDistanceKm) {
                return f / 0.3048f;
            }
            return f;
        }

        @Override
        public final void resetUnitsSelection() {
            this.selectedUnitsIndex = unitsModel.getDistanceIndex();
        }
    };
    static final UnitsFilter MILEAGE_MPG_VALUE_FILTER = new UnitsFilter(){

        @Override
        public final float filter(float f) {
            if (this.selectedUnitsIndex == indexDistanceKm) {
                return Math.min(999.9f, 0.42514372f * f);
            }
            return Math.min(999.9f, f);
        }

        @Override
        public final float unfilter(float f) {
            if (this.selectedUnitsIndex == indexDistanceKm) {
                return f / 0.42514372f;
            }
            return f;
        }

        @Override
        public final void resetUnitsSelection() {
            this.selectedUnitsIndex = unitsModel.getDistanceIndex();
        }
    };
}

