/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import com.ecmtuning.ecmlink.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public final class BasicStrings {
    public static final String getSubstring(String string, String string2, String string3) {
        String string4 = null;
        int n = 0;
        if (string2 != null) {
            n = string.indexOf(string2);
        } else {
            string2 = "";
        }
        if (n != -1) {
            int n2 = n + string2.length();
            if (string3 == null) {
                if (n2 < string.length()) {
                    string4 = string.substring(n2);
                }
            } else {
                int n3 = string.indexOf(string3, n2);
                if (n3 != -1) {
                    string4 = string.substring(n2, n3);
                }
            }
        }
        return string4;
    }

    public static final String replaceAll(String string, Map map) {
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = ((String)object).length();
                if (n2 > (n = ((String)object2).length())) {
                    return -1;
                }
                if (n2 == n) {
                    return 0;
                }
                return 1;
            }
        });
        for (String string2 : arrayList) {
            if (string.indexOf(string2) == -1) continue;
            string = BasicStrings._replace(string, string2, (String)map.get(string2));
        }
        return string;
    }

    public static final String replace(String string, String string2, String string3) {
        if (string2 == null || string3 == null || string2.equals("")) {
            throw new IllegalArgumentException("Illegal pattern(s)");
        }
        if (string.indexOf(string2) == -1) {
            return string;
        }
        return BasicStrings._replace(string, string2, string3);
    }

    private static final String _replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static final String nullIfEmpty(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string;
    }

    public static final String blankIfEmpty(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string;
    }

    public static final boolean isNullOrEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final int count(String string, char c) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static final boolean startsWithAny(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static final boolean containsAny(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            return true;
        }
        return false;
    }

    public static final boolean contains(String[] stringArray, String string) {
        return ListUtil.contains(stringArray, string);
    }

    public static final int findClosestMatch(String string, String[] stringArray) {
        double[] dArray = BasicStrings.charCounts(string);
        int n = -1;
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray2 = BasicStrings.charCounts(stringArray[i]);
            double d2 = BasicStrings.calcCountsDist(dArray, dArray2);
            if (n != -1 && !(d2 <= d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public static final double calcDist(String string, String string2) {
        double[] dArray = BasicStrings.charCounts(string);
        double[] dArray2 = BasicStrings.charCounts(string2);
        return BasicStrings.calcCountsDist(dArray, dArray2);
    }

    public static final double[] charCounts(String string) {
        int n;
        string = string.toLowerCase();
        double[] dArray = new double[26];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c < 'a' || c > 'z') continue;
            int n2 = c - 97;
            dArray[n2] = dArray[n2] + 1.0;
        }
        return dArray;
    }

    public static final double calcCountsDist(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.pow(dArray[i] - dArray2[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static final String[] dotSplit(String string) {
        return string.split("\\.");
    }

    public static final String dotMergeFirst(String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= n - 1) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static final String dotMergeFrom(String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = stringArray.length;
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= n2 - 1) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static final String[] trimAll(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static final String[] lowerCaseAll(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].toLowerCase();
        }
        return stringArray;
    }
}

