/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import java.util.Arrays;

public class CircularQueue {
    int cnt;
    int headIndex;
    int tailIndex;
    final int maxCnt;
    final Object[] elements;

    public CircularQueue(int n) {
        this.maxCnt = n;
        this.elements = new Object[this.maxCnt];
        this.emptyQueue();
    }

    public CircularQueue(Object[] objectArray) {
        this.maxCnt = objectArray.length;
        this.elements = new Object[this.maxCnt];
        this.emptyQueue();
        System.arraycopy(objectArray, 0, this.elements, 0, this.maxCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyQueueDataFrom(CircularQueue circularQueue) {
        CircularQueue circularQueue2 = circularQueue;
        synchronized (circularQueue2) {
            while (!circularQueue.isEmpty()) {
                this.push(circularQueue.pop(false));
            }
            circularQueue.emptyQueue();
        }
    }

    public synchronized void emptyQueue() {
        this.tailIndex = 0;
        this.headIndex = 0;
        this.cnt = 0;
        Arrays.fill(this.elements, null);
    }

    public synchronized int size() {
        return this.cnt;
    }

    public synchronized boolean isEmpty() {
        return this.cnt == 0;
    }

    public int getMaxCount() {
        return this.maxCnt;
    }

    public synchronized Object pop(boolean bl) {
        if (this.cnt == 0) {
            return null;
        }
        Object object = this.elements[this.headIndex];
        if (!bl) {
            this.elements[this.headIndex] = null;
        }
        ++this.headIndex;
        this.headIndex %= this.maxCnt;
        --this.cnt;
        return object;
    }

    public synchronized void push(Object object) {
        this._push(object, true);
    }

    public synchronized Object push() {
        return this._push(null, false);
    }

    private Object _push(Object object, boolean bl) {
        if (this.headIndex == this.tailIndex && this.cnt != 0) {
            ++this.headIndex;
            this.headIndex %= this.maxCnt;
            --this.cnt;
        }
        Object object2 = this.elements[this.tailIndex];
        if (bl) {
            this.elements[this.tailIndex] = object;
        }
        ++this.tailIndex;
        this.tailIndex %= this.maxCnt;
        ++this.cnt;
        return object2;
    }
}

