/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

public class EventRateTracker {
    private int maxCount;
    private long maxMillis;
    private int currentCount;
    private long firstMillis;

    public EventRateTracker(int n, long l) {
        this.maxCount = n;
        this.maxMillis = l;
        this.reset();
    }

    public void reset() {
        this.currentCount = 0;
        this.firstMillis = -1L;
    }

    public boolean recordEvent() {
        boolean bl = false;
        if (this.firstMillis == -1L) {
            this.firstMillis = System.currentTimeMillis();
            this.currentCount = 1;
        } else {
            ++this.currentCount;
            int n = this.currentCount / this.maxCount;
            if (n >= 1) {
                long l = System.currentTimeMillis() - this.firstMillis;
                if ((l /= (long)n) >= this.maxMillis) {
                    bl = true;
                    this.reset();
                }
            }
        }
        return bl;
    }
}

