/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.ReflectionUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final String ACTIONS_BUNDLE_NAME = "Action";
    private static final String RESOURCES_BUNDLE_NAME = "Resource";
    private static final String RESOURCE_DIRECTORY_NAME = "resources";
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());
    private static final boolean loggingFine = logger.isLoggable(Level.FINE);
    private static final Class[] PARMTYPES_WRITE = new Class[]{DataOutputStream.class};
    private static final Class[] PARMTYPES_READ = new Class[]{DataInputStream.class};

    public static String constructPackagePath(Class clazz) {
        return clazz.getPackage().getName();
    }

    public static String constructResourceDirectoryString(String string) {
        return "./resources/" + string.replace('.', '/');
    }

    public static File getOrCreateResourceDirectory(Class clazz) {
        File file = new File("./resources/" + clazz.getPackage().getName().replace('.', '/'));
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static ResourceBundle getBundle(String string, String string2) {
        try {
            if (loggingFine) {
                logger.fine("Attempting to get bundle " + string2 + " in " + string);
            }
            return ResourceBundle.getBundle(string + "." + string2, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to find resource bundle " + string2 + " in " + string, exception);
            return null;
        }
    }

    public static ResourceBundle getBundleForObject(Object object, String string) {
        return FileUtils.getBundleForClass(object.getClass(), string);
    }

    public static ResourceBundle getBundleForClass(Class clazz, String string) {
        return FileUtils.getBundle(clazz.getPackage().getName(), string);
    }

    public static ResourceBundle getActionBundleForObject(Object object) {
        return FileUtils.getBundleForObject(object, ACTIONS_BUNDLE_NAME);
    }

    public static ResourceBundle getActionBundleForClass(Class clazz) {
        return FileUtils.getBundleForClass(clazz, ACTIONS_BUNDLE_NAME);
    }

    public static ResourceBundle getResourceBundleForObject(Object object) {
        return FileUtils.getBundleForObject(object, RESOURCES_BUNDLE_NAME);
    }

    public static ResourceBundle getResourceBundleForClass(Class clazz) {
        return FileUtils.getBundleForClass(clazz, RESOURCES_BUNDLE_NAME);
    }

    public static Collection listResourceProperties(String string) {
        File file = new File(string);
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".properties");
            }
        });
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = BasicStrings.getSubstring(stringArray[i], null, ".properties");
                string2 = FileUtils.stripLocaleInfo(string2);
                treeMap.put(string2, string2);
            }
        }
        return treeMap.values();
    }

    public static String stripLocaleInfo(String string) {
        string = FileUtils.stripTrailingLocalInfo(string);
        string = FileUtils.stripTrailingLocalInfo(string);
        return string;
    }

    private static String stripTrailingLocalInfo(String string) {
        String string2;
        if (string.length() > 3 && (string2 = string.substring(string.length() - 3)).charAt(0) == '_' && Character.isLetter(string2.charAt(1)) && Character.isLetter(string2.charAt(2))) {
            string = string.substring(0, string.length() - 3);
        }
        return string;
    }

    public static void writeNullableString(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(string);
        }
    }

    public static String readNullableString(DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (!bl) {
            return null;
        }
        return dataInputStream.readUTF();
    }

    public static void writeList(Collection collection, DataOutputStream dataOutputStream) throws IOException {
        if (collection == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            Iterator iterator = new ArrayList(collection).iterator();
            while (iterator.hasNext()) {
                dataOutputStream.writeBoolean(true);
                FileUtils.writeObject(iterator.next(), dataOutputStream);
            }
            dataOutputStream.writeBoolean(false);
        }
    }

    public static Collection readList(DataInputStream dataInputStream, Collection arrayList, Class clazz) throws IOException {
        boolean bl;
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        if (!(bl = dataInputStream.readBoolean())) {
            return null;
        }
        boolean bl2 = dataInputStream.readBoolean();
        while (bl2) {
            arrayList.add(FileUtils.readObject(dataInputStream, clazz));
            bl2 = dataInputStream.readBoolean();
        }
        return arrayList;
    }

    public static void writeObject(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            ReflectionUtils.invokeMethod(object, "write", PARMTYPES_WRITE, new Object[]{dataOutputStream});
        }
    }

    public static Object readObject(DataInputStream dataInputStream, Class clazz) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (!bl) {
            return null;
        }
        return ReflectionUtils.invokeMethod(clazz, "read", PARMTYPES_READ, new Object[]{dataInputStream});
    }

    public static void writeMarkerAndVersion(DataOutputStream dataOutputStream, long l, int n) throws IOException {
        dataOutputStream.writeLong(l);
        dataOutputStream.writeInt(n);
    }

    public static int readFileVersion(DataInputStream dataInputStream, String string, long l, int n) throws IOException {
        long l2 = dataInputStream.readLong();
        if (l2 != l) {
            throw new IOException("Missing appropriate header information while reading " + string);
        }
        int n2 = dataInputStream.readInt();
        if (n2 > n) {
            throw new IOException("Incompatible file version while reading " + string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileData(File file) throws IOException {
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            for (int i = 0; i < n; i += ((InputStream)fileInputStream).read(byArray, i, n - i)) {
            }
        }
        return byArray;
    }

    public static void writeFileData(File file, byte[] byArray) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ((OutputStream)fileOutputStream).write(byArray);
        }
    }
}

