/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import com.ecmtuning.ecmlink.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericListenerAdapter {
    private final ArrayList listeners = new ArrayList();
    private final Class resolveClass;
    private static final Logger logger = Logger.getLogger(GenericListenerAdapter.class.getName());

    public GenericListenerAdapter(Class clazz) {
        this.resolveClass = clazz;
    }

    public synchronized void addListener(Object object) {
        if (object != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != object) continue;
                return;
            }
            if (!this.resolveClass.isInstance(object)) {
                throw new RuntimeException("Incompatible listener type, " + object.getClass().toString() + " !instanceof " + this.resolveClass.toString());
            }
            this.listeners.add(object);
        }
    }

    public synchronized void removeListener(Object object) {
        if (object != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e != object) continue;
                iterator.remove();
            }
        }
    }

    public Collection getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public void fire(String string) {
        this.fireMethod(string, ReflectionUtils.parmTypesVoid, null);
    }

    public void fire(String string, int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        this.fireMethod(string, ReflectionUtils.parmTypesInt, objectArray);
    }

    public void fire(String string, int n, int n2) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        this.fireMethod(string, ReflectionUtils.parmTypesIntInt, objectArray);
    }

    public void fire(String string, Object object, int n, int n2) {
        Object[] objectArray = new Object[]{object, new Integer(n), new Integer(n2)};
        this.fireMethod(string, ReflectionUtils.parmTypesObjIntInt, objectArray);
    }

    public void fire(String string, boolean bl) {
        Object[] objectArray = new Object[]{new Boolean(bl)};
        this.fireMethod(string, ReflectionUtils.parmTypesBoolean, objectArray);
    }

    public void fire(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        this.fireMethod(string, ReflectionUtils.parmTypesString, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMethod(String string, Class[] classArray, Object[] objectArray) {
        Iterator iterator;
        Method method = this.getMethod(string, classArray);
        GenericListenerAdapter genericListenerAdapter = this;
        synchronized (genericListenerAdapter) {
            iterator = new ArrayList(this.listeners).iterator();
        }
        while (iterator.hasNext()) {
            ReflectionUtils.invokeMethod(iterator.next(), method, objectArray);
        }
    }

    public final Method getMethod(String string, Class[] classArray) {
        try {
            return this.resolveClass.getMethod(string, classArray);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(GenericListenerAdapter.logException(securityException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(GenericListenerAdapter.logException(noSuchMethodException));
        }
    }

    static final Throwable logException(Exception exception) {
        Throwable throwable = exception.getCause() == null ? exception : exception.getCause();
        logger.log(Level.WARNING, "Internal exception", throwable);
        throwable.printStackTrace();
        return throwable;
    }
}

