/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectionUtils {
    public static final Class[] parmTypesVoid = null;
    public static final Class[] parmTypesInt = new Class[]{Integer.TYPE};
    public static final Class[] parmTypesIntInt = new Class[]{Integer.TYPE, Integer.TYPE};
    public static final Class[] parmTypesObjIntInt = new Class[]{Object.class, Integer.TYPE, Integer.TYPE};
    public static final Class[] parmTypesBoolean = new Class[]{Boolean.TYPE};
    public static final Class[] parmTypesString = new Class[]{String.class};
    static Logger logger = Logger.getLogger(ReflectionUtils.class.getName());

    public static final boolean hasMethod(Object object, String string, Class[] classArray) {
        try {
            Class clazz = ReflectionUtils.resolveClass(object);
            clazz.getMethod(string, classArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final Object invokeMethodIfThere(Object object, String string) {
        try {
            Method method;
            Class clazz = ReflectionUtils.resolveClass(object);
            if (object instanceof String || object instanceof Class) {
                object = null;
            }
            if ((method = clazz.getMethod(string, null)) != null) {
                return method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            ReflectionUtils.logException(exception);
        }
        return null;
    }

    public static final Object invokeMethod(Object object, String string) {
        return ReflectionUtils.invokeMethod(object, string, null, null);
    }

    public static final Object invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            Class clazz = ReflectionUtils.resolveClass(object);
            if (object instanceof String || object instanceof Class) {
                object = null;
            }
            Method method = clazz.getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(ReflectionUtils.logException(classNotFoundException));
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(ReflectionUtils.logException(securityException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(ReflectionUtils.logException(illegalArgumentException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(ReflectionUtils.logException(noSuchMethodException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(ReflectionUtils.logException(illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(ReflectionUtils.logException(invocationTargetException));
        }
    }

    public static final Object invokeMethod(Object object, Method method, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(ReflectionUtils.logException(illegalArgumentException));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(ReflectionUtils.logException(illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(ReflectionUtils.logException(invocationTargetException));
        }
    }

    public static final Throwable logException(Exception exception) {
        Throwable throwable = exception.getCause() == null ? exception : exception.getCause();
        logger.log(Level.WARNING, "Internal exception", throwable);
        return throwable;
    }

    public static Class resolveClass(Object object) throws ClassNotFoundException {
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String) {
            return Thread.currentThread().getContextClassLoader().loadClass((String)object);
        }
        return object.getClass();
    }
}

