/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import com.ecmtuning.ecmlink.util.ResourceLocation;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ResourceLocator {
    private final String resourceSuffix;
    private String[] packageNames;
    private ClassLoader classLoader;
    private String packageName;
    private List classLocations = new LinkedList();

    public ResourceLocator(String[] stringArray, String string) throws ClassNotFoundException {
        this(Thread.currentThread().getContextClassLoader(), stringArray, string);
    }

    public ResourceLocator(ClassLoader classLoader, String[] stringArray, String string) throws ClassNotFoundException {
        this.classLoader = classLoader;
        this.packageNames = stringArray;
        this.resourceSuffix = string;
        if (classLoader == null) {
            throw new ClassNotFoundException("Can't get class loader.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllResourceLocations() throws ClassNotFoundException, IOException {
        ResourceLocator resourceLocator = this;
        synchronized (resourceLocator) {
            this.classLocations.clear();
            for (int i = 0; i < this.packageNames.length; ++i) {
                String string;
                this.packageName = string = this.packageNames[i];
                String string2 = string.replace('.', '/');
                Enumeration<URL> enumeration = this.classLoader.getResources(string2);
                if (enumeration == null || !enumeration.hasMoreElements()) {
                    throw new ClassNotFoundException("No resource for " + string2);
                }
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (uRL.getProtocol().equalsIgnoreCase("FILE")) {
                        this.loadDirectory(uRL);
                        continue;
                    }
                    if (uRL.getProtocol().equalsIgnoreCase("JAR")) {
                        this.loadJar(uRL);
                        continue;
                    }
                    throw new ClassNotFoundException("Unknown protocol on class resource: " + uRL.toExternalForm());
                }
            }
            return this.classLocations;
        }
    }

    private void loadJar(URL uRL) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        String string = this.packageName.replace('.', '/');
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().startsWith(string) && !jarEntry.getName().startsWith("WEB-INF/classes/" + string) || !jarEntry.getName().endsWith(this.resourceSuffix)) continue;
            URL uRL2 = new URL("jar:" + new URL("file", null, jarFile.getName()).toExternalForm() + "!/" + jarEntry.getName());
            String string2 = jarEntry.getName();
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            string2 = string2.replace('/', '.');
            string2 = string2.substring(0, string2.length() - this.resourceSuffix.length());
            ResourceLocation resourceLocation = new ResourceLocation(this.classLoader, string2, uRL2);
            this.addResourceLocation(resourceLocation);
        }
    }

    private void loadDirectory(URL uRL) throws IOException {
        this.loadDirectory(this.packageName, uRL.getFile());
    }

    private void loadDirectory(String string, String string2) throws IOException {
        File file = new File(URLDecoder.decode(string2, System.getProperty("file.encoding", "UTF-8")));
        if (!file.isDirectory()) {
            throw new IOException("Invalid directory " + file.getAbsolutePath());
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.loadDirectory(string + '.' + file2.getName(), file2.getAbsolutePath());
                continue;
            }
            if (!file2.getName().endsWith(this.resourceSuffix)) continue;
            String string3 = file2.getName();
            string3 = string3.substring(0, string3.length() - this.resourceSuffix.length());
            String string4 = string + "." + string3;
            ResourceLocation resourceLocation = new ResourceLocation(this.classLoader, string4, new URL("file", null, file2.getAbsolutePath()));
            this.addResourceLocation(resourceLocation);
        }
    }

    private void addResourceLocation(ResourceLocation resourceLocation) throws IOException {
        if (this.classLocations.contains(resourceLocation)) {
            throw new IOException("Duplicate location found for: " + resourceLocation.getResourceName());
        }
        this.classLocations.add(resourceLocation);
    }
}

