/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SingleLineFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "HH:mm:ss.SSS";
    private final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private Object[] args = new Object[1];
    private String lineSeparator = System.getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        this.dat.setTime(logRecord.getMillis());
        this.args[0] = this.dat;
        stringBuffer.append(this.formatter.format(this.dat));
        stringBuffer.append(" ");
        stringBuffer.append(this.formatMessage(logRecord));
        stringBuffer.append(" (");
        String string = logRecord.getSourceClassName() != null ? logRecord.getSourceClassName() : logRecord.getLoggerName();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            n = i;
        }
        stringBuffer.append(string.substring(n + 1));
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append(".");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        stringBuffer.append(") (");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append(")");
        stringBuffer.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }
}

