/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import java.util.HashMap;
import java.util.Vector;

public class ThreadMonitor
extends Thread {
    static final long DEFAULT_SLEEP_MILLIS = 30000L;
    Vector monitoredEntries = new Vector();
    HashMap threadsMap = new HashMap();

    public ThreadMonitor() {
        this.setName("ThreadMonitor");
        this.setDaemon(true);
        this.start();
    }

    public synchronized void register(long l) {
        int n;
        Thread thread = Thread.currentThread();
        MonitoredEntry monitoredEntry = new MonitoredEntry();
        monitoredEntry.wakeTimeMillis = System.currentTimeMillis() + l;
        monitoredEntry.thread = thread;
        this.threadsMap.put(thread, monitoredEntry);
        int n2 = this.monitoredEntries.size();
        for (n = 0; n < n2; ++n) {
            MonitoredEntry monitoredEntry2 = (MonitoredEntry)this.monitoredEntries.elementAt(n);
            if (monitoredEntry2.wakeTimeMillis >= monitoredEntry.wakeTimeMillis) break;
        }
        if (n == n2) {
            this.monitoredEntries.addElement(monitoredEntry);
        } else {
            this.monitoredEntries.insertElementAt(monitoredEntry, n);
        }
        this.notifyAll();
    }

    public synchronized void deregister() {
        Thread thread = Thread.currentThread();
        MonitoredEntry monitoredEntry = (MonitoredEntry)this.threadsMap.remove(thread);
        if (monitoredEntry != null) {
            this.monitoredEntries.removeElement(monitoredEntry);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void run() {
        while (true) {
            MonitoredEntry monitoredEntry;
            long l = 30000L;
            if (this.monitoredEntries.size() > 0 && (monitoredEntry = (MonitoredEntry)this.monitoredEntries.elementAt(0)) != null && (l = monitoredEntry.wakeTimeMillis - System.currentTimeMillis()) < 10L) {
                if (monitoredEntry.thread != null) {
                    if (monitoredEntry.thread.isAlive()) {
                        monitoredEntry.thread.interrupt();
                    }
                    this.threadsMap.remove(monitoredEntry.thread);
                }
                this.monitoredEntries.removeElementAt(0);
                continue;
            }
            try {
                this.wait(l);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    class MonitoredEntry {
        long wakeTimeMillis;
        Thread thread;

        MonitoredEntry() {
        }
    }
}

