/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util;

import java.text.DecimalFormat;
import java.text.ParseException;

public class XFormatter {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static DecimalFormat[] formatters = new DecimalFormat[7];
    public static final int MAXPREC = 6;

    public static String truncateWithEllipses(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        string = string.substring(0, n) + '\u2026';
        return string;
    }

    public static String clipAndPrefixWithEllipses(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        string = '\u2026' + string.substring(string.length() - n);
        return string;
    }

    public static String format(float f, int n) {
        return formatters[n].format(f);
    }

    public static String format(double d, int n) {
        return formatters[n].format(d);
    }

    public static float parse(String string) throws NumberFormatException {
        try {
            return formatters[6].parse(string).floatValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getLocalizedMessage());
        }
    }

    public static String toHex2(byte by) {
        return XFormatter.toHex2(by & 0xFF);
    }

    public static String toHex2(int n) {
        return new StringBuffer().append(hexDigits[(n & 0xF0) >> 4]).append(hexDigits[n & 0xF]).toString();
    }

    public static String toHex4(byte by) {
        return XFormatter.toHex4(by & 0xFF);
    }

    public static String toHex4(int n) {
        return XFormatter.toHex2((n & 0xFF00) >> 8) + XFormatter.toHex2(n & 0xFF);
    }

    public static String toHex6(byte by) {
        return XFormatter.toHex6(by & 0xFF);
    }

    public static String toHex6(int n) {
        return XFormatter.toHex2((n & 0xFF0000) >> 16) + XFormatter.toHex2((n & 0xFF00) >> 8) + XFormatter.toHex2(n & 0xFF);
    }

    public static String toHex8(byte by) {
        return XFormatter.toHex8(by & 0xFF);
    }

    public static String toHex8(int n) {
        return XFormatter.toHex2((n & 0xFF000000) >> 24) + XFormatter.toHex2((n & 0xFF0000) >> 16) + XFormatter.toHex2((n & 0xFF00) >> 8) + XFormatter.toHex2(n & 0xFF);
    }

    public static int fromHex(String string) {
        return XFormatter.fromHex(string, false);
    }

    public static int fromHex(char c) {
        return XFormatter.fromHex(c, false);
    }

    public static int fromHex(String string, boolean bl) {
        if ((string = string.toUpperCase()).length() > 2 && string.charAt(1) == 'X') {
            string = string.substring(2);
        } else if (string.length() > 1 && string.charAt(0) == '#') {
            string = string.substring(1);
        }
        int n = 1;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            n2 += n * XFormatter.fromHex(string.charAt(n3 - n4 - 1), bl);
            ++n4;
            n *= 16;
        }
        return n2;
    }

    public static int fromHex(char c, boolean bl) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (bl) {
            throw new NumberFormatException("Invalid hex digit '" + c + "'");
        }
        return 0;
    }

    public static String pad(int n, int n2) {
        return XFormatter.doPad(n, n2, ' ');
    }

    public static String padZero(int n, int n2) {
        return XFormatter.doPad(n, n2, '0');
    }

    public static String doPad(int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        if (stringBuffer.length() < n2) {
            int n3 = n2 - stringBuffer.length();
            for (int i = 0; i < n3; ++i) {
                stringBuffer.insert(0, c);
            }
        }
        return stringBuffer.toString();
    }

    public static int[] toIntArray(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static byte[] toByteArray(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    static {
        String string = "0";
        for (int i = 0; i < 7; ++i) {
            if (i == 0) {
                XFormatter.formatters[i] = new DecimalFormat("#0");
            } else {
                XFormatter.formatters[i] = new DecimalFormat("#0." + string);
                string = string + '0';
            }
            formatters[i].setMinimumIntegerDigits(1);
        }
    }
}

