/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.model;

import com.ecmtuning.ecmlink.model.StrictArrayListModel;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.model.ObjectListFilter;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListModelPlug
extends ValueModelPlug {
    boolean reverseSubjectAccess = false;
    private static final Logger logger = Logger.getLogger(ListModelPlug.class.getName());
    ListDataListener localArrayDataListener;
    final ListDataListener subjectArrayDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            int n = ListModelPlug.this.subjectIndex(listDataEvent.getIndex0());
            int n2 = ListModelPlug.this.subjectIndex(listDataEvent.getIndex1());
            ListModelPlug.this.filterArrayValues(n, n2);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            throw new IllegalStateException("Illegal change to ArrayListModel in a ListModelPlug");
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            throw new IllegalStateException("Illegal change to ArrayListModel in a ListModelPlug");
        }
    };

    public ListModelPlug(ValueModel valueModel, ArrayList arrayList) {
        this(valueModel, arrayList, false);
    }

    public ListModelPlug(ValueModel valueModel, ArrayList arrayList, boolean bl) {
        super(valueModel, arrayList, bl);
        super.removeSubjectModelListener();
        if (!(valueModel.getValue() instanceof ArrayListModel)) {
            throw new IllegalStateException("ListModelPlug constructed on a model with non-ArrayListModel value");
        }
        ArrayListModel arrayListModel = (ArrayListModel)valueModel.getValue();
        arrayListModel.addListDataListener(this.subjectArrayDataListener);
    }

    @Override
    public synchronized void unplug() {
        ArrayListModel arrayListModel;
        ValueModel valueModel = this.subjectModel;
        if (valueModel != null && (arrayListModel = (ArrayListModel)valueModel.getValue()) != null && this.subjectArrayDataListener != null) {
            arrayListModel.removeListDataListener(this.subjectArrayDataListener);
        }
        super.unplug();
    }

    public boolean isReverseSubjectAccess() {
        return this.reverseSubjectAccess;
    }

    public synchronized void setReverseSubjectAccess(boolean bl) {
        this.reverseSubjectAccess = bl;
        this.resetLocalValue();
    }

    protected synchronized int subjectIndex(int n) {
        if (this.isReverseSubjectAccess()) {
            n = this.getLocalArrayListValue().getSize() - n - 1;
        }
        return n;
    }

    public synchronized void addObjectListFilter(ObjectListFilter objectListFilter) {
        this.filters.add(objectListFilter);
        this.resetLocalValue();
    }

    public synchronized void addObjectListFilter(int n, ObjectListFilter objectListFilter) {
        this.filters.add(n, objectListFilter);
        this.resetLocalValue();
    }

    public ArrayListModel getLocalArrayListValue() {
        return (ArrayListModel)this.getValue();
    }

    @Override
    public synchronized void setValue(Object object) {
        if (this.debug) {
            logger.info(this.debugPrefix + "New value: " + object.toString());
        }
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("setValue on ListModelPlug called with non-List element");
        }
        Collections.copy(this.getLocalArrayListValue(), (List)object);
    }

    @Override
    public synchronized void resetLocalValue() {
        ValueModel valueModel;
        if (this.debug) {
            logger.info(this.debugPrefix + "Reset local value");
        }
        if ((valueModel = this.subjectModel) != null) {
            ArrayListModel arrayListModel = (ArrayListModel)valueModel.getValue();
            ArrayListModel arrayListModel2 = (ArrayListModel)this.localValue;
            if (arrayListModel2 == null) {
                int n = arrayListModel.getSize();
                this.localArrayDataListener = new LocalArrayDataListener();
                arrayListModel2 = new StrictArrayListModel(n, new Object(), this.localArrayDataListener);
                this.localValue = arrayListModel2;
            }
            this.filterArrayValues(0, arrayListModel2.getSize() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void filterArrayValues(int n, int n2) {
        ValueModel valueModel = this.subjectModel;
        if (valueModel != null) {
            StrictArrayListModel strictArrayListModel = (StrictArrayListModel)((Object)this.getValue());
            ArrayList arrayList = (ArrayList)valueModel.getValue();
            strictArrayListModel.setPrimaryListener(null);
            try {
                for (int i = n; i <= n2; ++i) {
                    Object object = strictArrayListModel.get(i);
                    Object object2 = arrayList.get(this.subjectIndex(i));
                    if ((object2 = this.filterSingleValue(object2, i)).equals(object)) continue;
                    strictArrayListModel.set(i, object2);
                }
            }
            finally {
                strictArrayListModel.setPrimaryListener(this.localArrayDataListener);
            }
            strictArrayListModel._fireContentsChanged(n, n2);
            this.firePropertyChange(null, (Object)strictArrayListModel);
        }
    }

    protected final synchronized Object filterSingleValue(Object object, int n) {
        for (Object e : this.filters) {
            if (e instanceof ObjectListFilter) {
                object = ((ObjectListFilter)e).filter(object, n);
                continue;
            }
            object = ((ObjectFilter)e).filter(object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unfilterArrayValues(int n, int n2) {
        ValueModel valueModel = this.subjectModel;
        if (valueModel != null) {
            ArrayList arrayList = (ArrayList)this.getValue();
            ArrayListModel arrayListModel = (ArrayListModel)valueModel.getValue();
            try {
                arrayListModel.removeListDataListener(this.subjectArrayDataListener);
                for (int i = n; i <= n2; ++i) {
                    try {
                        Object object = arrayListModel.get(this.subjectIndex(i));
                        Object object2 = this.unfilterSingleValue(arrayList, i, object);
                        arrayListModel.set(this.subjectIndex(i), object2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                arrayListModel.addListDataListener(this.subjectArrayDataListener);
            }
            this.filterArrayValues(n, n2);
        }
    }

    protected synchronized Object unfilterSingleValue(ArrayList arrayList, int n, Object object) throws Exception {
        Object object2 = arrayList.get(n);
        if (this.filters != null) {
            for (int i = this.filters.size() - 1; i >= 0; --i) {
                Object e = this.filters.get(i);
                object2 = e instanceof ObjectListFilter ? ((ObjectListFilter)e).unfilter(object2, n, object) : ((ObjectFilter)e).unfilter(object2, object);
            }
        }
        return object2;
    }

    class LocalArrayDataListener
    implements ListDataListener {
        LocalArrayDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            ListModelPlug.this.unfilterArrayValues(n, n2);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            throw new IllegalStateException("Illegal change to ArrayListModel in a ListModelPlug");
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            throw new IllegalStateException("Illegal change to ArrayListModel in a ListModelPlug");
        }
    }
}

