/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.model;

import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.model.ObjectFilterHelper;

public class Number2StringFilter
implements ObjectFilter {
    boolean base16;
    int prec;

    public Number2StringFilter(int n) {
        this.base16 = false;
        this.prec = n;
    }

    public Number2StringFilter(boolean bl) {
        this.base16 = bl;
        this.prec = 0;
    }

    public int getPrec() {
        return this.prec;
    }

    public void setPrec(int n) {
        this.prec = n;
    }

    public boolean isBase16() {
        return this.base16;
    }

    public void setBase16(boolean bl) {
        this.base16 = bl;
    }

    @Override
    public Object filter(Object object) {
        if (this.base16) {
            return XFormatter.toHex2(Math.round(((Number)object).floatValue()));
        }
        return XFormatter.format(((Number)object).floatValue(), this.getPrec());
    }

    @Override
    public Object unfilter(Object object, Object object2) throws Exception {
        if (this.base16) {
            int n = XFormatter.fromHex((String)object, true);
            return ObjectFilterHelper.createNumberFromInt(n, (Number)object2);
        }
        return ObjectFilterHelper.parseNumber((String)object, (Number)object2);
    }
}

