/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.model;

import com.ecmtuning.ecmlink.device.records.Float8Field;
import com.ecmtuning.ecmlink.util.model.ObjectFilter;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ValueModelPlug
implements ValueModel,
UnpluggableValueModel {
    protected ValueModel subjectModel;
    protected Object localValue;
    protected Object bypassSubjectValue;
    protected Object bypassLocalValue;
    protected Object bypassPrototypeValue;
    protected boolean bypassInstalled;
    protected ArrayList listeners;
    protected boolean useWeakRefs;
    protected ArrayList filters;
    protected boolean autoUnplug = true;
    protected int ignorePropertyChangeCnt = 0;
    protected boolean debug = false;
    protected String debugPrefix = null;
    private static final Logger logger = Logger.getLogger(ValueModelPlug.class.getName());
    private PropertyChangeListener localValueResetListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ValueModelPlug.this.debug) {
                logger.info(ValueModelPlug.this.debugPrefix + "propertyChange notify, ignoreCnt=" + ValueModelPlug.this.ignorePropertyChangeCnt);
            }
            if (ValueModelPlug.this.ignorePropertyChangeCnt == 0) {
                ValueModelPlug.this.resetLocalValue();
            }
        }
    };
    protected static ReferenceQueue refQ = new ReferenceQueue();
    private static ArrayList weakModelPlugs = new ArrayList();
    private static Thread refThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Reference reference = refQ.remove();
                        ArrayList arrayList = weakModelPlugs;
                        synchronized (arrayList) {
                            Iterator iterator = weakModelPlugs.iterator();
                            while (iterator.hasNext()) {
                                ValueModelPlug valueModelPlug;
                                ValueModelPlug valueModelPlug2 = valueModelPlug = (ValueModelPlug)iterator.next();
                                synchronized (valueModelPlug2) {
                                    if (valueModelPlug.listeners != null && valueModelPlug.listeners.remove(reference) && valueModelPlug.isAutoUnplug() && valueModelPlug.listeners.size() == 0) {
                                        valueModelPlug.unplug();
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    };

    public ValueModelPlug(ValueModel valueModel, ArrayList arrayList) {
        this(valueModel, arrayList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueModelPlug(ValueModel valueModel, ArrayList arrayList, boolean bl) {
        this.subjectModel = valueModel;
        this.subjectModel.addValueChangeListener(this.localValueResetListener);
        this.useWeakRefs = bl;
        if (this.useWeakRefs) {
            ArrayList arrayList2 = weakModelPlugs;
            synchronized (arrayList2) {
                weakModelPlugs.add(this);
            }
        }
        this.filters = arrayList == null ? new ArrayList() : new ArrayList(arrayList);
        this.resetLocalValue();
    }

    public ValueModel getSubject() {
        return this.subjectModel;
    }

    public synchronized void addObjectFilter(ObjectFilter objectFilter) {
        this.filters.add(objectFilter);
        this.resetLocalValue();
    }

    public synchronized void addObjectFilter(int n, ObjectFilter objectFilter) {
        this.filters.add(n, objectFilter);
        this.resetLocalValue();
    }

    public synchronized List getFilterList() {
        return (List)this.filters.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unplug() {
        if (this.debug) {
            logger.info(this.debugPrefix + "Unplugging from subject");
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.subjectModel != null) {
            this.removeSubjectModelListener();
            this.subjectModel = null;
        } else {
            logger.warning("unplug called with null subject!");
        }
        if (this.useWeakRefs) {
            ArrayList arrayList = weakModelPlugs;
            synchronized (arrayList) {
                weakModelPlugs.remove(this);
            }
        }
    }

    protected synchronized void removeSubjectModelListener() {
        if (this.subjectModel != null && this.localValueResetListener != null) {
            this.subjectModel.removeValueChangeListener(this.localValueResetListener);
        }
    }

    public boolean isAutoUnplug() {
        return this.autoUnplug;
    }

    public void setAutoUnplug(boolean bl) {
        this.autoUnplug = bl;
    }

    public synchronized Object nextStepValue() {
        return this.stepValue(true);
    }

    public synchronized Object previousStepValue() {
        return this.stepValue(false);
    }

    private Object stepValue(boolean bl) {
        Object object;
        ValueModel valueModel = this.subjectModel;
        Object object2 = object = this.getValue();
        if (valueModel != null && valueModel instanceof Float8Field) {
            Float8Field float8Field = (Float8Field)valueModel;
            Float f = (Float)float8Field.getValue();
            Float f2 = bl ? float8Field.nextStepValue(f) : float8Field.previousStepValue(f);
            object2 = this.filterSingleSubjectValue(f2);
            while (object2.equals(object) && !f.equals(f2)) {
                f = f2;
                f2 = bl ? float8Field.nextStepValue(f) : float8Field.previousStepValue(f);
                object2 = this.filterSingleSubjectValue(f2);
            }
        } else {
            logger.warning("stepValue called with null or non-Float8Field subject!");
        }
        return object2;
    }

    public synchronized Object nextStepValue(Number number) {
        ValueModel valueModel = this.subjectModel;
        if (valueModel != null) {
            Object object = valueModel.getValue();
            if (this.bypassInstalled && object == this.bypassSubjectValue) {
                object = this.bypassPrototypeValue;
            }
            if (object != null && object instanceof Number) {
                Number number2 = (Number)object;
                Object object2 = this.getValue();
                Number number3 = number2;
                if (number2 instanceof Integer) {
                    number3 = new Integer(number2.intValue() + number.intValue());
                } else if (number2 instanceof Float) {
                    number3 = new Float(number2.floatValue() + number.floatValue());
                } else if (number2 instanceof Double) {
                    number3 = new Double(number2.doubleValue() + number.doubleValue());
                } else {
                    logger.warning("nextStepValue(stepAmount) called with non Integer, Float or Double value!");
                }
                Object object3 = this.filterSingleSubjectValue(number3);
                if (object3.equals(object2)) {
                    return object2;
                }
                this.setValue(object3);
                return this.getValue();
            }
            logger.warning("nextStepValue(stepAmount) called with null subject value!");
        } else {
            logger.warning("nextStepValue(stepAmount) called with null subject!");
        }
        return this.getValue();
    }

    public void setFilterBypassValues(Object object, Object object2, Object object3) {
        this.bypassInstalled = true;
        this.bypassSubjectValue = object;
        this.bypassPrototypeValue = object3;
        this.bypassLocalValue = object2;
        this.resetLocalValue();
    }

    public void setDebug(int n) {
        this.debug = true;
        this.debugPrefix = "(" + Integer.toString(n) + ") ";
        logger.info(this.debugPrefix + "setDebug on new instance");
    }

    public Object getValue() {
        return this.localValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValue(Object object) {
        ValueModel valueModel;
        if (this.debug) {
            logger.info(this.debugPrefix + "New value: " + object);
        }
        if ((valueModel = this.subjectModel) != null) {
            try {
                Object object2 = valueModel.getValue();
                if (this.bypassInstalled && object2 == this.bypassSubjectValue) {
                    object2 = this.bypassPrototypeValue;
                }
                object = this.unfilterSingleLocalValue(object, object2);
                try {
                    ++this.ignorePropertyChangeCnt;
                    if (this.debug) {
                        logger.info(this.debugPrefix + "New subject value: " + object);
                    }
                    valueModel.setValue(object);
                    this.resetLocalValue();
                }
                finally {
                    --this.ignorePropertyChangeCnt;
                }
            }
            catch (Exception exception) {
                if (this.debug) {
                    logger.info(this.debugPrefix + "setValue exception: " + exception);
                }
                this.firePropertyChange(null, this.getValue());
            }
        } else {
            logger.warning("setValue called with null subject!");
        }
    }

    private final synchronized Object unfilterSingleLocalValue(Object object, Object object2) throws Exception {
        if (this.bypassInstalled && BindingUtils.equals((Object)object, (Object)this.bypassLocalValue)) {
            return this.bypassSubjectValue;
        }
        if (this.debug) {
            logger.info(this.debugPrefix + "Unfilter on " + object);
        }
        if (object != null && this.filters != null) {
            for (int i = this.filters.size() - 1; i >= 0; --i) {
                ObjectFilter objectFilter = (ObjectFilter)this.filters.get(i);
                object = objectFilter.unfilter(object, object2);
            }
        }
        if (this.debug) {
            logger.info(this.debugPrefix + "Unfilter produced " + object);
        }
        return object;
    }

    public synchronized void resetLocalValue() {
        ValueModel valueModel;
        if (this.debug) {
            logger.info(this.debugPrefix + "Reset local value");
        }
        if ((valueModel = this.subjectModel) != null) {
            Object object = valueModel.getValue();
            if (this.debug) {
                logger.info(this.debugPrefix + "Raw local subject value: " + object);
            }
            object = this.filterSingleSubjectValue(object);
            if (this.debug) {
                logger.info(this.debugPrefix + "Filtered value: " + object);
            }
            this.localValue = object;
            this.firePropertyChange(null, object);
        } else {
            logger.warning(this.debugPrefix + "resetLocalValue called with null subject!");
        }
    }

    private final synchronized Object filterSingleSubjectValue(Object object) {
        if (this.bypassInstalled && BindingUtils.equals((Object)object, (Object)this.bypassSubjectValue)) {
            return this.bypassLocalValue;
        }
        if (object != null && this.filters != null) {
            for (ObjectFilter objectFilter : this.filters) {
                object = objectFilter.filter(object);
            }
        }
        return object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addValueChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removeValueChangeListener(propertyChangeListener);
    }

    public synchronized void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.debug) {
            logger.info(this.debugPrefix + "Adding: " + propertyChangeListener.toString());
        }
        if (this.subjectModel == null) {
            logger.warning("addValueChangeListener called with null subject!");
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.useWeakRefs) {
            this.listeners.add(new WeakReference<PropertyChangeListener>(propertyChangeListener, refQ));
            if (this.debug) {
                logger.info(this.debugPrefix + "  Added weak listener");
            }
        } else {
            this.listeners.add(propertyChangeListener);
            if (this.debug) {
                logger.info(this.debugPrefix + "  Added strong listener");
            }
        }
    }

    public synchronized void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.debug) {
            logger.info(this.debugPrefix + "Removing: " + propertyChangeListener.toString());
        }
        if (propertyChangeListener != null && this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof Reference) {
                    object = ((Reference)object).get();
                }
                if (object != propertyChangeListener) continue;
                iterator.remove();
                if (!this.debug) continue;
                logger.info(this.debugPrefix + "  Found and removed listener");
            }
            if (this.useWeakRefs && this.listeners.size() == 0 && this.isAutoUnplug()) {
                if (this.debug) {
                    logger.info(this.debugPrefix + "Auto-unplug invoked");
                }
                this.unplug();
            }
        }
    }

    protected void firePropertyChange(Object object, Object object2) {
        if (this.debug) {
            logger.info(this.debugPrefix + "Fire change: " + object2);
        }
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "value", object, object2));
    }

    protected synchronized void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        ArrayList arrayList;
        if (this.debug) {
            logger.info(this.debugPrefix + "Fire change event: " + propertyChangeEvent);
        }
        ArrayList arrayList2 = arrayList = this.listeners == null ? null : new ArrayList(this.listeners);
        if (arrayList != null) {
            for (Object object : arrayList) {
                if (object instanceof Reference) {
                    object = ((Reference)object).get();
                }
                if (object == null) continue;
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object;
                if (this.debug) {
                    logger.info(this.debugPrefix + "Calling listener: " + propertyChangeListener);
                }
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public PropertyChangeListener getLocalValueResetListener() {
        return this.localValueResetListener;
    }

    public boolean hasEqualValues(ValueModelPlug valueModelPlug) {
        return this.localValue == null ? valueModelPlug.localValue == null : this.localValue.equals(valueModelPlug.localValue);
    }

    static {
        refThread.setName("ValueModelPlug refThread");
        refThread.setDaemon(true);
        refThread.start();
    }
}

