/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.model;

import com.ecmtuning.ecmlink.util.ReflectionUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class WeakListeners
implements PropertyChangeListener,
ListDataListener {
    private final WeakReference listenerRef;
    private final WeakReference beanRef;
    private final String propertyName;
    private final String type;
    private static final String TYPE_VALUE_CHANGE_LISTENER = "valueChange";
    private static final String TYPE_PROPERTY_CHANGE_LISTENER = "propertyChange";
    private static final String TYPE_LIST_DATA_LISTENER = "listDataChange";
    Object checkAndRemoveMutex = new Object();
    static final Class[] unboundPropertyParmTypes = new Class[]{PropertyChangeListener.class};
    static final Class[] boundPropertyParmTypes = new Class[]{String.class, PropertyChangeListener.class};
    static final Class[] listDataParmTypes = new Class[]{ListDataListener.class};
    private static ReferenceQueue refQ = new ReferenceQueue();
    private static ArrayList weakListeners = new ArrayList();
    private static Thread refThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block6: while (true) {
                        ArrayList arrayList;
                        Reference reference = refQ.remove();
                        Object object = weakListeners;
                        synchronized (object) {
                            arrayList = new ArrayList(weakListeners);
                        }
                        object = arrayList.iterator();
                        while (true) {
                            if (!object.hasNext()) continue block6;
                            WeakListeners weakListeners = (WeakListeners)object.next();
                            weakListeners.checkAndRemoveListener();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    };

    public static PropertyChangeListener addValueChangeListener(PropertyChangeListener propertyChangeListener, Object object) {
        WeakListeners weakListeners = new WeakListeners(propertyChangeListener, object, null, TYPE_VALUE_CHANGE_LISTENER);
        ReflectionUtils.invokeMethod(object, "addValueChangeListener", unboundPropertyParmTypes, new Object[]{weakListeners});
        return weakListeners;
    }

    public static PropertyChangeListener addPropertyChangeListener(PropertyChangeListener propertyChangeListener, Object object, String string) {
        WeakListeners weakListeners = new WeakListeners(propertyChangeListener, object, string, TYPE_PROPERTY_CHANGE_LISTENER);
        ReflectionUtils.invokeMethod(object, "addPropertyChangeListener", boundPropertyParmTypes, new Object[]{string, weakListeners});
        return weakListeners;
    }

    public static PropertyChangeListener addPropertyChangeListener(PropertyChangeListener propertyChangeListener, Object object) {
        WeakListeners weakListeners = new WeakListeners(propertyChangeListener, object, null, TYPE_PROPERTY_CHANGE_LISTENER);
        ReflectionUtils.invokeMethod(object, "addPropertyChangeListener", unboundPropertyParmTypes, new Object[]{weakListeners});
        return weakListeners;
    }

    public static ListDataListener addListDataListener(ListDataListener listDataListener, Object object) {
        WeakListeners weakListeners = new WeakListeners(listDataListener, object, null, TYPE_LIST_DATA_LISTENER);
        ReflectionUtils.invokeMethod(object, "addListDataListener", listDataParmTypes, new Object[]{weakListeners});
        return weakListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WeakListeners(EventListener eventListener, Object object, String string, String string2) {
        this.listenerRef = new WeakReference<EventListener>(eventListener, refQ);
        this.beanRef = new WeakReference<Object>(object);
        this.propertyName = string;
        this.type = string2;
        ArrayList arrayList = weakListeners;
        synchronized (arrayList) {
            weakListeners.add(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.getCheckedListener();
        if (propertyChangeListener != null) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        ListDataListener listDataListener = (ListDataListener)this.getCheckedListener();
        if (listDataListener != null) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        ListDataListener listDataListener = (ListDataListener)this.getCheckedListener();
        if (listDataListener != null) {
            listDataListener.intervalAdded(listDataEvent);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        ListDataListener listDataListener = (ListDataListener)this.getCheckedListener();
        if (listDataListener != null) {
            listDataListener.intervalRemoved(listDataEvent);
        }
    }

    private EventListener getCheckedListener() {
        EventListener eventListener = (EventListener)this.listenerRef.get();
        if (eventListener == null) {
            this.checkAndRemoveListener();
        }
        return eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRemoveListener() {
        Object object = this.checkAndRemoveMutex;
        synchronized (object) {
            Object t = this.beanRef.get();
            if (t != null && this.listenerRef.get() == null) {
                this.beanRef.clear();
                try {
                    if (this.type == TYPE_VALUE_CHANGE_LISTENER) {
                        this.removeValueChangeListener(t);
                    } else if (this.type == TYPE_PROPERTY_CHANGE_LISTENER) {
                        this.removePropertyChangeListener(t);
                    } else if (this.type == TYPE_LIST_DATA_LISTENER) {
                        this.removeListDataListener(t);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(WeakListeners.class.getName()).log(Level.WARNING, "removeListener exception", exception);
                }
                finally {
                    ArrayList arrayList = weakListeners;
                    synchronized (arrayList) {
                        weakListeners.remove(this);
                    }
                }
            }
        }
    }

    private void removeListDataListener(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getMethod("removeListDataListener", listDataParmTypes);
        method.invoke(object, this);
    }

    private void removePropertyChangeListener(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.propertyName == null) {
            Method method = object.getClass().getMethod("removePropertyChangeListener", unboundPropertyParmTypes);
            method.invoke(object, this);
        } else {
            Method method = object.getClass().getMethod("removePropertyChangeListener", boundPropertyParmTypes);
            method.invoke(object, this.propertyName, this);
        }
    }

    private void removeValueChangeListener(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getMethod("removeValueChangeListener", unboundPropertyParmTypes);
        method.invoke(object, this);
    }

    static {
        refThread.setName("WeakListeners refThread");
        refThread.setDaemon(true);
        refThread.start();
    }
}

