/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.util.ui.ActionWrapper;
import com.ecmtuning.ecmlink.util.ui.Float8SpinnerModel;
import com.ecmtuning.ecmlink.util.ui.NearestNumberComboBox;
import com.ecmtuning.ecmlink.util.ui.NumberSpinnerModel;
import com.ecmtuning.ecmlink.util.ui.SelectionFocusListener;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.uif.action.ActionManager;
import com.jgoodies.uif.component.ToolBarButton;
import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.Modes;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Logger;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.OverlayLayout;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DialogUtil {
    public static RowSpec DEFAULT_PREF_NOGROW_ROWSPEC = new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 0.0);
    public static RowSpec DEFAULT_PREF_GROW_ROWSPEC = new RowSpec(RowSpec.DEFAULT, (Size)Sizes.PREFERRED, 1.0);
    public static RowSpec TOP_PREF_NOGROW_ROWSPEC = new RowSpec(RowSpec.TOP, (Size)Sizes.PREFERRED, 0.0);
    public static RowSpec CENTER_PREF_NOGROW_ROWSPEC = new RowSpec(RowSpec.CENTER, (Size)Sizes.PREFERRED, 0.0);
    public static RowSpec BOTTOM_PREF_NOGROW_ROWSPEC = new RowSpec(RowSpec.BOTTOM, (Size)Sizes.PREFERRED, 0.0);
    public static RowSpec TOP_PREF_GROW_ROWSPEC = new RowSpec(RowSpec.TOP, (Size)Sizes.PREFERRED, 1.0);
    public static RowSpec FILL_PREF_GROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 1.0);
    public static RowSpec FILL_PREF_NOGROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 0.0);
    public static RowSpec FILL_MIN_GROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.MINIMUM, 1.0);
    public static RowSpec FILL_MIN_NOGROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.MINIMUM, 0.0);
    public static RowSpec FILL_ZERO_GROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.ZERO, 1.0);
    public static RowSpec FILL_DEFAULT_GROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
    public static RowSpec FILL_DEFAULT_NOGROW_ROWSPEC = new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0);
    public static RowSpec SEPARATOR_GAP_ROWSPEC = FormFactory.LINE_GAP_ROWSPEC;
    public static RowSpec RELATED_GAP_ROWSPEC = FormFactory.NARROW_LINE_GAP_ROWSPEC;
    public static RowSpec UNRELATED_GAP_ROWSPEC = FormFactory.UNRELATED_GAP_ROWSPEC;
    public static RowSpec LABEL_COMPONENT_GAP_ROWSPEC = FormFactory.NARROW_LINE_GAP_ROWSPEC;
    public static RowSpec INTER_SECT_GAP_ROWSPEC = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    public static RowSpec GLUE_ROWSPEC = FormFactory.GLUE_ROWSPEC;
    public static ColumnSpec INDENT_COLSPEC = FormFactory.createGapColumnSpec((ConstantSize)LayoutStyle.getCurrent().getDialogMarginX());
    public static ColumnSpec LEFT_PREF_NOGROW_COLSPEC = new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.PREFERRED, 0.0);
    public static ColumnSpec LEFT_PREF_GROW_COLSPEC = new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.PREFERRED, 1.0);
    public static ColumnSpec CENTERED_PREF_NOGROW_COLSPEC = new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.PREFERRED, 0.0);
    public static ColumnSpec RIGHT_PREF_NOGROW_COLSPEC = new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.PREFERRED, 0.0);
    public static ColumnSpec RIGHT_PREF_GROW_COLSPEC = new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.PREFERRED, 1.0);
    public static ColumnSpec PREF_SHRINK_COLSPEC = FormFactory.DEFAULT_COLSPEC;
    public static ColumnSpec FILL_DEFAULT_GROW_COLSPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0);
    public static ColumnSpec FILL_MIN_GROW_COLSPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.MINIMUM, 1.0);
    public static ColumnSpec FILL_ZERO_GROW_COLSPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.ZERO, 1.0);
    public static ColumnSpec FILL_PREF_GROW_COLSPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0);
    public static ColumnSpec FILL_PREF_NOGROW_COLSPEC = new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 0.0);
    public static ColumnSpec LABEL_COMPONENT_GAP_COLSPEC = FormFactory.LABEL_COMPONENT_GAP_COLSPEC;
    public static ColumnSpec UNRELATED_COLUMN_GAP_COLSPEC = new ColumnSpec((Size)Sizes.dluX((int)40));
    public static ColumnSpec RELATED_COLUMN_GAP_COLSPEC = new ColumnSpec((Size)Sizes.dluX((int)20));
    public static ColumnSpec RELATED_GAP_COLSPEC = FormFactory.RELATED_GAP_COLSPEC;
    public static ColumnSpec UNRELATED_GAP_COLSPEC = FormFactory.UNRELATED_GAP_COLSPEC;
    public static ColumnSpec GLUE_COLSPEC = FormFactory.GLUE_COLSPEC;
    public static final KeyListener hungryKeyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }
    };
    public static final MouseListener hungryMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }
    };

    public static JComponent makeBold(JComponent jComponent) {
        jComponent.setFont(jComponent.getFont().deriveFont(1));
        return jComponent;
    }

    public static JComponent makeItalic(JComponent jComponent) {
        jComponent.setFont(jComponent.getFont().deriveFont(2));
        return jComponent;
    }

    public static JButton createDefaultHelpButton(String string) {
        MainModel mainModel = MainModel.getInstance();
        Action action = MainActions.getAction("openHelpContents");
        ToolBarButton toolBarButton = new ToolBarButton(action);
        toolBarButton.setBorderPaintedMode((Mode)Modes.NEVER);
        toolBarButton.setWideMarginMode((Mode)Modes.ALWAYS);
        HelpBroker helpBroker = mainModel.getHelpBroker();
        if (helpBroker != null) {
            helpBroker.enableHelpOnButton((Component)toolBarButton, string, null);
        }
        toolBarButton.addMouseListener((MouseListener)new AbstractButtonMouseBorderAdapter((AbstractButton)toolBarButton));
        return toolBarButton;
    }

    public static JComboBox createComboBox(List list, ValueModel valueModel, boolean bl, String string) {
        JComboBox jComboBox = new JComboBox(new ComboBoxAdapter(list, valueModel));
        jComboBox.setEditable(bl);
        DialogUtil.configureComboBoxRightAlign(jComboBox);
        if (string != null && string.trim().length() > 0) {
            jComboBox.setToolTipText(string);
        }
        return jComboBox;
    }

    private static void configureComboBoxRightAlign(JComboBox jComboBox) {
        Component component;
        if (jComboBox.getEditor() != null && jComboBox.getEditor().getEditorComponent() != null && (component = jComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)component).setHorizontalAlignment(4);
        }
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    ((JLabel)component).setHorizontalAlignment(4);
                }
                return component;
            }
        });
    }

    public static JComboBox createNearestNumberComboBox(List list, ValueModel valueModel, boolean bl, String string) {
        NearestNumberComboBox nearestNumberComboBox = new NearestNumberComboBox((ComboBoxModel)new ComboBoxAdapter(list, valueModel));
        nearestNumberComboBox.setEditable(bl);
        DialogUtil.configureComboBoxRightAlign(nearestNumberComboBox);
        if (string != null && string.trim().length() > 0) {
            nearestNumberComboBox.setToolTipText(string);
        }
        return nearestNumberComboBox;
    }

    public static int addTriplet(PanelBuilder panelBuilder, Object object, Component component, Object object2, CellConstraints cellConstraints) {
        int n = cellConstraints.gridX;
        int n2 = cellConstraints.gridY;
        if (object instanceof String) {
            panelBuilder.addLabel((String)object, cellConstraints.xy(n, n2));
        } else {
            panelBuilder.add((Component)object, cellConstraints.xy(n, n2));
        }
        panelBuilder.add(component, cellConstraints.xy(n + 2, n2));
        if (object2 instanceof String) {
            panelBuilder.addLabel((String)object2, cellConstraints.xy(n + 4, n2));
        } else {
            panelBuilder.add((Component)object2, cellConstraints.xy(n + 4, n2));
        }
        return n2 + 2;
    }

    public static JTextField createTextField(ValueModel valueModel, String string) {
        JTextField jTextField = BasicComponentFactory.createTextField((ValueModel)valueModel, (boolean)true);
        jTextField.setColumns(5);
        jTextField.setHorizontalAlignment(4);
        if (string != null && string.trim().length() > 0) {
            jTextField.setToolTipText(string);
        }
        SelectionFocusListener.ensureSelectOnFocus(jTextField);
        return jTextField;
    }

    public static JSpinner createSpinnerTextField(ValueModelPlug valueModelPlug, String string) {
        JSpinner jSpinner = new JSpinner(new Float8SpinnerModel(valueModelPlug));
        return DialogUtil.configureSpinner(jSpinner, string);
    }

    public static JSpinner createSpinngerTextField(SpinnerModel spinnerModel, String string) {
        JSpinner jSpinner = new JSpinner(spinnerModel);
        return DialogUtil.configureSpinner(jSpinner, string);
    }

    public static JSpinner createSpinnerTextField(ValueModelPlug valueModelPlug, String string, double d) {
        JSpinner jSpinner = new JSpinner(new NumberSpinnerModel(valueModelPlug, d));
        return DialogUtil.configureSpinner(jSpinner, string);
    }

    public static JSpinner createSpinnerTextField(ValueModelPlug valueModelPlug, String string, ValueModel valueModel) {
        JSpinner jSpinner = new JSpinner(new NumberSpinnerModel(valueModelPlug, valueModel));
        return DialogUtil.configureSpinner(jSpinner, string);
    }

    private static JSpinner configureSpinner(JSpinner jSpinner, String string) {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)jSpinner.getEditor().getComponent(0);
        jFormattedTextField.setHorizontalAlignment(4);
        jFormattedTextField.setColumns(5);
        jFormattedTextField.setEditable(true);
        SelectionFocusListener.ensureSelectOnFocus(jFormattedTextField);
        if (string != null && string.trim().length() > 0) {
            JComponent jComponent = jSpinner.getEditor();
            if (jComponent instanceof JSpinner.DateEditor) {
                ((JSpinner.DateEditor)jComponent).getTextField().setToolTipText(string);
            } else if (jComponent instanceof JSpinner.DefaultEditor) {
                ((JSpinner.DefaultEditor)jComponent).getTextField().setToolTipText(string);
            } else if (jComponent instanceof JSpinner.ListEditor) {
                ((JSpinner.ListEditor)jComponent).getTextField().setToolTipText(string);
            } else if (jComponent instanceof JSpinner.NumberEditor) {
                ((JSpinner.NumberEditor)jComponent).getTextField().setToolTipText(string);
            } else {
                jSpinner.setToolTipText(string);
            }
        }
        return jSpinner;
    }

    public static void disableAllInput(Component component) {
        component.setVisible(true);
        component.addKeyListener(hungryKeyListener);
        component.addMouseListener(hungryMouseListener);
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void reenableAllInput(Component component) {
        component.setCursor(null);
        component.removeKeyListener(hungryKeyListener);
        component.removeMouseListener(hungryMouseListener);
        component.setVisible(false);
    }

    public static void installComponentEnabler(ValueModel valueModel, Component[] componentArray) {
        new ModelComponentEnabler(valueModel, componentArray, false);
    }

    public static void installComponentDisabler(ValueModel valueModel, Component[] componentArray) {
        new ModelComponentEnabler(valueModel, componentArray, true);
    }

    public static void addRepaintFocusListener(Component component) {
        component.addFocusListener(new RepaintFocusListener(component));
    }

    public static void registerListSelectionEnabler(ListSelectionModel listSelectionModel, Action action) {
        listSelectionModel.addListSelectionListener(new ListSelectionEnabler(listSelectionModel, action));
    }

    public static AbstractAction createListMoverAction(JList jList, JList jList2) {
        return new JListItemMoveAction(jList, jList2);
    }

    public static void registerDoubleClickHandler(Component component, Action action) {
        component.addMouseListener(new DoubleClickActionHandler(action));
    }

    public static Action createForwardAction(Action action) {
        return new ForwardAction(action);
    }

    public static Action createForwardAction(String string) {
        Action action = ActionManager.get((String)string);
        return new ForwardAction(action);
    }

    public static void safeDispatchThreadCall(Object object, String string) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod(string, null);
            if (SwingUtilities.isEventDispatchThread()) {
                method.invoke(object, (Object[])null);
            } else {
                SwingUtilities.invokeAndWait(new DispatchThreadRunner(object, method));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static JLayeredPane createLayeredPane(JComponent jComponent, JComponent jComponent2) {
        JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setLayout(new OverlayLayout(jLayeredPane));
        jComponent.setAlignmentX(0.5f);
        jComponent.setAlignmentY(0.5f);
        jComponent2.setAlignmentX(0.5f);
        jComponent2.setAlignmentY(0.5f);
        jLayeredPane.add((Component)jComponent, new Integer(1));
        jLayeredPane.add((Component)jComponent2, new Integer(0));
        return jLayeredPane;
    }

    public static File invokeSaveAsChooser(JFileChooser jFileChooser, Component component, String string) {
        int n;
        try {
            n = jFileChooser.showSaveDialog(DialogUtil.locateFrame(component));
        }
        catch (Exception exception) {
            Logger.getLogger(DialogUtil.class.getClass().getName()).info("Failed once to display FileChooser: " + exception.getLocalizedMessage());
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = jFileChooser.showSaveDialog(DialogUtil.locateFrame(component));
        }
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = file.getName();
            if (!string2.endsWith("." + string)) {
                string2 = string2 + "." + string;
                file = new File(file.getParentFile(), string2);
            }
            return file;
        }
        return null;
    }

    public static Frame locateFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component.getParent());
    }

    public static JComponent createToolbarSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator(null);
        separator.setOrientation(1);
        return separator;
    }

    public static JButton createListButton(String string, boolean bl) {
        return DialogUtil.createListButton(ActionManager.get((String)string), null, bl);
    }

    public static JButton createListButton(String string, String string2) {
        return DialogUtil.createListButton(ActionManager.get((String)string), string2, false);
    }

    public static JButton createListButton(Action action, String string, boolean bl) {
        JButton jButton = new JButton(action);
        jButton.setHorizontalAlignment(10);
        jButton.setHorizontalTextPosition(10);
        ActionWrapper actionWrapper = ActionWrapper.createNoMnemonicAction(action);
        jButton.setAction(actionWrapper);
        if (!bl || LookUtils.IS_OS_MAC) {
            actionWrapper.ignoreValue("SmallIcon");
        }
        if (string != null) {
            actionWrapper.overrideValue("Name", string);
        }
        return jButton;
    }

    private static class DispatchThreadRunner
    implements Runnable {
        final Object obj;
        final Method method;

        public DispatchThreadRunner(Object object, Method method) {
            this.obj = object;
            this.method = method;
        }

        @Override
        public void run() {
            try {
                this.method.invoke(this.obj, (Object[])null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
    }

    public static class ForwardAction
    extends AbstractAction {
        Action actionToCall;

        public ForwardAction(Action action) {
            this.actionToCall = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.actionToCall.actionPerformed(actionEvent);
        }
    }

    public static class JListItemMoveAction
    extends AbstractAction {
        JList srcList;
        JList destList;

        public JListItemMoveAction(JList jList, JList jList2) {
            this.srcList = jList;
            this.destList = jList2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.srcList.getSelectedIndex();
            ListModel listModel = this.srcList.getModel();
            ListModel listModel2 = this.destList.getModel();
            try {
                Method method = listModel.getClass().getMethod("remove", Integer.TYPE);
                Method method2 = listModel2.getClass().getMethod("addElement", Object.class);
                Object object = method.invoke(listModel, new Integer(n));
                if (object != null) {
                    method2.invoke(listModel2, object);
                    this.destList.setSelectedValue(object, true);
                    this.srcList.setSelectedIndex(-1);
                }
            }
            catch (Exception exception) {
                Logger logger = Logger.getLogger(DialogUtil.class.getName());
                logger.info("Failed to move JList item: " + exception.toString());
            }
        }
    }

    public static class AbstractButtonMouseBorderAdapter
    extends MouseAdapter {
        AbstractButton button;

        AbstractButtonMouseBorderAdapter(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.button.setBorderPainted(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.button.setBorderPainted(false);
        }
    }

    public static class DoubleClickActionHandler
    extends MouseAdapter {
        final Action action;

        public DoubleClickActionHandler(Action action) {
            this.action = action;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 0 && mouseEvent.getClickCount() % 2 == 0) {
                this.action.actionPerformed(null);
            }
        }
    }

    public static class ListSelectionEnabler
    implements ListSelectionListener {
        final Action action;
        final ListSelectionModel model;

        ListSelectionEnabler(Action action) {
            this(null, action);
        }

        ListSelectionEnabler(ListSelectionModel listSelectionModel, Action action) {
            this.model = listSelectionModel;
            this.action = action;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.model != null) {
                this.action.setEnabled(!this.model.isSelectionEmpty());
            }
            if (listSelectionEvent.getSource() instanceof JList) {
                this.action.setEnabled(!((JList)listSelectionEvent.getSource()).isSelectionEmpty());
            }
        }
    }

    public static class RepaintFocusListener
    implements FocusListener {
        final Component component;

        public RepaintFocusListener(Component component) {
            this.component = component;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.component.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.component.repaint();
        }
    }

    public static class ModelComponentEnabler
    implements PropertyChangeListener {
        boolean invert;
        Component[] components;

        public ModelComponentEnabler(ValueModel valueModel, Component[] componentArray, boolean bl) {
            valueModel.addValueChangeListener((PropertyChangeListener)this);
            this.components = componentArray;
            this.invert = bl;
            boolean bl2 = (Boolean)valueModel.getValue();
            this.enableComponents(bl ^ bl2);
        }

        private void enableComponents(boolean bl) {
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].setEnabled(bl);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (bl != null) {
                boolean bl2 = bl;
                this.enableComponents(this.invert ^ bl2);
            }
        }
    }
}

