/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.util.ui.FocusAction;
import com.jgoodies.uifextras.util.ExtTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class HandyJTable
extends ExtTable {
    private boolean usePreferredSizeAsScrollSize;
    private TableCellRenderer defaultTableCellRenderer;
    private boolean validateWhileResizing;
    private Object[] prototypes;
    boolean assignRendererEnable = false;
    int validateCount = 0;
    Action copyAction = null;
    Action pasteAction = null;
    FocusAdapter focusAdapter = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component component;
            for (component = focusEvent.getOppositeComponent(); component != null && component != HandyJTable.this; component = component.getParent()) {
            }
            if (component != null) {
                return;
            }
            TableCellEditor tableCellEditor = HandyJTable.this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
        }
    };
    JScrollPane scrollPane;
    private ComponentListener scrollBarComponentListener = new ComponentListener(){

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            HandyJTable.this.revalidate();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            HandyJTable.this.revalidate();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            HandyJTable.this.revalidate();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            HandyJTable.this.revalidate();
        }
    };

    public void setDefaultTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.defaultTableCellRenderer = tableCellRenderer;
    }

    public void setUsePreferredSizeAsScrollSize(boolean bl) {
        this.usePreferredSizeAsScrollSize = bl;
    }

    public void setValidateWhileResizing(boolean bl) {
        this.validateWhileResizing = bl;
    }

    public boolean getAssignRendererEnable() {
        return this.assignRendererEnable;
    }

    public void setAssignRendererEnable(boolean bl) {
        this.assignRendererEnable = bl;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.defaultTableCellRenderer != null ? this.defaultTableCellRenderer : this.getDefaultRenderer(this.getColumnClass(n2));
        }
        if (this.assignRendererEnable && tableCellRenderer instanceof Component) {
            ((Component)((Object)tableCellRenderer)).setEnabled(this.isEnabled());
        }
        return tableCellRenderer;
    }

    public void setEnabled(boolean bl) {
        ListSelectionModel listSelectionModel;
        if (!bl && (listSelectionModel = this.getSelectionModel()) != null) {
            listSelectionModel.clearSelection();
        }
        super.setEnabled(bl);
    }

    public void packColumn(int n) {
        TableModel tableModel = this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        int n2 = 0;
        int n3 = tableColumnModel.getColumnMargin();
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), tableColumn.getHeaderValue(), false, false, 0, 0);
        n2 = component.getPreferredSize().width;
        for (int i = 0; i < this.getRowCount(); ++i) {
            tableCellRenderer = this.getCellRenderer(i, n);
            component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(i, n), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n2 += 2 * n3);
    }

    public void setColumnWidthFromProto(int n, Object object) {
        this.setColumnWidthFromProto(n, new Object[]{object});
    }

    public void setColumnWidthFromProto(int n, Object[] objectArray) {
        this.setColumnWidthFromProto(n, Arrays.asList(objectArray));
    }

    public void setColumnWidthFromProto(int n, List list) {
        Component component;
        Object object;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        int n2 = 0;
        int n3 = tableColumnModel.getColumnMargin();
        for (int i = 0; i < list.size(); ++i) {
            object = this.getCellRenderer(i, n);
            component = object.getTableCellRendererComponent((JTable)((Object)this), list.get(i), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            object = this.getTableHeader();
            tableCellRenderer = ((JTableHeader)object).getDefaultRenderer();
        }
        object = tableColumn.getHeaderValue();
        if (tableCellRenderer != null && object != null) {
            component = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), object, false, false, 0, 0);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n2 += 2 * n3);
    }

    public void padColumnWidths(int n) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n);
        }
    }

    public void setColumnPrototypes(Object[] objectArray) {
        this.prototypes = objectArray;
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.prototypes[this.convertColumnIndexToModel(i)];
            if (object instanceof Object[]) {
                this.setColumnWidthFromProto(i, (Object[])object);
                continue;
            }
            this.setColumnWidthFromProto(i, object);
        }
    }

    public TableColumn getColumn(Object object) {
        TableColumn tableColumn = null;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (tableColumn == null && enumeration.hasMoreElements()) {
            TableColumn tableColumn2 = enumeration.nextElement();
            if (!object.equals(tableColumn2.getIdentifier())) continue;
            tableColumn = tableColumn2;
        }
        return tableColumn;
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        if (this.prototypes != null) {
            int n = tableColumnModelEvent.getToIndex();
            Object object = this.prototypes[this.convertColumnIndexToModel(n)];
            if (object instanceof Object[]) {
                this.setColumnWidthFromProto(n, (Object[])object);
            } else {
                this.setColumnWidthFromProto(n, object);
            }
        }
        this.validateParents();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        super.columnMarginChanged(changeEvent);
        if (this.validateWhileResizing || this.getTableHeader().getResizingColumn() == null) {
            this.validateParents();
        }
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnRemoved(tableColumnModelEvent);
        this.validateParents();
    }

    private synchronized void validateParents() {
        if (this.validateCount != 0) {
            return;
        }
        try {
            this.validateCount = 1;
            for (Container container = this.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
                container.validate();
            }
        }
        finally {
            this.validateCount = 0;
        }
    }

    public synchronized Action getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = HandyJTable.this.getColumnCount();
                    int n2 = HandyJTable.this.getRowCount();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            stringBuffer.append(HandyJTable.this.getValueAt(i, j));
                            if (j >= n - 1) continue;
                            stringBuffer.append("\t");
                        }
                        stringBuffer.append("\n");
                    }
                    StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                }
            };
        }
        return this.copyAction;
    }

    public synchronized Action getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = HandyJTable.this.getColumnCount();
                    int n2 = HandyJTable.this.getRowCount();
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    String[][] stringArray = new String[n][n2];
                    String string = null;
                    try {
                        string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string == null) {
                        JOptionPane.showMessageDialog(SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)HandyJTable.this)), "Failed to find any valid text data in clipboard to parse", "Paste failed", 0);
                        return;
                    }
                    string = string.replaceAll("\r\n", "\n");
                    string = string.replaceAll("\n\r", "\n");
                    StringTokenizer stringTokenizer = new StringTokenizer(string = string.replaceAll("\r", "\n"), "\n");
                    if (stringTokenizer.countTokens() != n2) {
                        JOptionPane.showMessageDialog(SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)HandyJTable.this)), "Row count mismatch.  Expecting " + n + " cols and " + n2 + " rows", "Paste failed", 0);
                        return;
                    }
                    int n3 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
                        if (stringTokenizer2.countTokens() != n) {
                            JOptionPane.showMessageDialog(SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)HandyJTable.this)), "Column count mismatch.  Expecting " + n + " cols and " + n2 + " rows", "Paste failed", 0);
                            return;
                        }
                        int n4 = 0;
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string3;
                            stringArray[n4][n3] = string3 = stringTokenizer2.nextToken();
                            ++n4;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < n2; ++n3) {
                        for (int i = 0; i < n; ++i) {
                            HandyJTable.this.setValueAt(stringArray[i][n3], n3, i);
                        }
                    }
                    HandyJTable.this.clearSelection();
                }
            };
        }
        return this.pasteAction;
    }

    public HandyJTable() {
        this.ensureEditingStopWhenTableLosesFocus();
    }

    public HandyJTable(TableModel tableModel) {
        super(tableModel);
        this.ensureEditingStopWhenTableLosesFocus();
    }

    public HandyJTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.ensureEditingStopWhenTableLosesFocus();
    }

    public HandyJTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.ensureEditingStopWhenTableLosesFocus();
    }

    private void ensureEditingStopWhenTableLosesFocus() {
        this.addFocusListener(this.focusAdapter);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        component.removeFocusListener(this.focusAdapter);
        component.addFocusListener(this.focusAdapter);
        return component;
    }

    public void removeEditor() {
        Component component = this.getEditorComponent();
        if (component != null) {
            component.removeFocusListener(this.focusAdapter);
        }
        super.removeEditor();
    }

    protected void configureTable() {
        super.configureTable();
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void ensureRowIsVisible(int n) {
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    public void replaceTabNavigation() {
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "focusNextComponent");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "focusPreviousComponent");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("focusNextComponent", new FocusAction((Component)((Object)this), true));
        actionMap.put("focusPreviousComponent", new FocusAction((Component)((Object)this), false));
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this.scrollPane = jScrollPane;
        jScrollPane.getVerticalScrollBar().addComponentListener(this.scrollBarComponentListener);
        jScrollPane.getHorizontalScrollBar().addComponentListener(this.scrollBarComponentListener);
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.usePreferredSizeAsScrollSize) {
            Dimension dimension = super.getPreferredSize();
            if (this.scrollPane != null) {
                JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
                if (jScrollBar.isVisible() && this.scrollPane.getHorizontalScrollBarPolicy() == 31) {
                    dimension.width += jScrollBar.getWidth();
                }
                if ((jScrollBar = this.scrollPane.getHorizontalScrollBar()).isVisible() && this.scrollPane.getVerticalScrollBarPolicy() == 21) {
                    dimension.height += jScrollBar.getHeight();
                }
            }
            return dimension;
        }
        return super.getPreferredScrollableViewportSize();
    }
}

