/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.MathUtils;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class InterpListValuesAction
extends AbstractAction {
    private final JTable tbl;
    private final float[] yIndices;

    public InterpListValuesAction(JTable jTable, float[] fArray) {
        this.tbl = jTable;
        this.yIndices = fArray;
    }

    public InterpListValuesAction(JTable jTable) {
        this.tbl = jTable;
        this.yIndices = new float[jTable.getRowCount()];
        try {
            for (int i = 0; i < this.yIndices.length; ++i) {
                this.yIndices[i] = XFormatter.parse(jTable.getValueAt(i, 0).toString());
            }
        }
        catch (Exception exception) {
            for (int i = 0; i < this.yIndices.length; ++i) {
                this.yIndices[i] = i;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = MainModel.getDefaultParentFrame();
        try {
            this._actionPerformed(jFrame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jFrame, "An unexpected exception occured.", exception.toString(), 0);
            Logger.getLogger(InterpListValuesAction.class.getName()).log(Level.WARNING, "Exception raised when processing interpolate function", exception);
        }
    }

    private void _actionPerformed(Component component) {
        int n;
        int n2 = this.tbl.getRowCount();
        boolean[] blArray = new boolean[n2];
        boolean bl = false;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            blArray[i] = this.tbl.isCellSelected(i, 0);
            bl |= blArray[i];
            if (!blArray[i]) continue;
            n3 = Math.min(n3, i);
            n4 = Math.max(n4, i);
        }
        if (!bl) {
            JOptionPane.showMessageDialog(component, "This function performs end-to-end interpolation on a range of \nselected cells.  To use it, you need to select the cells first.\n", "No cells selected", 0);
            return;
        }
        float f = this.yIndices[n3];
        float f2 = this.yIndices[n4];
        float f3 = XFormatter.parse((String)this.tbl.getValueAt(n3, 1));
        float f4 = XFormatter.parse((String)this.tbl.getValueAt(n4, 1));
        float[] fArray = new float[n4 - n3 + 1];
        fArray[0] = f3;
        fArray[n4 - n3] = f4;
        for (n = n3 + 1; n < n4; ++n) {
            fArray[n - n3] = MathUtils.interpolate(f, fArray[0], f2, fArray[n4 - n3], this.yIndices[n]);
        }
        for (n = n3; n <= n4; ++n) {
            this.tbl.setValueAt(XFormatter.format(fArray[n - n3], 3), n, 1);
        }
        this.tbl.setRowSelectionInterval(n3, n4);
    }
}

