/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.MathUtils;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.HandyJTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class InterpTableValuesAction
extends AbstractAction {
    private final JTable tbl;
    private final float[] xIndices;
    private final float[] yIndices;
    private final boolean interpRows;
    private final boolean interpCols;

    public InterpTableValuesAction(HandyJTable handyJTable, float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        this.tbl = handyJTable;
        this.xIndices = fArray;
        this.yIndices = fArray2;
        this.interpRows = bl;
        this.interpCols = bl2;
    }

    public InterpTableValuesAction(HandyJTable handyJTable, HandyJTable handyJTable2, boolean bl, boolean bl2) {
        int n;
        int n2;
        this.tbl = handyJTable;
        this.xIndices = new float[handyJTable.getColumnCount()];
        this.interpRows = bl;
        this.interpCols = bl2;
        String string = "";
        try {
            for (n2 = 0; n2 < this.xIndices.length; ++n2) {
                string = handyJTable.getColumnName(n2).toString();
                this.xIndices[n2] = XFormatter.parse(string);
            }
        }
        catch (Exception exception) {
            for (n = 0; n < this.xIndices.length; ++n) {
                this.xIndices[n] = n;
            }
        }
        this.yIndices = new float[handyJTable.getRowCount()];
        string = "";
        try {
            for (n2 = 0; n2 < this.yIndices.length; ++n2) {
                this.yIndices[n2] = XFormatter.parse(handyJTable2.getValueAt(n2, 0).toString());
            }
        }
        catch (Exception exception) {
            for (n = 0; n < this.yIndices.length; ++n) {
                this.yIndices[n] = n;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = MainModel.getDefaultParentFrame();
        try {
            this._actionPerformed(jFrame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jFrame, "An unexpected exception occured.", exception.toString(), 0);
            Logger.getLogger(InterpTableValuesAction.class.getName()).log(Level.WARNING, "Exception raised when processing interpolate function", exception);
        }
    }

    private void _actionPerformed(Component component) {
        int n;
        int n2;
        int n3 = this.tbl.getColumnCount();
        int n4 = this.tbl.getRowCount();
        boolean[][] blArray = new boolean[n4][n3];
        boolean bl = false;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                blArray[j][i] = this.tbl.isCellSelected(j, i);
                bl |= blArray[j][i];
                if (!blArray[j][i]) continue;
                n5 = Math.min(n5, i);
                n6 = Math.max(n6, i);
                n7 = Math.min(n7, j);
                n8 = Math.max(n8, j);
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(component, "This function performs interpolation on a \nrange of selected cells.  To use it, you need to select the cells first.\n", "No cells selected", 0);
            return;
        }
        float f = this.xIndices[n5];
        float f2 = this.xIndices[n6];
        float f3 = this.yIndices[n7];
        float f4 = this.yIndices[n8];
        float f5 = XFormatter.parse((String)this.tbl.getValueAt(n7, n5));
        float f6 = XFormatter.parse((String)this.tbl.getValueAt(n7, n6));
        float f7 = XFormatter.parse((String)this.tbl.getValueAt(n8, n5));
        float f8 = XFormatter.parse((String)this.tbl.getValueAt(n8, n6));
        float[][] fArray = new float[n6 - n5 + 1][n8 - n7 + 1];
        for (n2 = n5; n2 <= n6; ++n2) {
            for (n = n7; n <= n8; ++n) {
                fArray[n2 - n5][n - n7] = XFormatter.parse((String)this.tbl.getValueAt(n, n2));
            }
        }
        if (this.interpRows) {
            if (this.interpCols) {
                if (f != f2) {
                    for (n2 = n5; n2 <= n6; ++n2) {
                        fArray[n2 - n5][0] = MathUtils.interpolate(f, f5, f2, f6, this.xIndices[n2]);
                        fArray[n2 - n5][n8 - n7] = MathUtils.interpolate(f, f7, f2, f8, this.xIndices[n2]);
                    }
                } else {
                    fArray[0][0] = f5;
                    fArray[0][n8 - n7] = f7;
                }
            } else {
                for (n2 = n7; n2 <= n8; ++n2) {
                    for (n = n5 + 1; n < n6; ++n) {
                        fArray[n - n5][n2 - n7] = MathUtils.interpolate(f, fArray[0][n2 - n7], f2, fArray[n6 - n5][n2 - n7], this.xIndices[n]);
                    }
                }
            }
        }
        if (this.interpCols) {
            for (n2 = n5; n2 <= n6; ++n2) {
                for (n = n7 + 1; n < n8; ++n) {
                    fArray[n2 - n5][n - n7] = MathUtils.interpolate(f3, fArray[n2 - n5][0], f4, fArray[n2 - n5][n8 - n7], this.yIndices[n]);
                }
            }
        }
        for (n2 = n5; n2 <= n6; ++n2) {
            for (n = n7; n <= n8; ++n) {
                this.tbl.setValueAt(XFormatter.format(fArray[n2 - n5][n - n7], 3), n, n2);
            }
        }
        this.tbl.setColumnSelectionInterval(n5, n6);
        this.tbl.setRowSelectionInterval(n7, n8);
    }
}

