/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.jgoodies.binding.adapter.PreferencesAdapter;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uifextras.util.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class OptionalMessageDialog
extends AbstractDialog {
    private static final String PREFERENCES_NODE = "messages";
    private static final String IS_SHOWING_KEY_EXT = "isShowing";
    private static final Boolean IS_SHOWING_DEFAULT = Boolean.TRUE;
    private static final String TITLE_KEY_EXT = "title";
    private static Hashtable showingMsgModels = new Hashtable();
    private String msgId;
    private Object[] msgArgs;
    private boolean doCancel = false;
    private boolean optionDisplayed = true;
    private String okText;
    private final ResourceBundle bundle;

    public OptionalMessageDialog(Frame frame, String string, ResourceBundle resourceBundle) {
        super(frame, "Information");
        this.bundle = resourceBundle;
        String string2 = resourceBundle.getString(string + "." + TITLE_KEY_EXT);
        if (string2 != null) {
            this.setTitle(string2);
        }
        this.msgId = string;
    }

    public boolean isDoCancel() {
        return this.doCancel;
    }

    public void setDoCancel(boolean bl) {
        this.doCancel = bl;
    }

    public boolean isOptionDisplayed() {
        return this.optionDisplayed;
    }

    public void setOptionDisplayed(boolean bl) {
        this.optionDisplayed = bl;
    }

    public String getOkText() {
        return this.okText;
    }

    public void setOkText(String string) {
        this.okText = string;
    }

    public void setMessageArgs(Object[] objectArray) {
        this.msgArgs = objectArray;
    }

    public static boolean isShowingMsg(String string) {
        return OptionalMessageDialog.getIsShowingMsgModel(string).getBoolean();
    }

    public static void setShowingMsg(String string, boolean bl) {
        OptionalMessageDialog.getIsShowingMsgModel(string).setBoolean(bl);
    }

    public static PreferencesAdapter getIsShowingMsgModel(String string) {
        PreferencesAdapter preferencesAdapter = (PreferencesAdapter)showingMsgModels.get(string);
        if (preferencesAdapter == null) {
            Preferences preferences = Application.getUserPreferences().node(PREFERENCES_NODE);
            preferencesAdapter = new PreferencesAdapter(preferences, string + "." + IS_SHOWING_KEY_EXT, (Object)IS_SHOWING_DEFAULT);
            showingMsgModels.put(string, preferencesAdapter);
        }
        return preferencesAdapter;
    }

    protected JComponent buildContent() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)this.buildMainPanel(), "Center");
        jPanel.add((Component)this.buildButtonBar(), "South");
        return jPanel;
    }

    private JPanel buildMainPanel() {
        Serializable serializable;
        String string = this.bundle.getString(this.msgId);
        if (string == null) {
            string = "Failed to find message text";
        }
        if (this.msgArgs != null) {
            serializable = new MessageFormat(string);
            string = ((Format)serializable).format(this.msgArgs);
        }
        serializable = UIFactory.createMultilineLabel((String)string);
        JLabel jLabel = new JLabel();
        jLabel.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        FormLayout formLayout = new FormLayout("pref, 10dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 1, "fill, top"));
        panelBuilder.add((Component)serializable, cellConstraints.xy(3, 1, "fill, top"));
        return panelBuilder.getPanel();
    }

    private JComponent buildButtonBar() {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.setDefaultButtonBarGapBorder();
        buttonBarBuilder.addUnrelatedGap();
        if (this.isOptionDisplayed()) {
            JCheckBox jCheckBox = new JCheckBox("Always show this message");
            jCheckBox.setModel(this.createShowMsgButtonModel((ValueModel)OptionalMessageDialog.getIsShowingMsgModel(this.msgId)));
            buttonBarBuilder.addFixed((JComponent)jCheckBox);
            buttonBarBuilder.addUnrelatedGap();
        }
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addGridded((JComponent)(this.okText == null ? this.createOKButton(true) : this.createAcceptButton(this.okText, true)));
        if (this.doCancel) {
            buttonBarBuilder.addGridded((JComponent)this.createCancelButton());
        }
        return buttonBarBuilder.getPanel();
    }

    private ButtonModel createShowMsgButtonModel(ValueModel valueModel) {
        return new ToggleButtonAdapter((ValueModel)this.buffer(valueModel));
    }
}

