/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.util.ui.ProgressTask;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ProgressTaskMonitor
extends ProgressMonitor {
    private static final int UPDATE_INTERVAL_MILLIS = 500;
    private ProgressTask task;
    private Timer timer;
    private int lastMin;
    private int lastMax;
    private int lastProgress;
    String lastNote;
    Object closeMutex = new Object();
    boolean wasClosed = false;

    public ProgressTaskMonitor(Component component, ProgressTask progressTask) {
        super(component, progressTask.getMessage(), progressTask.getNote(), progressTask.getMinimumProgress(), progressTask.getMaximumProgress());
        this.task = progressTask;
        this.lastMin = progressTask.getMinimumProgress();
        this.lastMax = progressTask.getMaximumProgress();
        this.lastProgress = progressTask.getProgress();
        this.lastNote = progressTask.getNote();
        this.setMinimum(this.lastMin);
        this.setMaximum(this.lastMax);
        this.setProgress(this.lastProgress);
        this.setNote(this.lastNote);
        this.setProgress(this.lastProgress);
        this.timer = new Timer(500, new TimerListener());
        this.timer.start();
    }

    public static ProgressTaskMonitor createProgressTaskMonitor(Component component, ProgressTask progressTask) throws InterruptedException, InvocationTargetException {
        ProgressMonitorStartup progressMonitorStartup = new ProgressMonitorStartup(component, progressTask);
        if (SwingUtilities.isEventDispatchThread()) {
            progressMonitorStartup.run();
        } else {
            SwingUtilities.invokeAndWait(progressMonitorStartup);
        }
        return progressMonitorStartup.getCreatedMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.wasClosed) {
            return;
        }
        Object object = this.closeMutex;
        synchronized (object) {
            if (this.wasClosed) {
                return;
            }
            this.wasClosed = true;
        }
        try {
            this.task.stop();
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n;
            int n2;
            if (ProgressTaskMonitor.this.isCanceled() || ProgressTaskMonitor.this.task.isDone()) {
                ProgressTaskMonitor.this.close();
                ProgressTaskMonitor.this.task.stop();
                ProgressTaskMonitor.this.timer.stop();
                return;
            }
            int n3 = ProgressTaskMonitor.this.task.getMinimumProgress();
            if (n3 != ProgressTaskMonitor.this.lastMin) {
                ProgressTaskMonitor.this.setMinimum(n3);
                ProgressTaskMonitor.this.lastMin = n3;
            }
            if ((n2 = ProgressTaskMonitor.this.task.getMaximumProgress()) != ProgressTaskMonitor.this.lastMax) {
                ProgressTaskMonitor.this.setMaximum(n2);
                ProgressTaskMonitor.this.lastMax = n2;
            }
            if ((n = ProgressTaskMonitor.this.task.getProgress()) != ProgressTaskMonitor.this.lastProgress) {
                ProgressTaskMonitor.this.setProgress(n);
                ProgressTaskMonitor.this.lastProgress = n;
            }
            if ((string = ProgressTaskMonitor.this.task.getNote()) != null && !string.equals(ProgressTaskMonitor.this.lastNote)) {
                ProgressTaskMonitor.this.setNote(string);
                ProgressTaskMonitor.this.lastNote = string;
            }
        }
    }

    static class ProgressMonitorStartup
    implements Runnable {
        Component parentComponent;
        ProgressTask task;
        ProgressTaskMonitor monitor;

        ProgressMonitorStartup(Component component, ProgressTask progressTask) {
            this.parentComponent = component;
            this.task = progressTask;
        }

        @Override
        public void run() {
            this.monitor = new ProgressTaskMonitor(this.parentComponent, this.task);
        }

        public ProgressTaskMonitor getCreatedMonitor() {
            return this.monitor;
        }
    }
}

