/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.model.MainModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class ScaleListValuesAction
extends AbstractAction {
    private final JTable tbl;
    private final String value;

    public ScaleListValuesAction(JTable jTable) {
        this.tbl = jTable;
        this.value = null;
    }

    public ScaleListValuesAction(JTable jTable, String string) {
        this.tbl = jTable;
        this.value = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = MainModel.getDefaultParentFrame();
        try {
            this._actionPerformed(jFrame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jFrame, "An unexpected exception occured.", exception.toString(), 0);
            Logger.getLogger(ScaleListValuesAction.class.getName()).log(Level.WARNING, "Exception raised when processing action", exception);
        }
    }

    private void _actionPerformed(Component component) {
        String string;
        int n = this.tbl.getColumnCount();
        int n2 = this.tbl.getRowCount();
        boolean[] blArray = new boolean[n2];
        boolean bl = false;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            blArray[i] = this.tbl.isCellSelected(i, 0);
            bl |= blArray[i];
            if (!blArray[i]) continue;
            n3 = Math.min(n3, i);
            n4 = Math.max(n4, i);
        }
        String string2 = this.value != null ? this.value : (string = (String)JOptionPane.showInputDialog(component, bl ? "Scale/multiply selected cells by:" : "Scale/multiply all values by:", "Scale list values", -1, null, null, ""));
        if (string != null) {
            float f = -1.0f;
            try {
                f = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((double)f < 0.0 || (double)f > 5.0) {
                JOptionPane.showMessageDialog(component, "Enter a value from 0.0 to 4.99, where 1.0 indicates no change.", "Unexpected value", 0);
                return;
            }
            for (int i = 0; i < n2; ++i) {
                try {
                    if (bl && !blArray[i]) continue;
                    float f2 = Float.parseFloat(this.tbl.getValueAt(i, 1).toString());
                    this.tbl.setValueAt(String.format("%.1f", Float.valueOf(f2 * f)), i, 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                this.tbl.setRowSelectionInterval(n3, n4);
            }
        }
    }
}

