/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.model.MainModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class ScaleTableValuesAction
extends AbstractAction {
    private final JTable tbl;
    private final String value;

    public ScaleTableValuesAction(JTable jTable) {
        this.tbl = jTable;
        this.value = null;
    }

    public ScaleTableValuesAction(JTable jTable, String string) {
        this.tbl = jTable;
        this.value = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = MainModel.getDefaultParentFrame();
        try {
            this._actionPerformed(jFrame);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(jFrame, "An unexpected exception occured.", exception.toString(), 0);
            Logger.getLogger(ScaleTableValuesAction.class.getName()).log(Level.WARNING, "Exception raised when processing action", exception);
        }
    }

    private void _actionPerformed(Component component) {
        String string;
        int n = this.tbl.getColumnCount();
        int n2 = this.tbl.getRowCount();
        boolean[][] blArray = new boolean[n2][n];
        boolean bl = false;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                blArray[j][i] = this.tbl.isCellSelected(j, i);
                bl |= blArray[j][i];
                if (!blArray[j][i]) continue;
                n3 = Math.min(n3, i);
                n4 = Math.max(n4, i);
                n5 = Math.min(n5, j);
                n6 = Math.max(n6, j);
            }
        }
        String string2 = this.value != null ? this.value : (string = (String)JOptionPane.showInputDialog(component, bl ? "Scale/multiply selected cells by:" : "Scale/multiply all values by:", "Scale table values", -1, null, null, ""));
        if (string != null) {
            float f = -1.0f;
            try {
                f = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((double)f < 0.0 || (double)f > 5.0) {
                JOptionPane.showMessageDialog(component, "Enter a value from 0.0 to 4.99, where 1.0 indicates no change.", "Unexpected value", 0);
                return;
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    try {
                        if (bl && !blArray[j][i]) continue;
                        float f2 = Float.parseFloat(this.tbl.getValueAt(j, i).toString());
                        this.tbl.setValueAt(String.format("%.1f", Float.valueOf(f2 * f)), j, i);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (bl) {
                this.tbl.setColumnSelectionInterval(n3, n4);
                this.tbl.setRowSelectionInterval(n5, n6);
            }
        }
    }
}

