/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.util.XFormatter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.FocusManager;
import javax.swing.JTextField;

public abstract class TextFieldValidator
implements FocusListener,
ActionListener {
    private JTextField textField;
    private String enterText;
    private int origInt;
    private float origFloat;

    public abstract String validateText(String var1, String var2);

    public TextFieldValidator(JTextField jTextField) {
        this.textField = jTextField;
        this.textField.addFocusListener(this);
        this.textField.addActionListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.enterText = this.textField.getText();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        String string = this.textField.getText();
        if (string != null && this.enterText != null && !string.equals(this.enterText)) {
            string = this.validateText(this.enterText, string);
            this.textField.setText(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.enterText == null) {
            return;
        }
        String string = this.validateText(this.enterText, this.textField.getText());
        this.textField.setText(string);
        FocusManager.getCurrentManager().focusNextComponent(this.textField);
    }

    public int getValueInt() {
        int n;
        try {
            n = Integer.parseInt(this.textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = this.origInt;
        }
        return n;
    }

    public float getValueFloat() {
        float f;
        try {
            f = XFormatter.parse(this.textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            f = this.origFloat;
        }
        return f;
    }

    public void setValueInt(int n) {
        this.origInt = n;
        this.origFloat = n;
        this.textField.setText(Integer.toString(n));
    }

    public void setValueFloat(float f) {
        this.origInt = Math.round(f);
        this.origFloat = f;
        this.textField.setText(Float.toString(f));
    }

    public void setValueFloat(float f, int n) {
        this.origInt = Math.round(f);
        this.origFloat = f;
        this.textField.setText(XFormatter.format(f, n));
    }
}

