/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.util.ui.TrackedTabbedPane;
import com.jgoodies.binding.beans.Observable;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class TrackedTabPanel
extends JPanel
implements Observable {
    public static final String PROPERTYNAME_STATE = "state";
    public static final String PROPERTYNAME_TAB_NAME = "tabName";
    public static final String PROPERTYNAME_TOOL_TIP = "toolTip";
    public static final String PROPERTYNAME_ICON = "icon";
    public static final Integer STATE_TAB_ADDED = new Integer(1);
    public static final Integer STATE_TAB_SHOWN = new Integer(2);
    public static final Integer STATE_TAB_HIDDEN = new Integer(3);
    public static final Integer STATE_TAB_REMOVED = new Integer(4);
    private String tabName = "noname";
    private String toolTip = "";
    private Icon icon = null;
    private Integer state = null;
    private TrackedTabbedPane parent;
    private boolean active;

    void setParent(TrackedTabbedPane trackedTabbedPane) {
        this.parent = trackedTabbedPane;
    }

    protected void tabAdded() {
        this.setState(STATE_TAB_ADDED);
    }

    protected void tabRemoved() {
        this.setState(STATE_TAB_REMOVED);
    }

    public void tabShown() {
        this.setState(STATE_TAB_SHOWN);
    }

    public void tabHidden() {
        this.setState(STATE_TAB_HIDDEN);
    }

    public Integer getState() {
        return this.state;
    }

    private void setState(Integer n) {
        Integer n2 = this.state;
        this.state = n;
        this.firePropertyChange(PROPERTYNAME_STATE, n2, n);
    }

    protected String getUniqueTabName(String string) {
        if (!this.hasTabNamed(string)) {
            return string;
        }
        for (int i = 1; i < 100; ++i) {
            String string2 = string + "-" + Integer.toString(i);
            if (this.hasTabNamed(string2)) continue;
            return string2;
        }
        return string;
    }

    protected boolean hasTabNamed(String string) {
        int n = this.parent.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this.parent.getTitleAt(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void _activateIfNotActive() {
        try {
            if (!this.active) {
                this.tabShown();
            }
        }
        finally {
            this.active = true;
        }
    }

    protected void _deactivateIfActive() {
        try {
            if (this.active) {
                this.tabHidden();
            }
        }
        finally {
            this.active = false;
        }
    }

    public Icon getTabIcon() {
        return this.icon;
    }

    public void setTabIcon(Icon icon) {
        Icon icon2 = this.icon;
        this.icon = icon;
        this.firePropertyChange(PROPERTYNAME_ICON, icon2, icon);
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String string) {
        String string2 = this.tabName;
        this.tabName = string;
        this.firePropertyChange(PROPERTYNAME_TAB_NAME, string2, string);
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String string) {
        String string2 = this.toolTip;
        this.toolTip = string;
        this.firePropertyChange(PROPERTYNAME_TOOL_TIP, string2, string);
    }
}

