/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.util.ui;

import com.ecmtuning.ecmlink.util.ReflectionUtils;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class TrackedTabbedPane
extends JTabbedPane {
    Component lastSelection;
    boolean busy;
    private final PropertyChangeListener tabChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n;
            if (propertyChangeEvent.getSource() instanceof TrackedTabPanel && (n = TrackedTabbedPane.this.indexOfComponent((Component)propertyChangeEvent.getSource())) != -1) {
                String string = propertyChangeEvent.getPropertyName();
                if ("toolTip".equals(string)) {
                    TrackedTabbedPane.this.setToolTipTextAt(n, (String)propertyChangeEvent.getNewValue());
                } else if ("tabName".equals(string)) {
                    TrackedTabbedPane.this.setTitleAt(n, (String)propertyChangeEvent.getNewValue());
                } else if ("icon".equals(string)) {
                    TrackedTabbedPane.this.setIconAt(n, (Icon)propertyChangeEvent.getNewValue());
                }
            }
        }
    };
    private static final int LINEWIDTH = 3;
    private static final String NAME = "test";
    private final GhostGlassPane glassPane = new GhostGlassPane();
    private final Rectangle lineRect = new Rectangle();
    private final Color lineColor = new Color(0, 100, 255);
    private int dragTabIndex = -1;
    private boolean moveInProgress = false;
    private static Rectangle rBackward = new Rectangle();
    private static Rectangle rForward = new Rectangle();
    private static int rwh = 20;
    private static int buttonsize = 30;
    private boolean hasGhost = true;
    private boolean isPaintScrollArea = true;

    public TrackedTabbedPane() {
        this.finishConstruction();
    }

    public TrackedTabbedPane(int n, int n2) {
        super(n, n2);
        this.finishConstruction();
    }

    public TrackedTabbedPane(int n) {
        super(n);
        this.finishConstruction();
    }

    public ArrayList getTabs() {
        int n = this.getTabCount();
        ArrayList<Component> arrayList = new ArrayList<Component>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getComponentAt(i));
        }
        return arrayList;
    }

    public int indexOfTab(Component component) {
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (this.getComponentAt(i) != component) continue;
            return i;
        }
        return -1;
    }

    protected void checkNewSelection() {
        Component component = this.getSelectedComponent();
        if (component != this.lastSelection) {
            try {
                if (this.lastSelection != null && this.lastSelection instanceof TrackedTabPanel) {
                    ((TrackedTabPanel)this.lastSelection)._deactivateIfActive();
                }
                if (component != null && component instanceof TrackedTabPanel) {
                    ((TrackedTabPanel)component)._activateIfNotActive();
                }
            }
            finally {
                this.lastSelection = component;
            }
        }
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        if (!this.busy) {
            this.checkNewSelection();
        }
    }

    @Override
    public synchronized void removeTabAt(int n) {
        Component component = this.getComponentAt(n);
        this.busy = true;
        try {
            super.removeTabAt(n);
        }
        finally {
            this.busy = false;
        }
        this.checkNewSelection();
        if (!this.moveInProgress && component != null && component instanceof TrackedTabPanel) {
            TrackedTabPanel trackedTabPanel = (TrackedTabPanel)component;
            trackedTabPanel.tabRemoved();
            trackedTabPanel.removePropertyChangeListener(this.tabChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertTab(String string, Icon icon, Component component, String string2, int n) {
        if (this.moveInProgress) {
            super.insertTab(string, icon, component, string2, n);
        } else {
            if (component instanceof TrackedTabPanel) {
                TrackedTabPanel trackedTabPanel = (TrackedTabPanel)component;
                trackedTabPanel.setParent(this);
                trackedTabPanel.tabAdded();
                string = trackedTabPanel.getTabName();
                string2 = trackedTabPanel.getToolTip();
                icon = trackedTabPanel.getTabIcon();
                trackedTabPanel.addPropertyChangeListener(this.tabChangeListener);
            }
            this.busy = true;
            try {
                int n2 = this.getSelectedIndex();
                super.insertTab(string, icon, component, string2, n);
                if (n2 == this.getSelectedIndex() && n <= this.getSelectedIndex() && this.getSelectedIndex() != this.getTabCount() - 1) {
                    this.setSelectedIndex(this.getSelectedIndex() + 1);
                }
            }
            finally {
                this.busy = false;
            }
        }
        this.checkNewSelection();
    }

    public void addSelectedTab(Component component, boolean bl) {
        boolean bl2;
        super.add(component);
        boolean bl3 = bl2 = this.getSelectedComponent() == component;
        if (bl && !bl2) {
            this.setSelectedComponent(component);
        }
    }

    private void finishConstruction() {
        final DragSourceListener dragSourceListener = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragExit(DragSourceEvent dragSourceEvent) {
                dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                TrackedTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                TrackedTabbedPane.this.glassPane.setPoint(new Point(-1000, -1000));
                TrackedTabbedPane.this.glassPane.repaint();
            }

            @Override
            public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
                Point point = dragSourceDragEvent.getLocation();
                SwingUtilities.convertPointFromScreen(point, TrackedTabbedPane.this.glassPane);
                int n = TrackedTabbedPane.this.getTargetTabIndex(point);
                if (TrackedTabbedPane.this.getTabAreaBounds().contains(point) && n >= 0 && n != TrackedTabbedPane.this.dragTabIndex && n != TrackedTabbedPane.this.dragTabIndex + 1) {
                    dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                    TrackedTabbedPane.this.glassPane.setCursor(DragSource.DefaultMoveDrop);
                } else {
                    dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                    TrackedTabbedPane.this.glassPane.setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                TrackedTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                TrackedTabbedPane.this.dragTabIndex = -1;
                TrackedTabbedPane.this.glassPane.setVisible(false);
                if (TrackedTabbedPane.this.hasGhost()) {
                    TrackedTabbedPane.this.glassPane.setVisible(false);
                    TrackedTabbedPane.this.glassPane.setImage(null);
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            }
        };
        final Transferable transferable = new Transferable(){
            private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "test");

            @Override
            public Object getTransferData(DataFlavor dataFlavor) {
                return TrackedTabbedPane.this;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{this.FLAVOR};
                return dataFlavorArray;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.getHumanPresentableName().equals(TrackedTabbedPane.NAME);
            }
        };
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
                if (TrackedTabbedPane.this.getTabCount() <= 1) {
                    return;
                }
                Point point = dragGestureEvent.getDragOrigin();
                TrackedTabbedPane.this.dragTabIndex = TrackedTabbedPane.this.indexAtLocation(point.x, point.y);
                if (TrackedTabbedPane.this.dragTabIndex < 0 || !TrackedTabbedPane.this.isEnabledAt(TrackedTabbedPane.this.dragTabIndex)) {
                    return;
                }
                TrackedTabbedPane.this.initGlassPane(dragGestureEvent.getComponent(), dragGestureEvent.getDragOrigin());
                try {
                    dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, dragSourceListener);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    invalidDnDOperationException.printStackTrace();
                }
            }
        };
        new DropTarget(this.glassPane, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dragGestureListener);
    }

    private void clickArrowButton(String string) {
        Action action;
        ActionMap actionMap = this.getActionMap();
        if (actionMap != null && (action = actionMap.get(string)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    private void autoScrollTest(Point point) {
        Rectangle rectangle = this.getTabAreaBounds();
        int n = this.getTabPlacement();
        if (n == 1 || n == 3) {
            rBackward.setBounds(rectangle.x, rectangle.y, rwh, rectangle.height);
            rForward.setBounds(rectangle.x + rectangle.width - rwh - buttonsize, rectangle.y, rwh + buttonsize, rectangle.height);
        } else if (n == 2 || n == 4) {
            rBackward.setBounds(rectangle.x, rectangle.y, rectangle.width, rwh);
            rForward.setBounds(rectangle.x, rectangle.y + rectangle.height - rwh - buttonsize, rectangle.width, rwh + buttonsize);
        }
        if (rBackward.contains(point)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (rForward.contains(point)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    public void setPaintGhost(boolean bl) {
        this.hasGhost = bl;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    public void setPaintScrollArea(boolean bl) {
        this.isPaintScrollArea = bl;
    }

    public boolean isPaintScrollArea() {
        return this.isPaintScrollArea;
    }

    private int getTargetTabIndex(Point point) {
        Point point2 = SwingUtilities.convertPoint(this.glassPane, point, this);
        boolean bl = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle rectangle = this.getBoundsAt(i);
            if (bl) {
                rectangle.setRect(rectangle.x - rectangle.width / 2, rectangle.y, rectangle.width, rectangle.height);
            } else {
                rectangle.setRect(rectangle.x, rectangle.y - rectangle.height / 2, rectangle.width, rectangle.height);
            }
            if (!rectangle.contains(point2)) continue;
            return i;
        }
        Rectangle rectangle = this.getBoundsAt(this.getTabCount() - 1);
        if (bl) {
            rectangle.setRect(rectangle.x + rectangle.width / 2, rectangle.y, rectangle.width, rectangle.height);
        } else {
            rectangle.setRect(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height);
        }
        return rectangle.contains(point2) ? this.getTabCount() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertTab(int n, int n2) {
        if (n2 < 0 || n == n2) {
            return;
        }
        Component component = this.getComponentAt(n);
        Component component2 = null;
        if (ReflectionUtils.hasMethod(this, "getTabComponentAt", ReflectionUtils.parmTypesInt)) {
            component2 = (Component)ReflectionUtils.invokeMethod(this, "getTabComponentAt", ReflectionUtils.parmTypesInt, new Object[]{new Integer(n)});
        }
        String string = this.getTitleAt(n);
        Icon icon = this.getIconAt(n);
        String string2 = this.getToolTipTextAt(n);
        boolean bl = this.isEnabledAt(n);
        int n3 = n > n2 ? n2 : n2 - 1;
        try {
            this.moveInProgress = true;
            this.remove(n);
            this.insertTab(string, icon, component, string2, n3);
        }
        finally {
            this.moveInProgress = false;
        }
        this.setEnabledAt(n3, bl);
        if (bl) {
            this.setSelectedIndex(n3);
        }
        if (ReflectionUtils.hasMethod(this, "setTabComponentAt", new Class[]{Integer.TYPE, Component.class})) {
            ReflectionUtils.invokeMethod(this, "setTabComponentAt", new Class[]{Integer.TYPE, Component.class}, new Object[]{new Integer(n3), component2});
        }
    }

    private void initTargetLeftRightLine(int n) {
        if (n < 0 || this.dragTabIndex == n || n - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (n == 0) {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(rectangle.x - 1, rectangle.y, 3.0, rectangle.height);
        } else {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(n - 1), this.glassPane);
            this.lineRect.setRect(rectangle.x + rectangle.width - 1, rectangle.y, 3.0, rectangle.height);
        }
    }

    private void initTargetTopBottomLine(int n) {
        if (n < 0 || this.dragTabIndex == n || n - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (n == 0) {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(rectangle.x, rectangle.y - 1, rectangle.width, 3.0);
        } else {
            Rectangle rectangle = SwingUtilities.convertRectangle(this, this.getBoundsAt(n - 1), this.glassPane);
            this.lineRect.setRect(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.width, 3.0);
        }
    }

    private void initGlassPane(Component component, Point point) {
        Cloneable cloneable;
        this.getRootPane().setGlassPane(this.glassPane);
        if (this.hasGhost()) {
            cloneable = this.getBoundsAt(this.dragTabIndex);
            BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics graphics = bufferedImage.getGraphics();
            component.paint(graphics);
            cloneable.x = cloneable.x < 0 ? 0 : cloneable.x;
            cloneable.y = cloneable.y < 0 ? 0 : cloneable.y;
            bufferedImage = bufferedImage.getSubimage(cloneable.x, cloneable.y, cloneable.width, cloneable.height);
            this.glassPane.setImage(bufferedImage);
        }
        cloneable = SwingUtilities.convertPoint(component, point, this.glassPane);
        this.glassPane.setPoint((Point)cloneable);
        this.glassPane.setVisible(true);
    }

    private Rectangle getTabAreaBounds() {
        Rectangle rectangle = this.getBounds();
        Component component = this.getSelectedComponent();
        int n = 0;
        while (component == null && n < this.getTabCount()) {
            component = this.getComponentAt(n++);
        }
        Rectangle rectangle2 = component == null ? new Rectangle() : component.getBounds();
        int n2 = this.getTabPlacement();
        if (n2 == 1) {
            rectangle.height -= rectangle2.height;
        } else if (n2 == 3) {
            rectangle.y = rectangle.y + rectangle2.y + rectangle2.height;
            rectangle.height -= rectangle2.height;
        } else if (n2 == 2) {
            rectangle.width -= rectangle2.width;
        } else if (n2 == 4) {
            rectangle.x = rectangle.x + rectangle2.x + rectangle2.width;
            rectangle.width -= rectangle2.width;
        }
        rectangle.grow(2, 2);
        return rectangle;
    }

    class GhostGlassPane
    extends JPanel {
        private final AlphaComposite composite;
        private Point location = new Point(0, 0);
        private BufferedImage draggingGhost = null;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.composite = AlphaComposite.getInstance(3, 0.5f);
        }

        public void setImage(BufferedImage bufferedImage) {
            this.draggingGhost = bufferedImage;
        }

        public void setPoint(Point point) {
            this.location = point;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(this.composite);
            if (!TrackedTabbedPane.this.isPaintScrollArea() || TrackedTabbedPane.this.getTabLayoutPolicy() == 1) {
                // empty if block
            }
            if (this.draggingGhost != null) {
                double d = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
                double d2 = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
                graphics2D.drawImage((Image)this.draggingGhost, (int)d, (int)d2, null);
            }
            if (TrackedTabbedPane.this.dragTabIndex >= 0) {
                graphics2D.setPaint(TrackedTabbedPane.this.lineColor);
                graphics2D.fill(TrackedTabbedPane.this.lineRect);
            }
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        private Point pt_ = new Point();

        CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (this.isDragAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            if (TrackedTabbedPane.this.getTabPlacement() == 1 || TrackedTabbedPane.this.getTabPlacement() == 3) {
                TrackedTabbedPane.this.initTargetLeftRightLine(TrackedTabbedPane.this.getTargetTabIndex(point));
            } else {
                TrackedTabbedPane.this.initTargetTopBottomLine(TrackedTabbedPane.this.getTargetTabIndex(point));
            }
            if (TrackedTabbedPane.this.hasGhost()) {
                TrackedTabbedPane.this.glassPane.setPoint(point);
            }
            if (!this.pt_.equals(point)) {
                TrackedTabbedPane.this.glassPane.repaint();
            }
            this.pt_ = point;
            TrackedTabbedPane.this.autoScrollTest(point);
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (this.isDropAcceptable(dropTargetDropEvent)) {
                TrackedTabbedPane.this.convertTab(TrackedTabbedPane.this.dragTabIndex, TrackedTabbedPane.this.getTargetTabIndex(dropTargetDropEvent.getLocation()));
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.dropComplete(false);
            }
            TrackedTabbedPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
            if (ReflectionUtils.hasMethod(dropTargetDragEvent, "getTransferable", ReflectionUtils.parmTypesVoid)) {
                Transferable transferable = (Transferable)ReflectionUtils.invokeMethod(dropTargetDragEvent, "getTransferable");
                if (transferable == null) {
                    return false;
                }
                DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
                if (transferable.isDataFlavorSupported(dataFlavorArray[0]) && TrackedTabbedPane.this.dragTabIndex >= 0) {
                    return true;
                }
            } else {
                DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
                if (TrackedTabbedPane.this.dragTabIndex >= 0) {
                    return true;
                }
            }
            return false;
        }

        public boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable == null) {
                return false;
            }
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            return transferable.isDataFlavorSupported(dataFlavorArray[0]) && TrackedTabbedPane.this.dragTabIndex >= 0;
        }
    }
}

