/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.ValueModelPlug;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.value.ValueModel;
import java.util.Map;

class ALSKnockRecordModel
extends RecordModel {
    ValueModel mdlEnable;
    ValueModel mdlClutchEnable;
    ValueModelPlug mdlALSRPM;
    ValueModelPlug mdlALSDisableSpeed;
    ValueModelPlug mdlALSEnableSpeed;
    ValueModelPlug mdlALSTPS;
    ValueModelPlug mdlTiming;
    ValueModelPlug mdlFuel;
    ValueModelPlug mdlKnockRPM;
    ValueModelPlug mdlKnockTPS;

    ALSKnockRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(7, map);
        this.mdlEnable = this.track(this.mdlEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("ALSBits", 1));
        this.mdlALSRPM = this.track(this.mdlALSRPM, baseRecord.numberFieldAsIntegerString("ALSRPMs32", 50));
        this.mdlTiming = this.track(this.mdlTiming, baseRecord.numberFieldAsString("ALSIgnDelay", 1));
        this.mdlFuel = this.track(this.mdlFuel, baseRecord.numberFieldAsString("ALSFT"));
        this.mdlClutchEnable = this.track(this.mdlClutchEnable, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("ALSBits", 2));
        this.mdlALSDisableSpeed = baseRecord.numberFieldAsString("ALSLoSpd");
        UnitsHelper.installFilter(this.mdlALSDisableSpeed, "typeSpeedFromMPH");
        this.track(null, this.mdlALSDisableSpeed);
        this.mdlALSEnableSpeed = baseRecord.numberFieldAsString("ALSHiSpd");
        UnitsHelper.installFilter(this.mdlALSEnableSpeed, "typeSpeedFromMPH");
        this.track(null, this.mdlALSEnableSpeed);
        this.mdlALSTPS = this.track(this.mdlALSTPS, baseRecord.numberFieldAsString("ALSTPS"));
        BaseRecord baseRecord2 = RecordSet.getRecord(13, map);
        this.mdlKnockRPM = this.track(this.mdlKnockRPM, baseRecord2.numberFieldAsIntegerString("KnckRPMThresh", 50));
        this.mdlKnockTPS = this.track(this.mdlKnockTPS, baseRecord2.numberFieldAsString("KnckTPSThresh"));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsRecordId(7, map) && RecordSet.containsRecordId(13, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return ALSKnockRecordModel.canDisplay(map);
    }
}

