/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.model.UnitsHelper;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.view.ecmlink.ALSKnockRecordModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.uif.AbstractView;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;

public class ALSKnockRecordView
extends AbstractView {
    private JCheckBox cbALSEnable;
    private JCheckBox cbALSClutchEnable;
    private JLabel lblALSTPS;
    private JLabel lblALSTPSUnits;
    private JLabel lblALSRPM;
    private JLabel lblALSRPMUnits;
    private JLabel lblALSDisableSpd;
    private JLabel lblALSDisableSpdUnits;
    private JLabel lblALSEnableSpd;
    private JLabel lblALSEnableSpdUnits;
    private JLabel lblALSTiming;
    private JLabel lblALSTimingUnits;
    private JLabel lblALSFuel;
    private JLabel lblALSFuelUnits;
    private JLabel lblALSClutch;
    private JSpinner spnrALSTPS;
    private JSpinner spnrALSRPM;
    private JSpinner spnrDisableSpd;
    private JSpinner spnrEnableSpd;
    private JSpinner spnrALSIgnDelay;
    private JSpinner spnrALSFuel;
    private JSpinner spnrKnockRPM;
    private JSpinner spnrKnockTPS;
    private final ALSKnockRecordModel model;

    public ALSKnockRecordView(ALSKnockRecordModel aLSKnockRecordModel) {
        this.model = aLSKnockRecordModel;
    }

    private void initComponents() {
        this.cbALSEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlEnable, (String)"Enable antilag operation");
        this.cbALSEnable.setToolTipText("Enables drag-style antilag operation");
        this.lblALSTPS = new JLabel("Enable antilag with TPS >=");
        this.spnrALSTPS = DialogUtil.createSpinnerTextField(this.model.mdlALSTPS, "Disables antilag below this throttle angle");
        this.lblALSTPSUnits = new JLabel("%");
        this.lblALSRPM = new JLabel("Use launch control with RPM >=");
        this.spnrALSRPM = DialogUtil.createSpinnerTextField(this.model.mdlALSRPM, "Activates ALS function when engine RPM exceeds this value");
        this.lblALSRPMUnits = new JLabel("rpm");
        this.lblALSDisableSpd = new JLabel("And speed <");
        this.spnrDisableSpd = DialogUtil.createSpinnerTextField(this.model.mdlALSDisableSpeed, "Defines the speed at and above which the launch logic will no longer be used");
        this.lblALSDisableSpdUnits = UnitsHelper.createJLabel("typeSpeedFromMPH");
        this.lblALSEnableSpd = new JLabel("Use clutch cut with speed >=");
        this.spnrEnableSpd = DialogUtil.createSpinnerTextField(this.model.mdlALSEnableSpeed, "Defines the speed at and above which shift logic (clutch switch) will be used");
        this.lblALSEnableSpdUnits = UnitsHelper.createJLabel("typeSpeedFromMPH");
        this.lblALSTiming = new JLabel("Hold timing at:");
        this.spnrALSIgnDelay = DialogUtil.createSpinnerTextField(this.model.mdlTiming, "Holds ignition advance at this value while ALS is active");
        this.lblALSTimingUnits = new JLabel("\u00b0 ATDC");
        this.lblALSFuel = new JLabel("Enrich fuel by:");
        this.spnrALSFuel = DialogUtil.createSpinnerTextField(this.model.mdlFuel, "Adjusts fuel delivery by specified percentage.");
        this.lblALSFuelUnits = new JLabel("%");
        this.lblALSClutch = new JLabel("During shifts:");
        this.cbALSClutchEnable = BasicComponentFactory.createCheckBox((ValueModel)this.model.mdlClutchEnable, (String)"Activate ALS with clutch switch while moving");
        this.cbALSClutchEnable.setToolTipText("Enables ALS when the clutch switch is active while moving with high throttle");
        DialogUtil.installComponentEnabler(this.model.mdlEnable, new Component[]{this.cbALSClutchEnable, this.lblALSTPS, this.lblALSTPSUnits, this.lblALSRPM, this.lblALSRPMUnits, this.lblALSDisableSpd, this.lblALSDisableSpdUnits, this.lblALSEnableSpd, this.lblALSEnableSpdUnits, this.lblALSTiming, this.lblALSTimingUnits, this.lblALSFuel, this.lblALSFuelUnits, this.lblALSClutch, this.spnrALSRPM, this.spnrALSIgnDelay, this.spnrALSFuel});
        this.spnrKnockRPM = DialogUtil.createSpinnerTextField(this.model.mdlKnockRPM, "Disables the knock sensor below this RPM");
        this.spnrKnockTPS = DialogUtil.createSpinnerTextField(this.model.mdlKnockTPS, "Disables the knock sensor below this throttle angle");
    }

    protected JComponent buildPanel() {
        this.initComponents();
        ArrayList<ColumnSpec> arrayList = new ArrayList<ColumnSpec>();
        arrayList.add(DialogUtil.INDENT_COLSPEC);
        arrayList.add(DialogUtil.RIGHT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.LABEL_COMPONENT_GAP_COLSPEC);
        arrayList.add(DialogUtil.LEFT_PREF_NOGROW_COLSPEC);
        arrayList.add(DialogUtil.GLUE_COLSPEC);
        RowSpec rowSpec = DialogUtil.DEFAULT_PREF_NOGROW_ROWSPEC;
        RowSpec rowSpec2 = DialogUtil.SEPARATOR_GAP_ROWSPEC;
        RowSpec rowSpec3 = DialogUtil.RELATED_GAP_ROWSPEC;
        RowSpec rowSpec4 = DialogUtil.INTER_SECT_GAP_ROWSPEC;
        ArrayList arrayList2 = new ArrayList();
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec, rowSpec4);
        ListUtil.add(arrayList2, rowSpec, rowSpec2);
        ListUtil.add(arrayList2, rowSpec, rowSpec3);
        ListUtil.add(arrayList2, rowSpec);
        FormLayout formLayout = new FormLayout(arrayList, arrayList2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.getPanel().setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator("Antilag Controls", cellConstraints.xyw(1, n, 7));
        panelBuilder.add((Component)this.cbALSEnable, cellConstraints.xyw(2, n += 2, 6));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, this.lblALSTPS, this.spnrALSTPS, this.lblALSTPSUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblALSRPM, this.spnrALSRPM, this.lblALSRPMUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblALSDisableSpd, this.spnrDisableSpd, this.lblALSDisableSpdUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblALSEnableSpd, this.spnrEnableSpd, this.lblALSEnableSpdUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblALSTiming, this.spnrALSIgnDelay, this.lblALSTimingUnits, cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, this.lblALSFuel, this.spnrALSFuel, this.lblALSFuelUnits, cellConstraints.xy(2, n));
        panelBuilder.add((Component)this.lblALSClutch, cellConstraints.xy(2, n));
        panelBuilder.add((Component)this.cbALSClutchEnable, cellConstraints.xyw(4, n, 4));
        panelBuilder.addSeparator("Knock Sensor Control", cellConstraints.xyw(1, n += 2, 7));
        n += 2;
        n = DialogUtil.addTriplet(panelBuilder, "Activate with RPM >=", this.spnrKnockRPM, "rpm", cellConstraints.xy(2, n));
        n = DialogUtil.addTriplet(panelBuilder, "And TPS >=", this.spnrKnockTPS, "%", cellConstraints.xy(2, n));
        return panelBuilder.getPanel();
    }
}

