/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.data.Location;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.jgoodies.binding.BindingUtils;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AbstractGaugeModel
extends AbstractValueModel
implements UnpluggableValueModel {
    private String currentValue;
    private ValueModel selectModel;
    private ValueModel offsetModel;
    private ValueModel scaleModel;
    private final ComboEntry[] comboEntries;
    private static Logger logger = Logger.getLogger(AbstractGaugeModel.class.getName());
    PropertyChangeListener selectCurrentValueListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractGaugeModel.this.selectCurrentValue();
        }
    };

    AbstractGaugeModel(BaseRecord baseRecord, ComboEntry[] comboEntryArray) {
        this.comboEntries = new ComboEntry[comboEntryArray.length];
        for (int i = 0; i < comboEntryArray.length; ++i) {
            ComboEntry comboEntry = comboEntryArray[i];
            this.comboEntries[i] = new ComboEntry(comboEntry, baseRecord.getDeviceId());
            if (this.comboEntries[i].address != -1) continue;
            this.comboEntries[i] = new ComboEntry("ERROR-" + this.comboEntries[i].displayText, "ERROR", 0.0f, 0.0f);
        }
        this.selectModel = baseRecord.getField("GaugeSelVal");
        this.offsetModel = baseRecord.getField("GaugeOffset");
        this.scaleModel = baseRecord.getField("GaugeScale");
        this.selectModel.addValueChangeListener(this.selectCurrentValueListener);
        this.offsetModel.addValueChangeListener(this.selectCurrentValueListener);
        this.scaleModel.addValueChangeListener(this.selectCurrentValueListener);
        this.currentValue = this.comboEntries[0].displayText;
        this.selectCurrentValue();
    }

    @Override
    public void unplug() {
        this.selectModel.removeValueChangeListener(this.selectCurrentValueListener);
        this.offsetModel.removeValueChangeListener(this.selectCurrentValueListener);
        this.scaleModel.removeValueChangeListener(this.selectCurrentValueListener);
        this.scaleModel = null;
        this.offsetModel = null;
        this.selectModel = null;
    }

    private synchronized void selectCurrentValue() {
        int n;
        int n2;
        int n3 = ((Number)this.selectModel.getValue()).intValue();
        int n4 = this.findMatchingComboEntry(n3, n2 = ((Number)this.offsetModel.getValue()).intValue(), n = ((Number)this.scaleModel.getValue()).intValue());
        if (n4 != -1) {
            String string = this.comboEntries[n4].displayText;
            String string2 = this.currentValue;
            this.currentValue = string;
            this.fireValueChange(string2, string);
        }
    }

    public Object getValue() {
        return this.currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        int n = this.findComboListValue((String)object);
        if (n != -1) {
            AbstractGaugeModel abstractGaugeModel = this;
            synchronized (abstractGaugeModel) {
                this.selectModel.setValue((Object)new Float(this.comboEntries[n].address));
                this.offsetModel.setValue((Object)new Float(this.comboEntries[n].offset));
                this.scaleModel.setValue((Object)new Float(this.comboEntries[n].scale));
            }
        } else {
            logger.info("Invalid value passed in '" + object.toString() + "'");
        }
    }

    public List getComboListValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.comboEntries.length; ++i) {
            arrayList.add(this.comboEntries[i].displayText);
        }
        return arrayList;
    }

    final int findComboListValue(String string) {
        for (int i = 0; i < this.comboEntries.length; ++i) {
            if (!this.comboEntries[i].displayText.equals(string)) continue;
            return i;
        }
        return -1;
    }

    final int findMatchingComboEntry(int n, int n2, int n3) {
        for (int i = 0; i < this.comboEntries.length; ++i) {
            if (this.comboEntries[i].address != n || this.comboEntries[i].offset != n2 || this.comboEntries[i].scale != n3) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractGaugeModel)) {
            return false;
        }
        AbstractGaugeModel abstractGaugeModel = (AbstractGaugeModel)object;
        return BindingUtils.equals((Object)this.scaleModel, (Object)abstractGaugeModel.scaleModel) && BindingUtils.equals((Object)this.offsetModel, (Object)abstractGaugeModel.offsetModel) && BindingUtils.equals((Object)this.selectModel, (Object)abstractGaugeModel.selectModel);
    }

    static class ComboEntry {
        final String displayText;
        final String locationName;
        int address;
        final int offset;
        final int scale;

        ComboEntry(String string, String string2, float f, float f2) {
            this.displayText = string;
            this.locationName = string2;
            this.offset = Math.round(f);
            this.scale = Math.round(f2);
        }

        ComboEntry(ComboEntry comboEntry, int n) {
            this.displayText = comboEntry.displayText;
            this.locationName = comboEntry.locationName;
            this.offset = comboEntry.offset;
            this.scale = comboEntry.scale;
            Location location = DataManager.getLocationByName(n, this.locationName);
            if (location == null) {
                logger.warning("Failed to find location named " + this.locationName + " for deviceId " + n);
                this.address = -1;
            } else {
                this.address = location.getAddress();
            }
        }
    }
}

