/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.view.ecmlink;

import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDTC;
import com.ecmtuning.ecmlink.device.ecmlink.records.DTC1GDSMRecord;
import com.ecmtuning.ecmlink.device.records.BaseRecord;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.model.UnpluggableValueModel;
import com.ecmtuning.ecmlink.util.model.WeakListeners;
import com.ecmtuning.ecmlink.view.ecmlink.RecordModel;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DTC1GRecordModel
extends RecordModel {
    ValueModel mdlEGR;
    ValueModel mdlO2;
    ValueModel mdlTPS;
    ValueModel mdlFuelPump;
    ValueModel mdlSpeed;
    ValueModel mdlKnock;
    ArrayListModel listMdlDTCs;
    ArrayListModel listMdlDTCDescs;
    final DTC1GDSMRecord dtcRecord;
    PropertyChangeListener dtcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DTC1GRecordModel.this.updateLists();
        }
    };

    DTC1GRecordModel(RecordSet recordSet) {
        this.initialize(recordSet);
        this.listMdlDTCs = new ArrayListModel();
        this.listMdlDTCDescs = new ArrayListModel();
        Map map = recordSet.getPersistentRecordMap();
        this.dtcRecord = (DTC1GDSMRecord)RecordSet.getRecord(-1, map);
        WeakListeners.addValueChangeListener(this.dtcListener, this.dtcRecord.getField("DtcTable"));
    }

    public void updateLists() {
        Integer n;
        List list = this.dtcRecord.getDTCs();
        this.listMdlDTCs.clear();
        this.listMdlDTCDescs.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (n = (Integer)iterator.next()) != 0) {
            this.listMdlDTCs.add((Object)XFormatter.toHex4(n));
            this.listMdlDTCDescs.add((Object)ECMLinkDTC.get1GDTCDesc(n));
        }
    }

    @Override
    protected void initAndTrackModels(Map map) {
        BaseRecord baseRecord = RecordSet.getRecord(17, map);
        this.mdlEGR = this.track(this.mdlEGR, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 1));
        this.mdlO2 = this.track(this.mdlO2, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 2));
        this.mdlTPS = this.track(this.mdlTPS, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 4));
        this.mdlFuelPump = this.track(this.mdlFuelPump, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 32));
        this.mdlSpeed = this.track(this.mdlSpeed, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 8));
        this.mdlKnock = this.track(this.mdlKnock, (UnpluggableValueModel)baseRecord.numberFieldAsBoolean("DTCEnableBits", 16));
    }

    public static boolean canDisplay(Map map) {
        return RecordSet.containsRecordId(-1, map) && RecordSet.containsRecordId(17, map);
    }

    @Override
    protected boolean isCompatibleWith(Map map) {
        return RecordSet.containsRecordId(17, map);
    }
}

